/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import java.io.IOException;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.FillImageBorder;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.WindowPane;
import nextapp.echo2.app.update.PropertyUpdate;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.image.ImageTools;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class WindowPanePeer
implements ActionProcessor,
ImageRenderSupport,
PropertyUpdateProcessor,
ComponentSynchronizePeer {
    public static final String PROPERTY_IE_ALPHA_RENDER_BORDER = "nextapp.echo2.webcontainer.syncpeer.WindowPanePeer.ieAlphaRenderBorder";
    private static final String IMAGE_ID_TITLE_BACKGROUND = "titleBackground";
    private static final String IMAGE_ID_CLOSE_ICON = "close";
    private static final String IMAGE_ID_ICON = "icon";
    private static final String IMAGE_ID_BACKGROUND = "background";
    private static final String IMAGE_ID_BORDER_TOP_LEFT = "borderTopLeft";
    private static final String IMAGE_ID_BORDER_TOP = "borderTop";
    private static final String IMAGE_ID_BORDER_TOP_RIGHT = "borderTopRight";
    private static final String IMAGE_ID_BORDER_LEFT = "borderLeft";
    private static final String IMAGE_ID_BORDER_RIGHT = "borderRight";
    private static final String IMAGE_ID_BORDER_BOTTOM_LEFT = "borderBottomLeft";
    private static final String IMAGE_ID_BORDER_BOTTOM = "borderBottom";
    private static final String IMAGE_ID_BORDER_BOTTOM_RIGHT = "borderBottomRight";
    private static final ImageReference DEFAULT_CLOSE_ICON = new ResourceImageReference("/nextapp/echo2/webcontainer/resource/image/DefaultCloseButton.gif");
    private static final String[] FILL_IMAGE_NAMES = new String[]{"tl", "t", "tr", "l", "r", "bl", "b", "br"};
    private static final String[] FILL_IMAGE_IDS = new String[]{"borderTopLeft", "borderTop", "borderTopRight", "borderLeft", "borderRight", "borderBottomLeft", "borderBottom", "borderBottomRight"};
    private static final String BLANK_HTML_STRING = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title></title><body></body></html>";
    private static final Service BLANK_HTML_SERVICE = new Service(){

        public String getId() {
            return "Echo.WindowPane.IFrame";
        }

        public int getVersion() {
            return 0;
        }

        public void service(Connection conn) throws IOException {
            conn.setContentType(ContentType.TEXT_HTML);
            conn.getWriter().write(WindowPanePeer.BLANK_HTML_STRING);
        }
    };
    public static final Service WINDOW_PANE_SERVICE = JavaScriptService.forResource((String)"Echo.WindowPane", (String)"/nextapp/echo2/webcontainer/resource/js/WindowPane.js");
    private PartialUpdateParticipant placeHolder = new PartialUpdateParticipant(){

        public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
            return true;
        }

        public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
        }
    };
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    private static void renderPixelProperty(WindowPane windowPane, String propertyName, Element element, String attributeName) {
        String pixelValue;
        Extent extent = (Extent)windowPane.getRenderProperty(propertyName);
        if (extent != null && (pixelValue = ExtentRender.renderCssAttributePixelValue(extent)) != null) {
            element.setAttribute(attributeName, pixelValue);
        }
    }

    public WindowPanePeer() {
        this.partialUpdateManager.add("positionX", this.placeHolder);
        this.partialUpdateManager.add("positionY", this.placeHolder);
        this.partialUpdateManager.add("width", this.placeHolder);
        this.partialUpdateManager.add("height", this.placeHolder);
        this.partialUpdateManager.add("title", this.placeHolder);
    }

    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_content";
    }

    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_TITLE_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("titleBackgroundImage");
            return backgroundImage == null ? null : backgroundImage.getImage();
        }
        if (IMAGE_ID_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("backgroundImage");
            return backgroundImage == null ? null : backgroundImage.getImage();
        }
        if (IMAGE_ID_ICON.equals(imageId)) {
            return (ImageReference)component.getRenderProperty(IMAGE_ID_ICON);
        }
        if (IMAGE_ID_CLOSE_ICON.equals(imageId)) {
            return (ImageReference)component.getRenderProperty("closeIcon", (Object)DEFAULT_CLOSE_ICON);
        }
        if (IMAGE_ID_BORDER_TOP_LEFT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(0);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_TOP.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(1);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_TOP_RIGHT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(2);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_LEFT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(3);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_RIGHT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(4);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_BOTTOM_LEFT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(5);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_BOTTOM.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(6);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_BOTTOM_RIGHT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(7);
            return fillImage == null ? null : fillImage.getImage();
        }
        return null;
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        WindowPane windowPane = (WindowPane)component;
        boolean closable = (Boolean)windowPane.getRenderProperty("closable", (Object)Boolean.TRUE);
        if (closable) {
            ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "input_close", null);
        }
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        WindowPane windowPane = (WindowPane)component;
        boolean movable = (Boolean)windowPane.getRenderProperty("movable", (Object)Boolean.TRUE);
        boolean resizable = (Boolean)windowPane.getRenderProperty("resizable", (Object)Boolean.TRUE);
        if ("positionX".equals(propertyName)) {
            if (movable) {
                ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "positionX", (Object)ExtentRender.toExtent(propertyElement.getAttribute("value")));
            }
        } else if ("positionY".equals(propertyName)) {
            if (movable) {
                ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "positionY", (Object)ExtentRender.toExtent(propertyElement.getAttribute("value")));
            }
        } else if ("width".equals(propertyName)) {
            if (resizable) {
                ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "width", (Object)ExtentRender.toExtent(propertyElement.getAttribute("value")));
            }
        } else if ("height".equals(propertyName)) {
            if (resizable) {
                ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "height", (Object)ExtentRender.toExtent(propertyElement.getAttribute("value")));
            }
        } else if ("zIndex".equals(propertyName)) {
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "zIndex", (Object)new Integer(propertyElement.getAttribute("value")));
        }
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(WINDOW_PANE_SERVICE.getId());
        WindowPane windowPane = (WindowPane)component;
        this.renderInitDirective(rc, windowPane, targetId);
        Component[] children = windowPane.getVisibleComponents();
        if (children.length != 0) {
            ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(children[0].getClass());
            syncPeer.renderAdd(rc, update, this.getContainerId(children[0]), children[0]);
        }
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(WINDOW_PANE_SERVICE.getId());
        this.renderDisposeDirective(rc, (WindowPane)component);
    }

    private void renderDisposeDirective(RenderContext rc, WindowPane windowPane) {
        String elementId = ContainerInstance.getElementId((Component)windowPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("preremove", "EchoWindowPane.MessageProcessor", "dispose");
        initElement.setAttribute("eid", elementId);
    }

    private void renderInitDirective(RenderContext rc, WindowPane windowPane, String targetId) {
        Boolean movableBoolean;
        Boolean resizableBoolean;
        FillImage titleBackgroundImage;
        Insets titleBarInsets;
        String title;
        int fillImageRenderFlags;
        Font font;
        Color foreground;
        FillImage backgroundImage;
        Color background;
        Insets insets;
        String elementId = ContainerInstance.getElementId((Component)windowPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("update", "EchoWindowPane.MessageProcessor");
        Element initElement = serverMessage.getDocument().createElement("init");
        initElement.setAttribute("container-eid", targetId);
        initElement.setAttribute("eid", elementId);
        if (!windowPane.isRenderEnabled()) {
            initElement.setAttribute("enabled", "false");
        }
        if (windowPane.getZIndex() != 0) {
            initElement.setAttribute("z-index", Integer.toString(windowPane.getZIndex()));
        }
        if ((insets = (Insets)windowPane.getRenderProperty("insets")) != null) {
            initElement.setAttribute("insets", InsetsRender.renderCssAttributeValue(insets));
        }
        if ((background = (Color)windowPane.getRenderProperty(IMAGE_ID_BACKGROUND)) != null) {
            initElement.setAttribute(IMAGE_ID_BACKGROUND, ColorRender.renderCssAttributeValue(background));
        }
        if ((backgroundImage = (FillImage)windowPane.getRenderProperty("backgroundImage")) != null) {
            CssStyle backgroundImageCssStyle = new CssStyle();
            FillImageRender.renderToStyle(backgroundImageCssStyle, rc, this, (Component)windowPane, IMAGE_ID_BACKGROUND, backgroundImage, 0);
            initElement.setAttribute("background-image", backgroundImageCssStyle.renderInline());
        }
        if ((foreground = (Color)windowPane.getRenderProperty("foreground")) != null) {
            initElement.setAttribute("foreground", ColorRender.renderCssAttributeValue(foreground));
        }
        if ((font = (Font)windowPane.getRenderProperty("font")) != null) {
            CssStyle fontCssStyle = new CssStyle();
            FontRender.renderToStyle(fontCssStyle, font);
            initElement.setAttribute("font", fontCssStyle.renderInline());
        }
        WindowPanePeer.renderPixelProperty(windowPane, "positionX", initElement, "position-x");
        WindowPanePeer.renderPixelProperty(windowPane, "positionY", initElement, "position-y");
        WindowPanePeer.renderPixelProperty(windowPane, "width", initElement, "width");
        WindowPanePeer.renderPixelProperty(windowPane, "height", initElement, "height");
        WindowPanePeer.renderPixelProperty(windowPane, "minimumWidth", initElement, "minimum-width");
        WindowPanePeer.renderPixelProperty(windowPane, "minimumHeight", initElement, "minimum-height");
        WindowPanePeer.renderPixelProperty(windowPane, "maximumWidth", initElement, "maximum-width");
        WindowPanePeer.renderPixelProperty(windowPane, "maximumHeight", initElement, "maximum-height");
        int n = fillImageRenderFlags = (Boolean)windowPane.getRenderProperty(PROPERTY_IE_ALPHA_RENDER_BORDER, (Object)Boolean.FALSE) != false ? 2 : 0;
        if (windowPane.getRenderProperty(IMAGE_ID_ICON) != null) {
            initElement.setAttribute(IMAGE_ID_ICON, ImageTools.getUri(rc, this, (Component)windowPane, IMAGE_ID_ICON));
            Insets iconInsets = (Insets)windowPane.getRenderProperty("iconInsets");
            if (iconInsets != null) {
                initElement.setAttribute("icon-insets", InsetsRender.renderCssAttributeValue(iconInsets));
            }
        }
        if ((title = (String)windowPane.getRenderProperty("title")) != null) {
            Font titleFont;
            initElement.setAttribute("title", title);
            Insets titleInsets = (Insets)windowPane.getRenderProperty("titleInsets");
            Color titleForeground = (Color)windowPane.getRenderProperty("titleForeground");
            if (titleForeground != null) {
                initElement.setAttribute("title-foreground", ColorRender.renderCssAttributeValue(titleForeground));
            }
            if (titleInsets != null) {
                initElement.setAttribute("title-insets", InsetsRender.renderCssAttributeValue(titleInsets));
            }
            if ((titleFont = (Font)windowPane.getRenderProperty("titleFont")) != null) {
                CssStyle fontCssStyle = new CssStyle();
                FontRender.renderToStyle(fontCssStyle, titleFont);
                initElement.setAttribute("title-font", fontCssStyle.renderInline());
            }
        }
        if ((titleBarInsets = (Insets)windowPane.getRenderProperty("titleBarInsets")) != null) {
            initElement.setAttribute("title-bar-insets", InsetsRender.renderCssAttributeValue(titleBarInsets));
        }
        WindowPanePeer.renderPixelProperty(windowPane, "titleHeight", initElement, "title-height");
        Color titleBackground = (Color)windowPane.getRenderProperty(IMAGE_ID_TITLE_BACKGROUND);
        if (titleBackground != null) {
            initElement.setAttribute("title-background", ColorRender.renderCssAttributeValue(titleBackground));
        }
        if ((titleBackgroundImage = (FillImage)windowPane.getRenderProperty("titleBackgroundImage")) != null) {
            CssStyle titleBackgroundImageCssStyle = new CssStyle();
            FillImageRender.renderToStyle(titleBackgroundImageCssStyle, rc, this, (Component)windowPane, IMAGE_ID_TITLE_BACKGROUND, titleBackgroundImage, fillImageRenderFlags);
            initElement.setAttribute("title-background-image", titleBackgroundImageCssStyle.renderInline());
        }
        boolean resizable = (resizableBoolean = (Boolean)windowPane.getRenderProperty("resizable")) == null ? true : resizableBoolean;
        initElement.setAttribute("resizable", resizable ? "true" : "false");
        Boolean closableBoolean = (Boolean)windowPane.getRenderProperty("closable");
        boolean closable = closableBoolean == null ? true : closableBoolean;
        initElement.setAttribute("closable", closable ? "true" : "false");
        if (closable && this.getImage((Component)windowPane, IMAGE_ID_CLOSE_ICON) != null) {
            initElement.setAttribute("close-icon", ImageTools.getUri(rc, this, (Component)windowPane, IMAGE_ID_CLOSE_ICON));
            Insets closeIconInsets = (Insets)windowPane.getRenderProperty("closeIconInsets");
            if (closeIconInsets != null) {
                initElement.setAttribute("close-icon-insets", InsetsRender.renderCssAttributeValue(closeIconInsets));
            }
        }
        boolean movable = (movableBoolean = (Boolean)windowPane.getRenderProperty("movable")) == null ? true : movableBoolean;
        initElement.setAttribute("movable", movable ? "true" : "false");
        FillImageBorder border = (FillImageBorder)windowPane.getRenderProperty("border");
        if (border != null && border.getBorderInsets() != null && border.getContentInsets() != null) {
            Element borderElement = serverMessage.getDocument().createElement("border");
            if (border.getColor() != null) {
                borderElement.setAttribute("color", ColorRender.renderCssAttributeValue(border.getColor()));
            }
            borderElement.setAttribute("border-insets", InsetsRender.renderCssAttributeValue(border.getBorderInsets()));
            borderElement.setAttribute("content-insets", InsetsRender.renderCssAttributeValue(border.getContentInsets()));
            for (int i = 0; i < 8; ++i) {
                FillImage fillImage = border.getFillImage(i);
                if (fillImage == null) continue;
                Element imageElement = serverMessage.getDocument().createElement("image");
                imageElement.setAttribute("name", FILL_IMAGE_NAMES[i]);
                CssStyle fillImageCssStyle = new CssStyle();
                FillImageRender.renderToStyle(fillImageCssStyle, rc, this, (Component)windowPane, FILL_IMAGE_IDS[i], fillImage, fillImageRenderFlags);
                imageElement.setAttribute("value", fillImageCssStyle.renderInline());
                borderElement.appendChild(imageElement);
            }
            initElement.appendChild(borderElement);
        }
        partElement.appendChild(initElement);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties()) {
            if (this.partialUpdateManager.canProcess(rc, update)) {
                this.renderUpdateDirective(rc, update);
            } else {
                fullReplace = true;
            }
        }
        if (update.hasAddedChildren() || update.hasRemovedChildren() || update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        }
        if (fullReplace) {
            this.renderDisposeDirective(rc, (WindowPane)update.getParent());
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId(update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            this.partialUpdateManager.process(rc, update);
        }
        return fullReplace;
    }

    private void renderUpdateDirective(RenderContext rc, ServerComponentUpdate update) {
        PropertyUpdate height;
        PropertyUpdate width;
        PropertyUpdate positionY;
        WindowPane windowPane = (WindowPane)update.getParent();
        Element updateElement = rc.getServerMessage().appendPartDirective("preremove", "EchoWindowPane.MessageProcessor", "update");
        String elementId = ContainerInstance.getElementId((Component)windowPane);
        updateElement.setAttribute("eid", elementId);
        PropertyUpdate positionX = update.getUpdatedProperty("positionX");
        if (positionX != null) {
            WindowPanePeer.renderPixelProperty(windowPane, "positionX", updateElement, "position-x");
        }
        if ((positionY = update.getUpdatedProperty("positionY")) != null) {
            WindowPanePeer.renderPixelProperty(windowPane, "positionY", updateElement, "position-y");
        }
        if ((width = update.getUpdatedProperty("width")) != null) {
            WindowPanePeer.renderPixelProperty(windowPane, "width", updateElement, "width");
        }
        if ((height = update.getUpdatedProperty("height")) != null) {
            WindowPanePeer.renderPixelProperty(windowPane, "height", updateElement, "height");
        }
        if (update.getUpdatedProperty("title") != null) {
            updateElement.setAttribute("title", (String)windowPane.getRenderProperty("title", (Object)" "));
        }
    }

    static {
        WebRenderServlet.getServiceRegistry().add(WINDOW_PANE_SERVICE);
        WebRenderServlet.getServiceRegistry().add(BLANK_HTML_SERVICE);
    }
}

