/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.webcontainer.sync.component;

import nextapp.echo.app.Component;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.extras.app.menu.AbstractMenuComponent;
import nextapp.echo.extras.app.menu.ItemModel;
import nextapp.echo.extras.app.menu.MenuModel;
import nextapp.echo.extras.app.menu.MenuStateModel;
import nextapp.echo.extras.app.menu.ToggleOptionModel;
import nextapp.echo.extras.webcontainer.CommonResources;
import nextapp.echo.extras.webcontainer.service.CommonService;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.ResourceRegistry;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;
import org.w3c.dom.Element;

abstract class AbstractMenuPeer
extends AbstractComponentSynchronizePeer {
    private static final Service MENU_SERVICE = JavaScriptService.forResources((String)"EchoExtras.Menu", (String[])new String[]{"nextapp/echo/extras/webcontainer/resource/Application.Menu.js", "nextapp/echo/extras/webcontainer/resource/Serial.Menu.js", "nextapp/echo/extras/webcontainer/resource/Sync.Menu.js"});
    static /* synthetic */ Class class$nextapp$echo$app$serial$SerialContext;
    static /* synthetic */ Class class$nextapp$echo$app$update$ClientUpdateManager;

    public AbstractMenuPeer() {
        this.addOutputProperty("stateModel");
        this.addOutputProperty("model");
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("action", "actionListeners"){

            public boolean hasListeners(Context context, Component component) {
                return ((AbstractMenuComponent)component).hasActionListeners();
            }

            public void processEvent(Context context, Component component, Object eventData) {
                AbstractMenuComponent menuComponent = (AbstractMenuComponent)component;
                ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(class$nextapp$echo$app$update$ClientUpdateManager == null ? (class$nextapp$echo$app$update$ClientUpdateManager = AbstractMenuPeer.class$("nextapp.echo.app.update.ClientUpdateManager")) : class$nextapp$echo$app$update$ClientUpdateManager);
                clientUpdateManager.setComponentAction((Component)menuComponent, "action", (Object)AbstractMenuPeer.this.getItemModel(menuComponent, (String)eventData));
            }
        });
    }

    public Class getEventDataClass(String eventType) {
        if ("action".equals(eventType)) {
            return String.class;
        }
        return super.getEventDataClass(eventType);
    }

    protected ItemModel getItemModel(AbstractMenuComponent menu, String itemPath) {
        MenuModel itemModel = menu.getModel();
        String[] tokens = itemPath.split("\\.");
        for (int i = 0; i < tokens.length; ++i) {
            int index = Integer.parseInt(tokens[i]);
            itemModel = itemModel.getItem(index);
        }
        return itemModel;
    }

    protected ItemModel getItemModelById(AbstractMenuComponent menu, String id) {
        return this.getItemModelById(menu.getModel(), id);
    }

    protected ItemModel getItemModelById(MenuModel menuModel, String id) {
        int size = menuModel.getItemCount();
        for (int i = 0; i < size; ++i) {
            ItemModel itemModel = menuModel.getItem(i);
            if (id.equals(itemModel.getId())) {
                return itemModel;
            }
            if (!(itemModel instanceof MenuModel) || (itemModel = this.getItemModelById((MenuModel)itemModel, id)) == null) continue;
            return itemModel;
        }
        return null;
    }

    protected String getItemPath(MenuModel menuModel, ItemModel targetItemModel) {
        StringBuffer out = new StringBuffer();
        this.getItemPath(menuModel, targetItemModel, out);
        return out.length() == 0 ? null : out.toString();
    }

    private void getItemPath(MenuModel menuModel, ItemModel targetItemModel, StringBuffer out) {
        int itemCount = menuModel.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            ItemModel currentItemModel = menuModel.getItem(i);
            if (targetItemModel.equals(currentItemModel)) {
                out.append(i);
                return;
            }
            if (currentItemModel instanceof MenuModel) {
                this.getItemPath((MenuModel)currentItemModel, targetItemModel, out);
            }
            if (out.length() == 0) continue;
            out.insert(0, i + ".");
            return;
        }
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        AbstractMenuComponent menu = (AbstractMenuComponent)component;
        if ("model".equals(propertyName)) {
            return menu.getModel();
        }
        if ("stateModel".equals(propertyName)) {
            return new RenderedMenuStateModel(menu.getModel(), menu.getStateModel());
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(CommonService.INSTANCE.getId());
        serverMessage.addLibrary(MENU_SERVICE.getId());
    }

    static {
        WebContainerServlet.getServiceRegistry().add(MENU_SERVICE);
        CommonResources.install();
        ResourceRegistry resources = WebContainerServlet.getResourceRegistry();
        resources.add("Extras", "image/menu/ArrowDown.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/menu/ArrowLeft.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/menu/ArrowRight.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/menu/ToggleOff.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/menu/ToggleOn.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/menu/RadioOff.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/menu/RadioOn.gif", ContentType.IMAGE_GIF);
    }

    public static class RenderedMenuStateModelPropertyPeer
    implements SerialPropertyPeer {
        public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
            throw new UnsupportedOperationException();
        }

        public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) {
            RenderedMenuStateModel menuData = (RenderedMenuStateModel)propertyValue;
            propertyElement.setAttribute("t", "Extras.Serial.MenuStateModel");
            SerialContext serialContext = (SerialContext)context.get(class$nextapp$echo$app$serial$SerialContext == null ? (class$nextapp$echo$app$serial$SerialContext = AbstractMenuPeer.class$("nextapp.echo.app.serial.SerialContext")) : class$nextapp$echo$app$serial$SerialContext);
            this.writeMenuModel(serialContext, propertyElement, (ItemModel)menuData.getMenuModel(), menuData.getMenuStateModel());
        }

        private void writeMenuModel(SerialContext serialContext, Element propertyElement, ItemModel itemModel, MenuStateModel menuStateModel) {
            String id = itemModel.getId();
            if (id != null) {
                Element itemElement = serialContext.getDocument().createElement("i");
                itemElement.setAttribute("id", id);
                if (!menuStateModel.isEnabled(id)) {
                    itemElement.setAttribute("enabled", "false");
                }
                if (itemModel instanceof ToggleOptionModel && menuStateModel.isSelected(id)) {
                    itemElement.setAttribute("selected", "true");
                }
                if (itemElement.getAttributes().getLength() > 1) {
                    propertyElement.appendChild(itemElement);
                }
            }
            if (itemModel instanceof MenuModel) {
                MenuModel menuModel = (MenuModel)itemModel;
                int size = menuModel.getItemCount();
                for (int i = 0; i < size; ++i) {
                    this.writeMenuModel(serialContext, propertyElement, menuModel.getItem(i), menuStateModel);
                }
            }
        }
    }

    private static class RenderedMenuStateModel {
        private MenuModel menuModel;
        private MenuStateModel menuStateModel;

        RenderedMenuStateModel(MenuModel menuModel, MenuStateModel menuStateModel) {
            this.menuModel = menuModel;
            this.menuStateModel = menuStateModel;
        }

        MenuModel getMenuModel() {
            return this.menuModel;
        }

        MenuStateModel getMenuStateModel() {
            return this.menuStateModel;
        }
    }
}

