/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.webcontainer.sync.component;

import java.util.Iterator;
import nextapp.echo.app.Component;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.extras.app.DragSource;
import nextapp.echo.extras.webcontainer.service.CommonService;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;

public class DragSourcePeer
extends AbstractComponentSynchronizePeer {
    private static final Service DRAG_SOURCE_SERVICE = JavaScriptService.forResources((String)"EchoExtras.DragSource", (String[])new String[]{"nextapp/echo/extras/webcontainer/resource/Application.DragSource.js", "nextapp/echo/extras/webcontainer/resource/Sync.DragSource.js"});
    private static final String DROP_TARGET_IDS = "dropTargetIds";
    static /* synthetic */ Class class$nextapp$echo$app$update$ClientUpdateManager;

    public DragSourcePeer() {
        this.addOutputProperty(DROP_TARGET_IDS, true);
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("drop", "dropListeners", String.class){

            public boolean hasListeners(Context context, Component component) {
                return ((DragSource)component).hasDropListeners();
            }

            public void processEvent(Context context, Component component, Object eventData) {
                ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(class$nextapp$echo$app$update$ClientUpdateManager == null ? (class$nextapp$echo$app$update$ClientUpdateManager = DragSourcePeer.class$("nextapp.echo.app.update.ClientUpdateManager")) : class$nextapp$echo$app$update$ClientUpdateManager);
                UserInstance userInstance = (UserInstance)context.get(class$nextapp$echo$webcontainer$UserInstance == null ? (class$nextapp$echo$webcontainer$UserInstance = DragSourcePeer.class$("nextapp.echo.webcontainer.UserInstance")) : class$nextapp$echo$webcontainer$UserInstance);
                Component specificComponent = userInstance.getComponentByClientRenderId((String)eventData);
                clientUpdateManager.setComponentAction(component, "drop", (Object)specificComponent);
            }
        });
    }

    public String getClientComponentType(boolean mode) {
        return "Extras.DragSource";
    }

    public Class getComponentClass() {
        return DragSource.class;
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if (propertyName.equals(DROP_TARGET_IDS)) {
            DragSource dragSource = (DragSource)component;
            UserInstance userInstance = (UserInstance)context.get(UserInstance.class);
            String dropTargetId = dragSource.getDropTarget(propertyIndex);
            Component dropTarget = component.getApplicationInstance().getComponentByRenderId(dropTargetId);
            if (dropTarget == null) {
                return null;
            }
            return userInstance.getClientRenderId(dropTarget);
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public Iterator getOutputPropertyIndices(Context context, Component component, String propertyName) {
        if (propertyName.equals(DROP_TARGET_IDS)) {
            DragSource dragSource = (DragSource)component;
            final int count = dragSource.getDropTargetCount();
            return new Iterator(){
                int i = 0;

                public boolean hasNext() {
                    return this.i < count;
                }

                public Object next() {
                    return new Integer(this.i++);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return super.getOutputPropertyIndices(context, component, propertyName);
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(CommonService.INSTANCE.getId());
        serverMessage.addLibrary(DRAG_SOURCE_SERVICE.getId());
    }

    static {
        WebContainerServlet.getServiceRegistry().add(DRAG_SOURCE_SERVICE);
    }
}

