/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.webcontainer.sync.component;

import nextapp.echo.app.Component;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.extras.app.DropDownMenu;
import nextapp.echo.extras.app.menu.AbstractMenuComponent;
import nextapp.echo.extras.app.menu.ItemModel;
import nextapp.echo.extras.app.menu.MenuSelectionModel;
import nextapp.echo.extras.webcontainer.sync.component.AbstractMenuPeer;

public class DropDownMenuPeer
extends AbstractMenuPeer {
    private static final String PROPERTY_SELECTION = "selection";
    private static final String PROPERTY_SELECTION_ENABLED = "selectionEnabled";

    public DropDownMenuPeer() {
        this.addOutputProperty(PROPERTY_SELECTION);
        this.addOutputProperty(PROPERTY_SELECTION_ENABLED);
    }

    public String getClientComponentType(boolean mode) {
        return "Extras.DropDownMenu";
    }

    public Class getComponentClass() {
        return DropDownMenu.class;
    }

    public Class getInputPropertyClass(String propertyName) {
        if (PROPERTY_SELECTION.equals(propertyName)) {
            return String.class;
        }
        if (PROPERTY_SELECTION_ENABLED.equals(propertyName)) {
            return Boolean.class;
        }
        return super.getInputPropertyClass(propertyName);
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        DropDownMenu menu = (DropDownMenu)component;
        if (PROPERTY_SELECTION.equals(propertyName)) {
            String selectedId;
            MenuSelectionModel selectionModel = menu.getSelectionModel();
            if (selectionModel != null && (selectedId = selectionModel.getSelectedId()) != null) {
                return this.getItemPath(menu.getModel(), this.getItemModelById((AbstractMenuComponent)menu, selectedId));
            }
            return null;
        }
        if (PROPERTY_SELECTION_ENABLED.equals(propertyName)) {
            return menu.getSelectionModel() != null;
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int index, Object newValue) {
        if (PROPERTY_SELECTION.equals(propertyName)) {
            ItemModel itemModel = this.getItemModel((AbstractMenuComponent)component, (String)newValue);
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            clientUpdateManager.setComponentProperty(component, PROPERTY_SELECTION, (Object)itemModel);
        }
    }
}

