/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.webcontainer.sync.component;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import nextapp.echo.app.Button;
import nextapp.echo.app.Column;
import nextapp.echo.app.Component;
import nextapp.echo.app.ContentPane;
import nextapp.echo.app.Grid;
import nextapp.echo.app.Label;
import nextapp.echo.app.Panel;
import nextapp.echo.app.Row;
import nextapp.echo.app.SelectField;
import nextapp.echo.app.SplitPane;
import nextapp.echo.app.TextField;
import nextapp.echo.app.WindowPane;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.extras.app.ColorSelect;
import nextapp.echo.extras.app.MenuBarPane;
import nextapp.echo.extras.app.RichTextArea;
import nextapp.echo.extras.webcontainer.CommonResources;
import nextapp.echo.extras.webcontainer.service.CommonService;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.ResourceRegistry;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;

public class RichTextAreaPeer
extends AbstractComponentSynchronizePeer {
    private static final String RESOURCE_DIR = "nextapp/echo/extras/webcontainer/resource/";
    private static final Service RICH_TEXT_AREA_SERVICE = JavaScriptService.forResources((String)"EchoExtras.RichTextArea", (String[])new String[]{"nextapp/echo/extras/webcontainer/resource/Application.RichTextInput.js", "nextapp/echo/extras/webcontainer/resource/Application.RichTextArea.js", "nextapp/echo/extras/webcontainer/resource/Sync.RichTextInput.js", "nextapp/echo/extras/webcontainer/resource/Sync.RichTextArea.js", "nextapp/echo/extras/webcontainer/resource/RemoteClient.RichTextArea.js"});
    private static final Map LOCALE_SERVICES = new HashMap();

    private static void addLocaleService(Locale locale, String localeCode) {
        JavaScriptService service = JavaScriptService.forResource((String)("EchoExtras.RichTextArea." + localeCode), (String)("nextapp/echo/extras/webcontainer/resource/SyncLocale.RichTextArea." + localeCode + ".js"));
        WebContainerServlet.getServiceRegistry().add((Service)service);
        LOCALE_SERVICES.put(locale, service);
    }

    public RichTextAreaPeer() {
        this.addRequiredComponentClass(Button.class);
        this.addRequiredComponentClass(ColorSelect.class);
        this.addRequiredComponentClass(Column.class);
        this.addRequiredComponentClass(ContentPane.class);
        this.addRequiredComponentClass(Grid.class);
        this.addRequiredComponentClass(Label.class);
        this.addRequiredComponentClass(MenuBarPane.class);
        this.addRequiredComponentClass(Panel.class);
        this.addRequiredComponentClass(Row.class);
        this.addRequiredComponentClass(SelectField.class);
        this.addRequiredComponentClass(SplitPane.class);
        this.addRequiredComponentClass(TextField.class);
        this.addRequiredComponentClass(WindowPane.class);
        this.addOutputProperty("text");
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("action", "actionListeners"){

            public boolean hasListeners(Context context, Component c) {
                return ((RichTextArea)c).hasActionListeners();
            }
        });
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("operation", "operationListeners"){

            public Class getEventDataClass() {
                return class$java$lang$String == null ? (class$java$lang$String = RichTextAreaPeer.class$("java.lang.String")) : class$java$lang$String;
            }

            public boolean hasListeners(Context context, Component c) {
                return ((RichTextArea)c).hasOperationListeners();
            }
        });
    }

    public Class getComponentClass() {
        return RichTextArea.class;
    }

    public String getClientComponentType(boolean mode) {
        return "Extras.RemoteRichTextArea";
    }

    public Class getInputPropertyClass(String propertyName) {
        if ("text".equals(propertyName)) {
            return String.class;
        }
        return null;
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if (propertyName.equals("text")) {
            RichTextArea rta = (RichTextArea)component;
            return rta.getText();
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(CommonService.INSTANCE.getId());
        serverMessage.addLibrary(RICH_TEXT_AREA_SERVICE.getId());
        this.installLocaleService(context, component);
    }

    private void installLocaleService(Context context, Component component) {
        Locale locale = component.getRenderLocale();
        if (LOCALE_SERVICES.containsKey(locale)) {
            ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
            serverMessage.addLibrary(((Service)LOCALE_SERVICES.get(locale)).getId());
        }
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int propertyIndex, Object newValue) {
        if (propertyName.equals("text")) {
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            clientUpdateManager.setComponentProperty(component, "text", newValue);
        }
    }

    static {
        WebContainerServlet.getServiceRegistry().add(RICH_TEXT_AREA_SERVICE);
        RichTextAreaPeer.addLocaleService(Locale.GERMAN, "de");
        CommonResources.install();
        ResourceRegistry resources = WebContainerServlet.getResourceRegistry();
        resources.add("Extras", "image/richtext/Icon16Alignment.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16AlignmentCenter.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16AlignmentJustify.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16AlignmentLeft.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16AlignmentRight.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Background.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Bold.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16BulletedList.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Copy.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Cut.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Delete.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Foreground.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16HorizontalRule.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Hyperlink.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Image.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Indent.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Italic.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16NumberedList.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Outdent.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Paste.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16ParagraphStyle.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16PlainText.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Redo.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16SelectAll.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Strikethrough.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Subscript.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Superscript.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Table.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16TableInsertRow.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16TableDeleteRow.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16TableInsertColumn.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16TableDeleteColumn.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16TextStyle.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Underline.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon16Undo.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon24Ok.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/richtext/Icon24Cancel.png", ContentType.IMAGE_PNG);
    }
}

