/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.webcontainer.sync.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import nextapp.echo.app.Component;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.update.ServerComponentUpdate;
import nextapp.echo.app.util.Context;
import nextapp.echo.extras.app.Tree;
import nextapp.echo.extras.app.event.TreeExpansionEvent;
import nextapp.echo.extras.app.event.TreeExpansionListener;
import nextapp.echo.extras.app.tree.TreeModel;
import nextapp.echo.extras.app.tree.TreePath;
import nextapp.echo.extras.app.tree.TreeSelectionModel;
import nextapp.echo.extras.webcontainer.CommonResources;
import nextapp.echo.extras.webcontainer.service.CommonService;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.RenderState;
import nextapp.echo.webcontainer.ResourceRegistry;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;
import nextapp.echo.webcontainer.util.MultiIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TreePeer
extends AbstractComponentSynchronizePeer {
    private static final String PROPERTY_TREE_STRUCTURE = "treeStructure";
    private static final String PROPERTY_COLUMN_COUNT = "columnCount";
    private static final String PROPERTY_COLUMN_WIDTH = "columnWidth";
    private static final String PROPERTY_SELECTION_MODE = "selectionMode";
    private static final String EXPANSION_PROPERTY = "expansion";
    private static final String SELECTION_PROPERTY = "selectionUpdate";
    private static final String[] MODEL_CHANGED_UPDATE_PROPERTIES = new String[]{"treeStructure", "columnCount"};
    private static final Service TREE_SERVICE = JavaScriptService.forResources((String)"EchoExtras.RemoteTree", (String[])new String[]{"nextapp/echo/extras/webcontainer/resource/Application.RemoteTree.js", "nextapp/echo/extras/webcontainer/resource/Serial.RemoteTree.js", "nextapp/echo/extras/webcontainer/resource/Sync.RemoteTree.js"});

    private static int getColumnCount(Tree tree) {
        return tree.getColumnModel().getColumnCount();
    }

    private static String getSelectionString(Context context, TreeSelectionModel selectionModel, Tree tree) {
        UserInstance userInstance = (UserInstance)context.get(UserInstance.class);
        TreeRenderState renderState = (TreeRenderState)userInstance.getRenderState((Component)tree);
        StringBuffer selection = new StringBuffer();
        TreePath[] paths = selectionModel.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            Component component = tree.getComponent(path, 0);
            if (component == null) {
                if (renderState == null) continue;
                renderState.addUnsentSelection(path);
                continue;
            }
            String id = userInstance.getClientRenderId(component);
            if (renderState != null) {
                renderState.removeUnsentSelection(path);
            }
            if (selection.length() > 0) {
                selection.append(",");
            }
            selection.append(id);
        }
        return selection.toString();
    }

    public TreePeer() {
        this.addOutputProperty(PROPERTY_TREE_STRUCTURE);
        this.addOutputProperty(PROPERTY_COLUMN_COUNT);
        this.addOutputProperty(PROPERTY_COLUMN_WIDTH, true);
        this.addOutputProperty(PROPERTY_SELECTION_MODE);
        this.addOutputProperty("selection");
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("action", "actionListeners"));
    }

    public Class getComponentClass() {
        return Tree.class;
    }

    public String getClientComponentType(boolean mode) {
        return "Extras.RemoteTree";
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        Tree tree = (Tree)component;
        if (PROPERTY_TREE_STRUCTURE.equals(propertyName)) {
            return new TreeStructure(tree);
        }
        if (PROPERTY_COLUMN_COUNT.equals(propertyName)) {
            return new Integer(TreePeer.getColumnCount(tree));
        }
        if (PROPERTY_COLUMN_WIDTH.equals(propertyName)) {
            return tree.getColumnModel().getColumn(propertyIndex).getWidth();
        }
        if (PROPERTY_SELECTION_MODE.equals(propertyName)) {
            return new Integer(tree.getSelectionModel().getSelectionMode());
        }
        if ("selection".equals(propertyName)) {
            return TreePeer.getSelectionString(context, tree.getSelectionModel(), tree);
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public Iterator getOutputPropertyIndices(Context context, Component component, String propertyName) {
        if (PROPERTY_COLUMN_WIDTH.equals(propertyName)) {
            final Iterator columnIterator = ((Tree)component).getColumnModel().getColumns();
            return new Iterator(){
                private int i = 0;

                public boolean hasNext() {
                    return columnIterator.hasNext();
                }

                public Object next() {
                    columnIterator.next();
                    return new Integer(this.i++);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return super.getOutputPropertyIndices(context, component, propertyName);
    }

    public Iterator getUpdatedOutputPropertyNames(Context context, Component component, ServerComponentUpdate update) {
        UserInstance userInstance = (UserInstance)context.get(UserInstance.class);
        Iterator normalPropertyIterator = super.getUpdatedOutputPropertyNames(context, component, update);
        HashSet<String> extraProperties = new HashSet<String>();
        if (update.hasRemovedChildren() || update.hasRemovedDescendants()) {
            userInstance.removeRenderState(component);
            extraProperties.add(PROPERTY_TREE_STRUCTURE);
            extraProperties.add("selection");
        }
        if (update.hasUpdatedProperty("model")) {
            extraProperties.addAll(Arrays.asList(MODEL_CHANGED_UPDATE_PROPERTIES));
        }
        if (update.hasUpdatedProperty("expansionState")) {
            TreeRenderState renderState = (TreeRenderState)userInstance.getRenderState(component);
            if (renderState == null || renderState.hasChangedPaths()) {
                extraProperties.add(PROPERTY_TREE_STRUCTURE);
            }
            if (renderState == null || renderState.hasUnsentSelections()) {
                extraProperties.add("selection");
            }
        }
        return new MultiIterator(new Iterator[]{normalPropertyIterator, extraProperties.iterator()});
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int index, Object newValue) {
        Tree tree = (Tree)component;
        if (EXPANSION_PROPERTY.equals(propertyName)) {
            int row = (Integer)newValue;
            UserInstance userInstance = (UserInstance)context.get(UserInstance.class);
            TreeRenderState renderState = (TreeRenderState)userInstance.getRenderState(component);
            if (renderState == null) {
                renderState = new TreeRenderState(tree);
                userInstance.setRenderState(component, (RenderState)renderState);
            }
            TreePath path = tree.getPathForRow(row);
            renderState.setClientPath(path);
            renderState.removeSentPath(path);
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            clientUpdateManager.setComponentProperty(component, "expansionState", newValue);
        } else if (SELECTION_PROPERTY.equals(propertyName)) {
            Integer row;
            Iterator iterator;
            int i;
            TreePath[] paths;
            TreeSelectionUpdate update = (TreeSelectionUpdate)newValue;
            TreeSelectionModel selectionModel = tree.getSelectionModel();
            if (!update.removedSelections.isEmpty()) {
                paths = new TreePath[update.removedSelections.size()];
                i = 0;
                iterator = update.removedSelections.iterator();
                while (iterator.hasNext()) {
                    row = (Integer)iterator.next();
                    paths[i++] = tree.getPathForRow(row.intValue());
                }
                selectionModel.removeSelectionPaths(paths);
            }
            if (!update.addedSelections.isEmpty()) {
                paths = new TreePath[update.addedSelections.size()];
                i = 0;
                iterator = update.addedSelections.iterator();
                while (iterator.hasNext()) {
                    row = (Integer)iterator.next();
                    paths[i++] = tree.getPathForRow(row.intValue());
                }
                if (update.clear) {
                    selectionModel.setSelectionPaths(paths);
                } else {
                    selectionModel.addSelectionPaths(paths);
                }
            }
        } else {
            super.storeInputProperty(context, component, propertyName, index, newValue);
        }
    }

    public Class getInputPropertyClass(String propertyName) {
        if (EXPANSION_PROPERTY.equals(propertyName)) {
            return Integer.class;
        }
        if (SELECTION_PROPERTY.equals(propertyName)) {
            return TreeSelectionUpdate.class;
        }
        return super.getInputPropertyClass(propertyName);
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(CommonService.INSTANCE.getId());
        serverMessage.addLibrary(TREE_SERVICE.getId());
    }

    static {
        WebContainerServlet.getServiceRegistry().add(TREE_SERVICE);
        CommonResources.install();
        ResourceRegistry resources = WebContainerServlet.getResourceRegistry();
        resources.add("Extras", "image/tree/Transparent.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/Closed.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/Open.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/JoinSolid.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/JoinBottomSolid.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/VerticalSolid.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/ClosedSolid.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/ClosedBottomSolid.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/OpenSolid.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/OpenBottomSolid.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/JoinDotted.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/JoinBottomDotted.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/VerticalDotted.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/ClosedDotted.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/ClosedBottomDotted.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/OpenDotted.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tree/OpenBottomDotted.gif", ContentType.IMAGE_GIF);
    }

    private static class TreeStructureRenderer {
        private Tree tree;
        private TreeModel model;
        private int columnCount;
        private Element propertyElement;
        private Document document;
        private Set renderedPaths = new HashSet();
        private TreeRenderState renderState;

        TreeStructureRenderer(Element propertyElement, Tree tree) {
            this.propertyElement = propertyElement;
            this.document = propertyElement.getOwnerDocument();
            this.tree = tree;
            this.columnCount = TreePeer.getColumnCount(tree);
            this.model = tree.getModel();
        }

        private void render(Context context, TreeRenderState renderState) {
            this.renderState = renderState;
            if (renderState.isFullRender()) {
                if (this.tree.isHeaderVisible()) {
                    this.renderNode(context, null, null, false);
                }
                Object value = this.model.getRoot();
                this.renderNode(context, value, new TreePath(value), true);
                renderState.setFullRender(false);
                this.propertyElement.setAttribute("fr", "1");
            } else if (renderState.hasChangedPaths()) {
                Iterator iterator = renderState.changedPaths();
                while (iterator.hasNext()) {
                    TreePath path = (TreePath)iterator.next();
                    this.renderNode(context, path.getLastPathComponent(), path, true);
                    this.renderedPaths.add(path);
                }
            }
        }

        private void renderNode(Context context, Object value, TreePath path, boolean root) {
            boolean leaf;
            TreePath parentPath;
            if (this.renderedPaths.contains(path)) {
                return;
            }
            if (this.renderState.isSent(path) && !this.renderState.isPathChanged(path)) {
                return;
            }
            UserInstance userInstance = (UserInstance)context.get(class$nextapp$echo$webcontainer$UserInstance == null ? (class$nextapp$echo$webcontainer$UserInstance = TreePeer.class$("nextapp.echo.webcontainer.UserInstance")) : class$nextapp$echo$webcontainer$UserInstance);
            this.renderedPaths.add(path);
            Component component = this.tree.getComponent(path, 0);
            boolean expanded = this.tree.isExpanded(path);
            String id = userInstance.getClientRenderId(component);
            Element eElement = this.document.createElement("e");
            eElement.setAttribute("i", id);
            if (path != null && (parentPath = path.getParentPath()) != null) {
                eElement.setAttribute("p", userInstance.getClientRenderId(this.tree.getComponent(parentPath, 0)));
            }
            boolean bl = leaf = value != null && this.model.isLeaf(value);
            if (path == null) {
                eElement.setAttribute("h", "1");
            } else {
                if (expanded) {
                    eElement.setAttribute("ex", "1");
                } else if (leaf) {
                    eElement.setAttribute("l", "1");
                }
                if (root) {
                    eElement.setAttribute("r", "1");
                }
            }
            if (!this.renderState.isSent(path)) {
                for (int i = 1; i < this.columnCount; ++i) {
                    Component columnComponent = this.tree.getComponent(path, i);
                    Element columnElement = this.document.createElement("c");
                    columnElement.setAttribute("i", userInstance.getClientRenderId(columnComponent));
                    eElement.appendChild(columnElement);
                }
            }
            this.propertyElement.appendChild(eElement);
            if (value == null) {
                return;
            }
            if (expanded) {
                int childCount = this.model.getChildCount(value);
                for (int i = 0; i < childCount; ++i) {
                    Object childValue = this.model.getChild(value, i);
                    this.renderNode(context, childValue, path.pathByAddingChild(childValue), false);
                }
            }
            if (expanded || leaf) {
                this.renderState.addSentPath(path);
            }
        }
    }

    public static class TreeStructurePeer
    implements SerialPropertyPeer {
        public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
            throw new UnsupportedOperationException();
        }

        public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
            Tree tree = ((TreeStructure)propertyValue).tree;
            TreeStructureRenderer renderer = new TreeStructureRenderer(propertyElement, tree);
            propertyElement.setAttribute("t", "Extras.Serial.TreeStructure");
            UserInstance userInstance = (UserInstance)context.get(class$nextapp$echo$webcontainer$UserInstance == null ? (class$nextapp$echo$webcontainer$UserInstance = TreePeer.class$("nextapp.echo.webcontainer.UserInstance")) : class$nextapp$echo$webcontainer$UserInstance);
            TreeRenderState renderState = (TreeRenderState)userInstance.getRenderState((Component)tree);
            if (renderState == null) {
                renderState = new TreeRenderState(tree);
                userInstance.setRenderState((Component)tree, (RenderState)renderState);
            }
            renderer.render(context, renderState);
            renderState.clearChangedPaths();
        }
    }

    private class TreeStructure {
        Tree tree;

        TreeStructure(Tree tree) {
            this.tree = tree;
        }
    }

    private static class TreeRenderState
    implements RenderState {
        private static final long serialVersionUID = 1L;
        private Set sentPaths = new HashSet();
        private Set changedPaths = new HashSet();
        private Set unsentSelections = new HashSet();
        private TreePath clientPath;
        private boolean fullRender = true;
        private final Tree tree;
        private TreeExpansionListener expansionListener = new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                if (!event.getPath().equals((Object)TreeRenderState.this.clientPath)) {
                    TreeRenderState.this.changedPaths.add(event.getPath());
                }
            }

            public void treeExpanded(TreeExpansionEvent event) {
                if (!event.getPath().equals((Object)TreeRenderState.this.clientPath)) {
                    TreeRenderState.this.changedPaths.add(event.getPath());
                }
            }
        };

        public TreeRenderState(Tree tree) {
            this.tree = tree;
            tree.addTreeExpansionListener(this.expansionListener);
        }

        public void setClientPath(TreePath path) {
            this.clientPath = null;
            if (this.isSent(path)) {
                this.clientPath = path;
            }
        }

        public boolean isFullRender() {
            return this.fullRender;
        }

        public void setFullRender(boolean newValue) {
            this.fullRender = newValue;
        }

        public void addSentPath(TreePath path) {
            this.sentPaths.add(path);
        }

        public void removeSentPath(TreePath path) {
            this.sentPaths.remove(path);
        }

        public boolean isSent(TreePath path) {
            return this.sentPaths.contains(path);
        }

        public Iterator changedPaths() {
            ArrayList list = new ArrayList(this.changedPaths);
            Collections.sort(list, new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    int i;
                    TreePath path1 = (TreePath)obj1;
                    TreePath path2 = (TreePath)obj2;
                    if (path1 == path2 || path1.equals((Object)path2)) {
                        return 0;
                    }
                    int path1Count = path1.getPathCount();
                    int path2Count = path2.getPathCount();
                    if (path1Count == 1) {
                        return -1;
                    }
                    if (path2Count == 1) {
                        return 1;
                    }
                    int end = Math.min(path1Count, path2Count);
                    for (i = 1; i < end; ++i) {
                        Object comp2;
                        Object comp1 = path1.getPathComponent(i);
                        if (comp1 == (comp2 = path2.getPathComponent(i))) continue;
                        return this.compareNodes(i, path1, path2);
                    }
                    if (path1Count == i) {
                        return -1;
                    }
                    if (path2Count == i) {
                        return 1;
                    }
                    return this.compareNodes(i, path1, path2);
                }

                private int compareNodes(int index, TreePath path1, TreePath path2) {
                    int index2;
                    Object commonParent = path1.getPathComponent(index - 1);
                    int index1 = TreeRenderState.this.tree.getModel().getIndexOfChild(commonParent, path1.getPathComponent(index));
                    if (index1 < (index2 = TreeRenderState.this.tree.getModel().getIndexOfChild(commonParent, path2.getPathComponent(index)))) {
                        return -1;
                    }
                    if (index1 > index2) {
                        return 1;
                    }
                    return 0;
                }
            });
            return list.iterator();
        }

        public void clearChangedPaths() {
            this.clientPath = null;
            this.changedPaths.clear();
        }

        public boolean hasChangedPaths() {
            return this.clientPath != null || !this.changedPaths.isEmpty();
        }

        public boolean isPathChanged(TreePath path) {
            return this.changedPaths.contains(path);
        }

        public boolean hasUnsentSelections() {
            return !this.unsentSelections.isEmpty();
        }

        public void addUnsentSelection(TreePath path) {
            this.unsentSelections.add(path);
        }

        public void removeUnsentSelection(TreePath path) {
            this.unsentSelections.remove(path);
        }
    }

    public static class TreeSelectionUpdatePeer
    implements SerialPropertyPeer {
        public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
            int i;
            TreeSelectionUpdate update = new TreeSelectionUpdate();
            String cStr = propertyElement.getAttribute("c");
            update.clear = Boolean.valueOf(cStr);
            if (propertyElement.hasAttribute("r")) {
                String rStr = propertyElement.getAttribute("r");
                String[] rTokens = rStr.split(",");
                for (i = 0; i < rTokens.length; ++i) {
                    update.removedSelections.add(Integer.valueOf(rTokens[i]));
                }
            }
            if (propertyElement.hasAttribute("a")) {
                String aStr = propertyElement.getAttribute("a");
                String[] aTokens = aStr.split(",");
                for (i = 0; i < aTokens.length; ++i) {
                    update.addedSelections.add(Integer.valueOf(aTokens[i]));
                }
            }
            return update;
        }

        public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
            throw new UnsupportedOperationException();
        }
    }

    private static class TreeSelectionUpdate {
        boolean clear = false;
        List addedSelections = new LinkedList();
        List removedSelections = new LinkedList();

        private TreeSelectionUpdate() {
        }
    }
}

