/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.io.IOException;
import nextapp.echo.app.util.Log;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.InputProcessor;
import nextapp.echo.webcontainer.OutputProcessor;
import nextapp.echo.webcontainer.SynchronizationState;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.util.XmlRequestParser;

public class Synchronization
implements SynchronizationState {
    private Connection conn;
    private UserInstance userInstance;
    private boolean outOfSync = false;
    private InputProcessor inputProcessor;

    public Synchronization(Connection conn) throws IOException {
        this.conn = conn;
    }

    public boolean isOutOfSync() {
        return this.outOfSync;
    }

    public void setOutOfSync() {
        this.outOfSync = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException {
        try {
            this.inputProcessor = new InputProcessor(this, this.conn);
        }
        catch (XmlRequestParser.InvalidXmlException ex) {
            Log.log((String)"Invalid XML Received, returning 400/Bad Request.", (Throwable)ex);
            this.conn.getResponse().sendError(400, "Invalid XML");
            return;
        }
        UserInstance userInstance = this.userInstance = this.conn.getUserInstance(this.inputProcessor.getWindowId(), this.inputProcessor.getInitId());
        synchronized (userInstance) {
            boolean initRequired;
            boolean bl = initRequired = !this.userInstance.isInitialized();
            if (initRequired) {
                this.userInstance.init(this.conn);
            }
            this.userInstance.setActive(true);
            try {
                this.inputProcessor.process();
                if (this.userInstance.getUpdateManager().getServerUpdateManager().isFullRefreshRequired()) {
                    this.userInstance.clearRenderStates();
                } else {
                    this.userInstance.purgeRenderStates();
                }
                OutputProcessor outputProcessor = new OutputProcessor(this, this.conn);
                outputProcessor.process();
                this.userInstance.getUpdateManager().purge();
            }
            finally {
                this.userInstance.setActive(false);
            }
        }
    }
}

