/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.service;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import nextapp.echo.app.util.DomUtil;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.SynchronizationException;
import nextapp.echo.webcontainer.UserInstanceContainer;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.BootService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class WindowHtmlService
implements Service {
    public static final String XHTML_1_0_TRANSITIONAL_PUBLIC_ID = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    public static final String XHTML_1_0_TRANSITIONAL_SYSTEM_ID = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    public static final String XHTML_1_0_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";
    public static final String ROOT_ELEMENT_ID = "root";
    private static final Properties OUTPUT_PROPERTIES = new Properties();
    private static final Pattern USER_AGENT_MSIE8;
    public static final WindowHtmlService INSTANCE;

    private Document createHtmlDocument(Connection conn, boolean debug) {
        Iterator styleSheetIt;
        UserInstanceContainer userInstanceContainer = conn.getUserInstanceContainer();
        String userAgent = conn.getRequest().getHeader("User-Agent");
        Document document = DomUtil.createDocument((String)"html", (String)XHTML_1_0_TRANSITIONAL_PUBLIC_ID, (String)XHTML_1_0_TRANSITIONAL_SYSTEM_ID, (String)XHTML_1_0_NAMESPACE_URI);
        Element htmlElement = document.getDocumentElement();
        Element headElement = document.createElement("head");
        htmlElement.appendChild(headElement);
        Element metaGeneratorElement = document.createElement("meta");
        metaGeneratorElement.setAttribute("name", "generator");
        metaGeneratorElement.setAttribute("content", "NextApp Echo v3.0.rc1");
        headElement.appendChild(metaGeneratorElement);
        if (userAgent != null && USER_AGENT_MSIE8.matcher(userAgent).find()) {
            Element metaCompElement = document.createElement("meta");
            metaCompElement.setAttribute("http-equiv", "X-UA-Compatible");
            metaCompElement.setAttribute("content", "IE=8");
            headElement.appendChild(metaCompElement);
        }
        Element contentTypeElement = document.createElement("meta");
        contentTypeElement.setAttribute("http-equiv", "Content-Type");
        contentTypeElement.setAttribute("content", "text/html; charset=utf-8");
        headElement.appendChild(contentTypeElement);
        Element titleElement = document.createElement("title");
        titleElement.appendChild(document.createTextNode(" "));
        headElement.appendChild(titleElement);
        Element styleElement = document.createElement("style");
        styleElement.setAttribute("type", "text/css");
        styleElement.appendChild(document.createTextNode(" "));
        headElement.appendChild(styleElement);
        Element scriptElement = document.createElement("script");
        Text textNode = document.createTextNode(" ");
        scriptElement.appendChild(textNode);
        scriptElement.setAttribute("type", "text/javascript");
        scriptElement.setAttribute("src", userInstanceContainer.getServiceUri(BootService.SERVICE, null));
        headElement.appendChild(scriptElement);
        WebContainerServlet servlet = conn.getServlet();
        Iterator scriptIt = servlet.getInitScripts();
        if (scriptIt != null) {
            while (scriptIt.hasNext()) {
                Service scriptService = (Service)scriptIt.next();
                scriptElement = document.createElement("script");
                textNode = document.createTextNode(" ");
                scriptElement.appendChild(textNode);
                scriptElement.setAttribute("type", "text/javascript");
                scriptElement.setAttribute("src", userInstanceContainer.getServiceUri(scriptService, null));
                headElement.appendChild(scriptElement);
            }
        }
        if ((styleSheetIt = servlet.getInitStyleSheets()) != null) {
            while (styleSheetIt.hasNext()) {
                Service styleSheetService = (Service)styleSheetIt.next();
                Element linkElement = document.createElement("link");
                linkElement.setAttribute("rel", "StyleSheet");
                linkElement.setAttribute("type", "text/css");
                linkElement.setAttribute("href", userInstanceContainer.getServiceUri(styleSheetService, null));
                headElement.appendChild(linkElement);
            }
        }
        Element bodyElement = document.createElement("body");
        bodyElement.setAttribute("id", "body");
        bodyElement.setAttribute("onload", "Echo.Boot.boot('" + userInstanceContainer.getServletUri() + "', '" + userInstanceContainer.createInitId(conn) + "', " + debug + ");");
        bodyElement.setAttribute("style", "height:100%;width:100%;margin:0px;padding:0px;font-family:verdana, arial, helvetica, sans-serif;font-size:10pt");
        htmlElement.appendChild(bodyElement);
        Element rootDivElement = document.createElement("div");
        rootDivElement.setAttribute("style", "position:absolute;width:100%;height:100%;");
        rootDivElement.setAttribute("id", userInstanceContainer.getRootHtmlElementId());
        bodyElement.appendChild(rootDivElement);
        return document;
    }

    public String getId() {
        return "Echo.Default";
    }

    public int getVersion() {
        return -1;
    }

    public void service(Connection conn) throws IOException {
        try {
            boolean debug = !"false".equals(conn.getServlet().getInitParameter("echo.debug"));
            Document document = this.createHtmlDocument(conn, debug);
            conn.setContentType(ContentType.TEXT_HTML);
            DomUtil.save((Document)document, (PrintWriter)conn.getWriter(), (Properties)OUTPUT_PROPERTIES);
        }
        catch (SAXException ex) {
            throw new SynchronizationException("Failed to write HTML document.", ex);
        }
    }

    static {
        OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "yes");
        OUTPUT_PROPERTIES.putAll((Map<?, ?>)DomUtil.OUTPUT_PROPERTIES_INDENT);
        OUTPUT_PROPERTIES.setProperty("doctype-public", XHTML_1_0_TRANSITIONAL_PUBLIC_ID);
        OUTPUT_PROPERTIES.setProperty("doctype-system", XHTML_1_0_TRANSITIONAL_SYSTEM_ID);
        USER_AGENT_MSIE8 = Pattern.compile("MSIE 8\\.");
        INSTANCE = new WindowHtmlService();
    }
}

