/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.sync.component;

import java.util.HashSet;
import java.util.Iterator;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.list.AbstractListComponent;
import nextapp.echo.app.list.ListCellRenderer;
import nextapp.echo.app.list.ListModel;
import nextapp.echo.app.list.StyledListCell;
import nextapp.echo.app.serial.PropertyPeerFactory;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.serial.property.ColorPeer;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.update.ServerComponentUpdate;
import nextapp.echo.app.util.Context;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;
import nextapp.echo.webcontainer.sync.component.ListSelectionUtil;
import nextapp.echo.webcontainer.util.MultiIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AbstractListComponentPeer
extends AbstractComponentSynchronizePeer {
    private static final Service LIST_COMPONENT_SERVICE = JavaScriptService.forResources("Echo.ListComponent", new String[]{"nextapp/echo/webcontainer/resource/Sync.List.js", "nextapp/echo/webcontainer/resource/Sync.RemoteList.js"});
    private static final String PROPERTY_DATA = "data";
    private static final String PROPERTY_SELECTION = "selection";
    private static final String PROPERTY_SELECTION_MODE = "selectionMode";
    static /* synthetic */ Class class$nextapp$echo$app$serial$SerialContext;
    static /* synthetic */ Class class$nextapp$echo$app$serial$PropertyPeerFactory;
    static /* synthetic */ Class class$nextapp$echo$app$Font;

    public AbstractListComponentPeer() {
        this.addOutputProperty(PROPERTY_DATA);
        this.addOutputProperty(PROPERTY_SELECTION);
        this.addOutputProperty(PROPERTY_SELECTION_MODE);
        this.setOutputPropertyReferenced(PROPERTY_DATA, true);
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("action", "actionListeners"){

            public boolean hasListeners(Context context, Component component) {
                return ((AbstractListComponent)component).hasActionListeners();
            }
        });
    }

    public String getClientComponentType(boolean mode) {
        return mode ? "LC" : "AbstractListComponent";
    }

    public Class getComponentClass() {
        return AbstractListComponent.class;
    }

    public Class getInputPropertyClass(String propertyName) {
        if (PROPERTY_SELECTION.equals(propertyName)) {
            return String.class;
        }
        return null;
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if (PROPERTY_DATA.equals(propertyName)) {
            return new ListData((AbstractListComponent)component);
        }
        if (PROPERTY_SELECTION.equals(propertyName)) {
            return ListSelectionUtil.toString(((AbstractListComponent)component).getSelectionModel(), ((AbstractListComponent)component).getModel().size());
        }
        if (PROPERTY_SELECTION_MODE.equals(propertyName)) {
            int selectionMode = ((AbstractListComponent)component).getSelectionModel().getSelectionMode();
            return new Integer(selectionMode);
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public String getOutputPropertyMethodName(Context context, Component component, String propertyName) {
        if (PROPERTY_DATA.equals(propertyName)) {
            return "updateListData";
        }
        if (PROPERTY_SELECTION.equals(propertyName)) {
            return "setSelectionString";
        }
        return super.getOutputPropertyMethodName(context, component, propertyName);
    }

    public Iterator getUpdatedOutputPropertyNames(Context context, Component component, ServerComponentUpdate update) {
        HashSet<String> additionalPropertyNames = new HashSet<String>();
        if (update.hasUpdatedProperty("listSelectionChanged") || update.hasUpdatedProperty("listSelectionModel")) {
            additionalPropertyNames.add(PROPERTY_SELECTION);
            additionalPropertyNames.add(PROPERTY_SELECTION_MODE);
        }
        if (update.hasUpdatedProperty("listModel") || update.hasUpdatedProperty("listData") || update.hasUpdatedProperty("listCellRenderer")) {
            additionalPropertyNames.add(PROPERTY_DATA);
        }
        return new MultiIterator(new Iterator[]{super.getUpdatedOutputPropertyNames(context, component, update), additionalPropertyNames.iterator()});
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(LIST_COMPONENT_SERVICE.getId());
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int index, Object newValue) {
        if (PROPERTY_SELECTION.equals(propertyName)) {
            int[] selection = ListSelectionUtil.toIntArray((String)newValue);
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            clientUpdateManager.setComponentProperty(component, "listSelectionChanged", (Object)selection);
        }
    }

    static {
        WebContainerServlet.getServiceRegistry().add(LIST_COMPONENT_SERVICE);
    }

    public static class ListDataPeer
    implements SerialPropertyPeer {
        public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
            throw new UnsupportedOperationException();
        }

        public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
            SerialPropertyPeer fontPeer = null;
            SerialContext serialContext = (SerialContext)context.get(class$nextapp$echo$app$serial$SerialContext == null ? (class$nextapp$echo$app$serial$SerialContext = AbstractListComponentPeer.class$("nextapp.echo.app.serial.SerialContext")) : class$nextapp$echo$app$serial$SerialContext);
            Document document = serialContext.getDocument();
            ListData listData = (ListData)propertyValue;
            propertyElement.setAttribute("t", "RemoteListData");
            int size = listData.model.size();
            for (int i = 0; i < size; ++i) {
                Element eElement = document.createElement("e");
                Object value = listData.model.get(i);
                Object cell = listData.renderer.getListCellRendererComponent((Component)listData.listComponent, value, i);
                eElement.setAttribute("t", String.valueOf(cell));
                propertyElement.appendChild(eElement);
                if (!(cell instanceof StyledListCell)) continue;
                StyledListCell styledCell = (StyledListCell)cell;
                if (styledCell.getBackground() != null) {
                    eElement.setAttribute("b", ColorPeer.toString((Color)styledCell.getBackground()));
                }
                if (styledCell.getForeground() != null) {
                    eElement.setAttribute("f", ColorPeer.toString((Color)styledCell.getForeground()));
                }
                if (styledCell.getFont() == null) continue;
                if (fontPeer == null) {
                    PropertyPeerFactory propertyPeerFactory = (PropertyPeerFactory)context.get(class$nextapp$echo$app$serial$PropertyPeerFactory == null ? AbstractListComponentPeer.class$("nextapp.echo.app.serial.PropertyPeerFactory") : class$nextapp$echo$app$serial$PropertyPeerFactory);
                    fontPeer = propertyPeerFactory.getPeerForProperty(class$nextapp$echo$app$Font == null ? AbstractListComponentPeer.class$("nextapp.echo.app.Font") : class$nextapp$echo$app$Font);
                }
                Element fontElement = document.createElement("p");
                eElement.appendChild(fontElement);
                fontPeer.toXml(context, class$nextapp$echo$app$Font == null ? AbstractListComponentPeer.class$("nextapp.echo.app.Font") : class$nextapp$echo$app$Font, fontElement, (Object)styledCell.getFont());
            }
        }
    }

    private class ListData {
        private ListModel model;
        private ListCellRenderer renderer;
        private AbstractListComponent listComponent;

        ListData(AbstractListComponent component) {
            this.listComponent = component;
            this.model = component.getModel();
            this.renderer = component.getCellRenderer();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ListData)) {
                return false;
            }
            ListData that = (ListData)o;
            if (!(this.model == that.model || this.model != null && this.model.equals(that.model))) {
                return false;
            }
            return this.renderer == that.renderer || this.renderer != null && this.renderer.equals(that.renderer);
        }

        public int hashCode() {
            return (this.model == null ? 0 : this.model.hashCode()) | (this.renderer == null ? 0 : this.renderer.hashCode());
        }
    }
}

