/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.swing.ImageIcon;

public class PngEncoder {
    public static final Filter SUB_FILTER = new SubFilter();
    public static final Filter UP_FILTER = new UpFilter();
    public static final Filter AVERAGE_FILTER = new AverageFilter();
    public static final Filter PAETH_FILTER = new PaethFilter();
    private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    private static final byte[] PLTE = new byte[]{80, 76, 84, 69};
    private static final byte[] IDAT = new byte[]{73, 68, 65, 84};
    private static final byte[] IEND = new byte[]{73, 69, 78, 68};
    private static final int SUB_FILTER_TYPE = 1;
    private static final int UP_FILTER_TYPE = 2;
    private static final int AVERAGE_FILTER_TYPE = 3;
    private static final int PAETH_FILTER_TYPE = 4;
    private static final byte BIT_DEPTH = 8;
    private static final byte COLOR_TYPE_INDEXED = 3;
    private static final byte COLOR_TYPE_RGB = 2;
    private static final byte COLOR_TYPE_RGBA = 6;
    private static final int[] INT_TRANSLATOR_CHANNEL_MAP = new int[]{2, 1, 0, 3};
    private BufferedImage image;
    private Filter filter;
    private int compressionLevel;
    private int width;
    private int height;
    private int transferType;
    private Raster raster;
    private int inputBpp;
    private int outputBpp;
    private Translator translator;

    private static void writeInt(OutputStream out, int i) throws IOException {
        out.write(new byte[]{(byte)(i >> 24), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)});
    }

    public PngEncoder(Image image, boolean encodeAlpha, Filter filter, int compressionLevel) {
        this.image = ImageToBufferedImage.toBufferedImage(image);
        this.filter = filter;
        this.compressionLevel = compressionLevel;
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.raster = this.image.getRaster();
        this.transferType = this.raster.getTransferType();
        int dataBytes = this.raster.getNumDataElements();
        if (this.transferType == 0 && dataBytes == 4) {
            this.outputBpp = encodeAlpha ? 4 : 3;
            this.inputBpp = 4;
            this.translator = new ByteTranslator();
        } else if (this.transferType == 0 && dataBytes == 3) {
            this.outputBpp = 3;
            this.inputBpp = 3;
            encodeAlpha = false;
            this.translator = new ByteTranslator();
        } else if (this.transferType == 3 && dataBytes == 1) {
            this.outputBpp = encodeAlpha ? 4 : 3;
            this.inputBpp = 4;
            this.translator = new IntTranslator();
        } else {
            if (this.transferType == 0 && dataBytes == 1) {
                throw new UnsupportedOperationException("Encoding indexed-color images not yet supported.");
            }
            throw new IllegalArgumentException("Cannot determine appropriate bits-per-pixel for provided image.");
        }
    }

    public synchronized void encode(OutputStream out) throws IOException {
        CRC32 csum = new CRC32();
        out = new CheckedOutputStream(out, csum);
        out.write(SIGNATURE);
        this.writeIhdrChunk(out, csum);
        if (this.outputBpp == 1) {
            this.writePlteChunk(out, csum);
        }
        this.writeIdatChunks(out, csum);
        this.writeIendChunk(out, csum);
    }

    private void writeIdatChunks(OutputStream out, Checksum csum) throws IOException {
        int rowWidth = this.width * this.outputBpp;
        int row = 0;
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DeflaterOutputStream defOut = new DeflaterOutputStream((OutputStream)byteOut, deflater);
        byte[] filteredPixelQueue = new byte[rowWidth];
        byte[][] outputPixelQueue = new byte[2][rowWidth];
        Arrays.fill(outputPixelQueue[1], (byte)0);
        int outputPixelQueueRow = 0;
        int outputPixelQueuePrevRow = 1;
        while (row < this.height) {
            if (this.filter == null) {
                defOut.write(0);
                this.translator.translate(outputPixelQueue[outputPixelQueueRow], row);
                defOut.write(outputPixelQueue[outputPixelQueueRow], 0, rowWidth);
            } else {
                defOut.write(this.filter.getType());
                this.translator.translate(outputPixelQueue[outputPixelQueueRow], row);
                this.filter.filter(filteredPixelQueue, outputPixelQueue[outputPixelQueueRow], outputPixelQueue[outputPixelQueuePrevRow], this.outputBpp);
                defOut.write(filteredPixelQueue, 0, rowWidth);
            }
            outputPixelQueueRow = ++row & 1;
            outputPixelQueuePrevRow = outputPixelQueueRow ^ 1;
        }
        defOut.finish();
        byteOut.close();
        PngEncoder.writeInt(out, byteOut.size());
        csum.reset();
        out.write(IDAT);
        byteOut.writeTo(out);
        PngEncoder.writeInt(out, (int)csum.getValue());
    }

    private void writeIendChunk(OutputStream out, Checksum csum) throws IOException {
        PngEncoder.writeInt(out, 0);
        csum.reset();
        out.write(IEND);
        PngEncoder.writeInt(out, (int)csum.getValue());
    }

    private void writeIhdrChunk(OutputStream out, Checksum csum) throws IOException {
        PngEncoder.writeInt(out, 13);
        csum.reset();
        out.write(IHDR);
        PngEncoder.writeInt(out, this.width);
        PngEncoder.writeInt(out, this.height);
        out.write(8);
        switch (this.outputBpp) {
            case 1: {
                out.write(3);
                break;
            }
            case 3: {
                out.write(2);
                break;
            }
            case 4: {
                out.write(6);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid bytes per pixel");
            }
        }
        out.write(0);
        out.write(0);
        out.write(0);
        PngEncoder.writeInt(out, (int)csum.getValue());
    }

    private void writePlteChunk(OutputStream out, Checksum csum) throws IOException {
        IndexColorModel icm = (IndexColorModel)this.image.getColorModel();
        PngEncoder.writeInt(out, 768);
        csum.reset();
        out.write(PLTE);
        byte[] reds = new byte[256];
        icm.getReds(reds);
        byte[] greens = new byte[256];
        icm.getGreens(greens);
        byte[] blues = new byte[256];
        icm.getBlues(blues);
        for (int index = 0; index < 256; ++index) {
            out.write(reds[index]);
            out.write(greens[index]);
            out.write(blues[index]);
        }
        PngEncoder.writeInt(out, (int)csum.getValue());
    }

    private class IntTranslator
    implements Translator {
        int[] inputPixelQueue;
        int column;
        int channel;

        private IntTranslator() {
            this.inputPixelQueue = new int[PngEncoder.this.width];
        }

        public void translate(byte[] outputPixelQueue, int row) {
            PngEncoder.this.image.getRGB(0, row, PngEncoder.this.width, 1, this.inputPixelQueue, 0, PngEncoder.this.width);
            this.column = 0;
            while (this.column < PngEncoder.this.width) {
                this.channel = 0;
                while (this.channel < PngEncoder.this.outputBpp) {
                    outputPixelQueue[this.column * ((PngEncoder)PngEncoder.this).outputBpp + this.channel] = (byte)(this.inputPixelQueue[this.column] >> INT_TRANSLATOR_CHANNEL_MAP[this.channel] * 8);
                    ++this.channel;
                }
                ++this.column;
            }
        }
    }

    private class ByteTranslator
    implements Translator {
        int rowWidth;
        byte[] inputPixelQueue;
        int column;
        int channel;

        private ByteTranslator() {
            this.rowWidth = PngEncoder.this.width * PngEncoder.this.outputBpp;
            this.inputPixelQueue = new byte[this.rowWidth + PngEncoder.this.outputBpp];
        }

        public void translate(byte[] outputPixelQueue, int row) {
            PngEncoder.this.raster.getDataElements(0, row, PngEncoder.this.width, 1, this.inputPixelQueue);
            this.column = 0;
            while (this.column < PngEncoder.this.width) {
                this.channel = 0;
                while (this.channel < PngEncoder.this.outputBpp) {
                    outputPixelQueue[this.column * ((PngEncoder)PngEncoder.this).outputBpp + this.channel] = this.inputPixelQueue[this.column * PngEncoder.this.inputBpp + this.channel];
                    ++this.channel;
                }
                ++this.column;
            }
        }
    }

    static interface Translator {
        public void translate(byte[] var1, int var2);
    }

    private static class PaethFilter
    implements Filter {
        private PaethFilter() {
        }

        public void filter(byte[] filterOutput, byte[] currentRow, byte[] previousRow, int outputBpp) {
            for (int index = 0; index < filterOutput.length; ++index) {
                int nw;
                int w;
                int n = previousRow[index] + 256 & 0xFF;
                if (index < outputBpp) {
                    w = 0;
                    nw = 0;
                } else {
                    w = currentRow[index - outputBpp] + 256 & 0xFF;
                    nw = previousRow[index - outputBpp] + 256 & 0xFF;
                }
                int p = w + n - nw;
                int pw = Math.abs(p - w);
                int pn = Math.abs(p - n);
                int pnw = Math.abs(p - w);
                byte pv = pw <= pn && pw <= pnw ? (byte)w : (pn <= pnw ? (byte)n : (byte)nw);
                filterOutput[index] = (byte)(currentRow[index] - pv);
            }
        }

        public int getType() {
            return 4;
        }
    }

    private static class AverageFilter
    implements Filter {
        private AverageFilter() {
        }

        public void filter(byte[] filterOutput, byte[] currentRow, byte[] previousRow, int outputBpp) {
            for (int index = 0; index < filterOutput.length; ++index) {
                int n = previousRow[index] + 256 & 0xFF;
                int w = index < outputBpp ? 0 : currentRow[index - outputBpp] + 256 & 0xFF;
                filterOutput[index] = (byte)(currentRow[index] - (byte)((w + n) / 2));
            }
        }

        public int getType() {
            return 3;
        }
    }

    private static class UpFilter
    implements Filter {
        private UpFilter() {
        }

        public void filter(byte[] filterOutput, byte[] currentRow, byte[] previousRow, int outputBpp) {
            for (int index = 0; index < currentRow.length; ++index) {
                filterOutput[index] = (byte)(currentRow[index] - previousRow[index]);
            }
        }

        public int getType() {
            return 2;
        }
    }

    private static class SubFilter
    implements Filter {
        private SubFilter() {
        }

        public void filter(byte[] filterOutput, byte[] currentRow, byte[] previousRow, int outputBpp) {
            for (int index = 0; index < filterOutput.length; ++index) {
                filterOutput[index] = index < outputBpp ? currentRow[index] : (byte)(currentRow[index] - currentRow[index - outputBpp]);
            }
        }

        public int getType() {
            return 1;
        }
    }

    public static interface Filter {
        public void filter(byte[] var1, byte[] var2, byte[] var3, int var4);

        public int getType();
    }

    private static class ImageToBufferedImage {
        private ImageToBufferedImage() {
        }

        static BufferedImage toBufferedImage(Image image) {
            if (image instanceof BufferedImage) {
                return (BufferedImage)image;
            }
            int type = ImageToBufferedImage.hasAlpha(image = new ImageIcon(image).getImage()) ? 1 : 2;
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            return bufferedImage;
        }

        static boolean hasAlpha(Image image) {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return pg.getColorModel().hasAlpha();
        }
    }
}

