/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWK;
import com.nimbusds.jose.KeyType;
import com.nimbusds.jose.Use;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class RSAKey
extends JWK {
    private final Base64URL n;
    private final Base64URL e;

    public RSAKey(Base64URL n, Base64URL e, Use use, Algorithm alg, String kid) {
        super(KeyType.RSA, use, alg, kid);
        if (n == null) {
            throw new IllegalArgumentException("The modulus value must not be null");
        }
        this.n = n;
        if (e == null) {
            throw new IllegalArgumentException("The exponent value must not be null");
        }
        this.e = e;
    }

    public Base64URL getModulus() {
        return this.n;
    }

    public Base64URL getExponent() {
        return this.e;
    }

    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put((Object)"n", (Object)this.n.toString());
        o.put((Object)"e", (Object)this.e.toString());
        return o;
    }

    public static RSAKey parse(JSONObject jsonObject) throws ParseException {
        KeyType kty = KeyType.parse(JSONObjectUtils.getString(jsonObject, "kty"));
        Base64URL mod = new Base64URL(JSONObjectUtils.getString(jsonObject, "n"));
        Base64URL exp = new Base64URL(JSONObjectUtils.getString(jsonObject, "e"));
        Use use = JWK.parseKeyUse(jsonObject);
        Algorithm alg = JWK.parseAlgorithm(jsonObject);
        String id = JWK.parseKeyID(jsonObject);
        if (kty != KeyType.RSA) {
            throw new ParseException("The key type \"kty\" must be RSA", 0);
        }
        return new RSAKey(mod, exp, use, alg, id);
    }
}

