/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.Use;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;

@Immutable
public final class ECKey
extends JWK {
    private final Curve crv;
    private final Base64URL x;
    private final Base64URL y;
    private final Base64URL d;

    public ECKey(Curve crv, Base64URL x, Base64URL y, Use use, Algorithm alg, String kid) {
        this(crv, x, y, null, use, alg, kid);
    }

    public ECKey(Curve crv, Base64URL x, Base64URL y, Base64URL d, Use use, Algorithm alg, String kid) {
        super(KeyType.EC, use, alg, kid);
        if (crv == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        this.crv = crv;
        if (x == null) {
            throw new IllegalArgumentException("The x coordinate must not be null");
        }
        this.x = x;
        if (y == null) {
            throw new IllegalArgumentException("The y coordinate must not be null");
        }
        this.y = y;
        this.d = d;
    }

    public ECKey(Curve crv, ECPublicKey pub, Use use, Algorithm alg, String kid) {
        this(crv, Base64URL.encode(pub.getW().getAffineX()), Base64URL.encode(pub.getW().getAffineY()), use, alg, kid);
    }

    public ECKey(Curve crv, ECPublicKey pub, ECPrivateKey priv, Use use, Algorithm alg, String kid) {
        this(crv, Base64URL.encode(pub.getW().getAffineX()), Base64URL.encode(pub.getW().getAffineY()), Base64URL.encode(priv.getS()), use, alg, kid);
    }

    public Curve getCurve() {
        return this.crv;
    }

    public Base64URL getX() {
        return this.x;
    }

    public Base64URL getY() {
        return this.y;
    }

    public Base64URL getD() {
        return this.d;
    }

    private static KeyFactory getECKeyFactory() throws NoSuchAlgorithmException {
        return KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
    }

    public ECPublicKey toECPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        ECParameterSpec spec = this.crv.toECParameterSpec();
        if (spec == null) {
            throw new NoSuchAlgorithmException("Couldn't get EC parameter spec for curve " + this.crv);
        }
        ECPoint w = new ECPoint(this.x.decodeToBigInteger(), this.y.decodeToBigInteger());
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(w, spec);
        KeyFactory keyFactory = ECKey.getECKeyFactory();
        return (ECPublicKey)keyFactory.generatePublic(publicKeySpec);
    }

    public ECPrivateKey toECPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.d == null) {
            return null;
        }
        ECParameterSpec spec = this.crv.toECParameterSpec();
        if (spec == null) {
            throw new NoSuchAlgorithmException("Couldn't get EC parameter spec for curve " + this.crv);
        }
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(this.d.decodeToBigInteger(), spec);
        KeyFactory keyFactory = ECKey.getECKeyFactory();
        return (ECPrivateKey)keyFactory.generatePrivate(privateKeySpec);
    }

    public KeyPair toKeyPair() throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new KeyPair(this.toECPublicKey(), this.toECPrivateKey());
    }

    public boolean isPrivate() {
        return this.d != null;
    }

    public ECKey toPublicJWK() {
        return new ECKey(this.getCurve(), this.getX(), this.getY(), this.getKeyUse(), this.getAlgorithm(), this.getKeyID());
    }

    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put((Object)"crv", (Object)this.crv.toString());
        o.put((Object)"x", (Object)this.x.toString());
        o.put((Object)"y", (Object)this.y.toString());
        if (this.d != null) {
            o.put((Object)"d", (Object)this.d.toString());
        }
        return o;
    }

    public static ECKey parse(String s) throws ParseException {
        return ECKey.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static ECKey parse(JSONObject jsonObject) throws ParseException {
        Curve crv = Curve.parse(JSONObjectUtils.getString(jsonObject, "crv"));
        Base64URL x = new Base64URL(JSONObjectUtils.getString(jsonObject, "x"));
        Base64URL y = new Base64URL(JSONObjectUtils.getString(jsonObject, "y"));
        KeyType kty = KeyType.parse(JSONObjectUtils.getString(jsonObject, "kty"));
        if (kty != KeyType.EC) {
            throw new ParseException("The key type \"kty\" must be EC", 0);
        }
        Base64URL d = null;
        if (jsonObject.get((Object)"d") != null) {
            d = new Base64URL(JSONObjectUtils.getString(jsonObject, "d"));
        }
        Use use = JWK.parseKeyUse(jsonObject);
        Algorithm alg = JWK.parseAlgorithm(jsonObject);
        String kid = JWK.parseKeyID(jsonObject);
        return new ECKey(crv, x, y, d, use, alg, kid);
    }

    @Immutable
    public static class Curve {
        public static final Curve P_256 = new Curve("P-256", "secp256r1");
        public static final Curve P_384 = new Curve("P-384", "secp384r1");
        public static final Curve P_521 = new Curve("P-521", "secp521r1");
        private final String name;
        private final String stdName;

        public Curve(String name) {
            this(name, null);
        }

        public Curve(String name, String stdName) {
            if (name == null) {
                throw new IllegalArgumentException("The cryptographic curve name must not be null");
            }
            this.name = name;
            this.stdName = stdName;
        }

        public String getName() {
            return this.name;
        }

        public String getStdName() {
            return this.stdName;
        }

        public ECParameterSpec toECParameterSpec() {
            if (this.stdName == null) {
                return null;
            }
            ECNamedCurveParameterSpec curveParams = ECNamedCurveTable.getParameterSpec((String)this.stdName);
            if (curveParams == null) {
                return null;
            }
            return new ECNamedCurveSpec(curveParams.getName(), curveParams.getCurve(), curveParams.getG(), curveParams.getN());
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object object) {
            return object != null && object instanceof Curve && this.toString().equals(object.toString());
        }

        public static Curve parse(String s) throws ParseException {
            if (s == null) {
                throw new IllegalArgumentException("The cryptographic curve string must not be null");
            }
            if (s.equals(P_256.getName())) {
                return P_256;
            }
            if (s.equals(P_384.getName())) {
                return P_384;
            }
            if (s.equals(P_521.getName())) {
                return P_521;
            }
            return new Curve(s);
        }

        public static Curve forStdName(String stdName) {
            if (stdName.equals("secp256r1")) {
                return P_256;
            }
            if (stdName.equals("secp384r1")) {
                return P_384;
            }
            if (stdName.equals("secp521r1")) {
                return P_521;
            }
            throw new IllegalArgumentException("No matching curve constant for standard (JCA) name " + stdName);
        }
    }
}

