/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.crypto.BaseJWEProvider;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

abstract class DirectCryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    private final SecretKey cek;

    protected DirectCryptoProvider(SecretKey key) throws JOSEException {
        super(SUPPORTED_ALGORITHMS, SUPPORTED_ENCRYPTION_METHODS);
        if (!key.getAlgorithm().equals("AES")) {
            throw new JOSEException("The algorithm of the shared symmetric key must be AES");
        }
        byte[] keyBytes = key.getEncoded();
        if (keyBytes.length != 16 && keyBytes.length != 32 && keyBytes.length != 64) {
            throw new JOSEException("The length of the shared symmetric key must be 128 bits (16 bytes), 256 bits (32 bytes) or 512 bites (64 bytes)");
        }
        this.cek = key;
    }

    protected DirectCryptoProvider(byte[] keyBytes) throws JOSEException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public SecretKey getKey() {
        return this.cek;
    }

    static {
        HashSet<JWEAlgorithm> algs = new HashSet<JWEAlgorithm>();
        algs.add(JWEAlgorithm.DIR);
        SUPPORTED_ALGORITHMS = algs;
        HashSet<EncryptionMethod> methods = new HashSet<EncryptionMethod>();
        methods.add(EncryptionMethod.A128CBC_HS256);
        methods.add(EncryptionMethod.A256CBC_HS512);
        methods.add(EncryptionMethod.A128GCM);
        methods.add(EncryptionMethod.A256GCM);
        SUPPORTED_ENCRYPTION_METHODS = methods;
    }
}

