/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.BaseJWSProvider;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;

abstract class MACProvider
extends BaseJWSProvider {
    private static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;
    private final byte[] sharedSecret;

    protected static String getJCAAlgorithmName(JWSAlgorithm alg) throws JOSEException {
        if (alg.equals(JWSAlgorithm.HS256)) {
            return "HMACSHA256";
        }
        if (alg.equals(JWSAlgorithm.HS384)) {
            return "HMACSHA384";
        }
        if (alg.equals(JWSAlgorithm.HS512)) {
            return "HMACSHA512";
        }
        throw new JOSEException("Unsupported HMAC algorithm, must be HS256, HS384 or HS512");
    }

    protected MACProvider(byte[] sharedSecret) {
        super(SUPPORTED_ALGORITHMS);
        if (sharedSecret == null) {
            throw new IllegalArgumentException("The shared secret must not be null");
        }
        this.sharedSecret = sharedSecret;
    }

    protected MACProvider(String sharedSecretString) {
        this(sharedSecretString.getBytes(Charset.forName("UTF-8")));
    }

    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    public String getSharedSecretString() {
        return new String(this.sharedSecret, Charset.forName("UTF-8"));
    }

    static {
        HashSet<JWSAlgorithm> algs = new HashSet<JWSAlgorithm>();
        algs.add(JWSAlgorithm.HS256);
        algs.add(JWSAlgorithm.HS384);
        algs.add(JWSAlgorithm.HS512);
        SUPPORTED_ALGORITHMS = algs;
    }
}

