/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.crypto.BouncyCastleProviderSingleton;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.Use;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jose.util.X509CertChainUtils;
import java.net.URL;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.util.List;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class ECKey
extends JWK {
    private final Curve crv;
    private final Base64URL x;
    private final Base64URL y;
    private final Base64URL d;

    public ECKey(Curve crv, Base64URL x, Base64URL y, Use use, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        super(KeyType.EC, use, alg, kid, x5u, x5t, x5c);
        if (crv == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        this.crv = crv;
        if (x == null) {
            throw new IllegalArgumentException("The 'x' coordinate must not be null");
        }
        this.x = x;
        if (y == null) {
            throw new IllegalArgumentException("The 'y' coordinate must not be null");
        }
        this.y = y;
        this.d = null;
    }

    public ECKey(Curve crv, Base64URL x, Base64URL y, Base64URL d, Use use, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        super(KeyType.EC, use, alg, kid, x5u, x5t, x5c);
        if (crv == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        this.crv = crv;
        if (x == null) {
            throw new IllegalArgumentException("The 'x' coordinate must not be null");
        }
        this.x = x;
        if (y == null) {
            throw new IllegalArgumentException("The 'y' coordinate must not be null");
        }
        this.y = y;
        if (d == null) {
            throw new IllegalArgumentException("The 'd' coordinate must not be null");
        }
        this.d = d;
    }

    public ECKey(Curve crv, ECPublicKey pub, Use use, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        this(crv, Base64URL.encode(pub.getW().getAffineX()), Base64URL.encode(pub.getW().getAffineY()), use, alg, kid, x5u, x5t, x5c);
    }

    public ECKey(Curve crv, ECPublicKey pub, ECPrivateKey priv, Use use, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        this(crv, Base64URL.encode(pub.getW().getAffineX()), Base64URL.encode(pub.getW().getAffineY()), Base64URL.encode(priv.getS()), use, alg, kid, x5u, x5t, x5c);
    }

    public Curve getCurve() {
        return this.crv;
    }

    public Base64URL getX() {
        return this.x;
    }

    public Base64URL getY() {
        return this.y;
    }

    public Base64URL getD() {
        return this.d;
    }

    private static KeyFactory getECKeyFactory() throws NoSuchAlgorithmException {
        return KeyFactory.getInstance("EC", (Provider)BouncyCastleProviderSingleton.getInstance());
    }

    public ECPublicKey toECPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        ECParameterSpec spec = this.crv.toECParameterSpec();
        if (spec == null) {
            throw new NoSuchAlgorithmException("Couldn't get EC parameter spec for curve " + this.crv);
        }
        ECPoint w = new ECPoint(this.x.decodeToBigInteger(), this.y.decodeToBigInteger());
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(w, spec);
        KeyFactory keyFactory = ECKey.getECKeyFactory();
        return (ECPublicKey)keyFactory.generatePublic(publicKeySpec);
    }

    public ECPrivateKey toECPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.d == null) {
            return null;
        }
        ECParameterSpec spec = this.crv.toECParameterSpec();
        if (spec == null) {
            throw new NoSuchAlgorithmException("Couldn't get EC parameter spec for curve " + this.crv);
        }
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(this.d.decodeToBigInteger(), spec);
        KeyFactory keyFactory = ECKey.getECKeyFactory();
        return (ECPrivateKey)keyFactory.generatePrivate(privateKeySpec);
    }

    public KeyPair toKeyPair() throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new KeyPair(this.toECPublicKey(), this.toECPrivateKey());
    }

    @Override
    public boolean isPrivate() {
        return this.d != null;
    }

    @Override
    public ECKey toPublicJWK() {
        return new ECKey(this.getCurve(), this.getX(), this.getY(), this.getKeyUse(), this.getAlgorithm(), this.getKeyID(), this.getX509CertURL(), this.getX509CertThumbprint(), this.getX509CertChain());
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put((Object)"crv", (Object)this.crv.toString());
        o.put((Object)"x", (Object)this.x.toString());
        o.put((Object)"y", (Object)this.y.toString());
        if (this.d != null) {
            o.put((Object)"d", (Object)this.d.toString());
        }
        return o;
    }

    public static ECKey parse(String s) throws ParseException {
        return ECKey.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static ECKey parse(JSONObject jsonObject) throws ParseException {
        Curve crv = Curve.parse(JSONObjectUtils.getString(jsonObject, "crv"));
        Base64URL x = new Base64URL(JSONObjectUtils.getString(jsonObject, "x"));
        Base64URL y = new Base64URL(JSONObjectUtils.getString(jsonObject, "y"));
        KeyType kty = KeyType.parse(JSONObjectUtils.getString(jsonObject, "kty"));
        if (kty != KeyType.EC) {
            throw new ParseException("The key type \"kty\" must be EC", 0);
        }
        Base64URL d = null;
        if (jsonObject.get((Object)"d") != null) {
            d = new Base64URL(JSONObjectUtils.getString(jsonObject, "d"));
        }
        Use use = null;
        if (jsonObject.containsKey((Object)"use")) {
            use = Use.parse(JSONObjectUtils.getString(jsonObject, "use"));
        }
        Algorithm alg = null;
        if (jsonObject.containsKey((Object)"alg")) {
            alg = new Algorithm(JSONObjectUtils.getString(jsonObject, "alg"));
        }
        String kid = null;
        if (jsonObject.containsKey((Object)"kid")) {
            kid = JSONObjectUtils.getString(jsonObject, "kid");
        }
        URL x5u = null;
        if (jsonObject.containsKey((Object)"x5u")) {
            x5u = JSONObjectUtils.getURL(jsonObject, "x5u");
        }
        Base64URL x5t = null;
        if (jsonObject.containsKey((Object)"x5t")) {
            x5t = new Base64URL(JSONObjectUtils.getString(jsonObject, "x5t"));
        }
        List<Base64> x5c = null;
        if (jsonObject.containsKey((Object)"x5c")) {
            x5c = X509CertChainUtils.parseX509CertChain(JSONObjectUtils.getJSONArray(jsonObject, "x5c"));
        }
        if (d == null) {
            return new ECKey(crv, x, y, use, alg, kid, x5u, x5t, x5c);
        }
        return new ECKey(crv, x, y, d, use, alg, kid, x5u, x5t, x5c);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final Curve crv;
        private final Base64URL x;
        private final Base64URL y;
        private Base64URL d;
        private Use use;
        private Algorithm alg;
        private String kid;
        private URL x5u;
        private Base64URL x5t;
        private List<Base64> x5c;

        public Builder(Curve crv, Base64URL x, Base64URL y) {
            if (crv == null) {
                throw new IllegalArgumentException("The curve must not be null");
            }
            this.crv = crv;
            if (x == null) {
                throw new IllegalArgumentException("The 'x' coordinate must not be null");
            }
            this.x = x;
            if (y == null) {
                throw new IllegalArgumentException("The 'y' coordinate must not be null");
            }
            this.y = y;
        }

        public Builder(Curve crv, ECPublicKey pub) {
            this(crv, Base64URL.encode(pub.getW().getAffineX()), Base64URL.encode(pub.getW().getAffineY()));
        }

        public Builder setD(Base64URL d) {
            this.d = d;
            return this;
        }

        public Builder setPrivateKey(ECPrivateKey priv) {
            if (priv != null) {
                this.d = Base64URL.encode(priv.getS());
            }
            return this;
        }

        public Builder setKeyUse(Use use) {
            this.use = use;
            return this;
        }

        public Builder setAlgorithm(Algorithm alg) {
            this.alg = alg;
            return this;
        }

        public Builder setKeyID(String kid) {
            this.kid = kid;
            return this;
        }

        public Builder setX509CertURL(URL x5u) {
            this.x5u = x5u;
            return this;
        }

        public Builder setX509CertThumbprint(Base64URL x5t) {
            this.x5t = x5t;
            return this;
        }

        public Builder setX509CertChain(List<Base64> x5c) {
            this.x5c = x5c;
            return this;
        }

        public ECKey build() {
            if (this.d == null) {
                return new ECKey(this.crv, this.x, this.y, this.use, this.alg, this.kid, this.x5u, this.x5t, this.x5c);
            }
            return new ECKey(this.crv, this.x, this.y, this.d, this.use, this.alg, this.kid, this.x5u, this.x5t, this.x5c);
        }
    }

    @Immutable
    public static class Curve {
        public static final Curve P_256 = new Curve("P-256", "secp256r1");
        public static final Curve P_384 = new Curve("P-384", "secp384r1");
        public static final Curve P_521 = new Curve("P-521", "secp521r1");
        private final String name;
        private final String stdName;

        public Curve(String name) {
            this(name, null);
        }

        public Curve(String name, String stdName) {
            if (name == null) {
                throw new IllegalArgumentException("The cryptographic curve name must not be null");
            }
            this.name = name;
            this.stdName = stdName;
        }

        public String getName() {
            return this.name;
        }

        public String getStdName() {
            return this.stdName;
        }

        public ECParameterSpec toECParameterSpec() {
            if (this.stdName == null) {
                return null;
            }
            ECNamedCurveParameterSpec curveParams = ECNamedCurveTable.getParameterSpec((String)this.stdName);
            if (curveParams == null) {
                return null;
            }
            return new ECNamedCurveSpec(curveParams.getName(), curveParams.getCurve(), curveParams.getG(), curveParams.getN());
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object object) {
            return object != null && object instanceof Curve && this.toString().equals(object.toString());
        }

        public static Curve parse(String s) throws ParseException {
            if (s == null) {
                throw new IllegalArgumentException("The cryptographic curve string must not be null");
            }
            if (s.equals(P_256.getName())) {
                return P_256;
            }
            if (s.equals(P_384.getName())) {
                return P_384;
            }
            if (s.equals(P_521.getName())) {
                return P_521;
            }
            return new Curve(s);
        }

        public static Curve forStdName(String stdName) {
            if (stdName.equals("secp256r1")) {
                return P_256;
            }
            if (stdName.equals("secp384r1")) {
                return P_384;
            }
            if (stdName.equals("secp521r1")) {
                return P_521;
            }
            throw new IllegalArgumentException("No matching curve constant for standard (JCA) name " + stdName);
        }
    }
}

