/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.ReadOnlyJWSHeader;
import com.nimbusds.jose.crypto.ECDSAParameters;
import com.nimbusds.jose.crypto.ECDSAProvider;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.BigIntegerUtils;
import java.math.BigInteger;
import net.jcip.annotations.ThreadSafe;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;

@ThreadSafe
public class ECDSASigner
extends ECDSAProvider
implements JWSSigner {
    private final BigInteger privateKey;

    public ECDSASigner(BigInteger privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The private key must not be null");
        }
        this.privateKey = privateKey;
    }

    public BigInteger getPrivateKey() {
        return this.privateKey;
    }

    private static BigInteger[] doECDSA(ECPrivateKeyParameters ecPrivateKeyParameters, byte[] bytes) {
        org.bouncycastle.crypto.signers.ECDSASigner signer = new org.bouncycastle.crypto.signers.ECDSASigner();
        signer.init(true, (CipherParameters)ecPrivateKeyParameters);
        return signer.generateSignature(bytes);
    }

    private static byte[] formatSignature(BigInteger r, BigInteger s, int rsByteArrayLength) {
        byte[] rBytes = BigIntegerUtils.toBytesUnsigned(r);
        byte[] sBytes = BigIntegerUtils.toBytesUnsigned(s);
        byte[] rsBytes = new byte[rsByteArrayLength];
        int i = 0;
        int offset = rsByteArrayLength / 2 - rBytes.length;
        i += offset;
        for (byte rB : rBytes) {
            rsBytes[i++] = rB;
        }
        i = rsByteArrayLength / 2;
        offset = rsByteArrayLength / 2 - sBytes.length;
        i += offset;
        for (byte sB : sBytes) {
            rsBytes[i++] = sB;
        }
        return rsBytes;
    }

    public Base64URL sign(ReadOnlyJWSHeader header, byte[] signingInput) throws JOSEException {
        ECDSAParameters initParams = ECDSASigner.getECDSAParameters(header.getAlgorithm());
        X9ECParameters x9ECParameters = initParams.getX9ECParameters();
        Digest digest = initParams.getDigest();
        ECDomainParameters ecParameterSpec = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(this.privateKey, ecParameterSpec);
        digest.update(signingInput, 0, signingInput.length);
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        BigInteger[] signatureParts = ECDSASigner.doECDSA(ecPrivateKeyParameters, out);
        int rsByteArrayLength = ECDSAProvider.getSignatureByteArrayLength(header.getAlgorithm());
        return Base64URL.encode(ECDSASigner.formatSignature(signatureParts[0], signatureParts[1], rsByteArrayLength));
    }
}

