/**
 * Javascript Object Signing and Encryption (JOSE) classes.
 *
 * <p>This package provides representation, compact serialisation and parsing 
 * for the following JOSE objects:
 *
 * <ul>
 *     <li>{@link com.nimbusds.jose.PlainObject Plaintext (unprotected) JOSE 
 *         objects}.
 *     <li>{@link com.nimbusds.jose.JWSObject JSON Web Signature (JWS) 
 *         objects}.
 *     <li>{@link com.nimbusds.jose.JWEObject JSON Web Encryption (JWE) 
 *         objects}.
 *     <li>{@link com.nimbusds.jose.jwk.JWK JSON Web Key (JWK) objects}.
 * </ul>
 *
 * <p>References:
 *
 * <ul>
 *     <li>http://tools.ietf.org/wg/jose/
 * </ul>
 */
package com.nimbusds.jose;
