/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.proc;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.KeyTypeException;
import com.nimbusds.jose.crypto.AESDecrypter;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.nimbusds.jose.crypto.ECDHDecrypter;
import com.nimbusds.jose.crypto.PasswordBasedDecrypter;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.proc.JWEDecrypterFactory;
import java.security.Key;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.SecretKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWEDecrypterFactory
implements JWEDecrypterFactory {
    @Override
    public JWEDecrypter createJWEDecrypter(JWEHeader header, Key key) throws JOSEException {
        if (RSADecrypter.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm()) && RSADecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(header.getEncryptionMethod())) {
            if (!(key instanceof RSAPrivateKey)) {
                throw new KeyTypeException(RSAPrivateKey.class);
            }
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)key;
            return new RSADecrypter(rsaPrivateKey);
        }
        if (ECDHDecrypter.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm()) && ECDHDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(header.getEncryptionMethod())) {
            if (!(key instanceof ECPrivateKey)) {
                throw new KeyTypeException(ECPrivateKey.class);
            }
            ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
            return new ECDHDecrypter(ecPrivateKey);
        }
        if (DirectDecrypter.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm()) && DirectDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(header.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            SecretKey aesKey = (SecretKey)key;
            DirectDecrypter directDecrypter = new DirectDecrypter(aesKey);
            if (!directDecrypter.supportedEncryptionMethods().contains(header.getEncryptionMethod())) {
                throw new KeyLengthException(header.getEncryptionMethod().cekBitLength(), header.getEncryptionMethod());
            }
            return directDecrypter;
        }
        if (AESDecrypter.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm()) && AESDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(header.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            SecretKey aesKey = (SecretKey)key;
            AESDecrypter aesDecrypter = new AESDecrypter(aesKey);
            if (!aesDecrypter.supportedJWEAlgorithms().contains(header.getAlgorithm())) {
                throw new KeyLengthException(header.getAlgorithm());
            }
            return aesDecrypter;
        }
        if (PasswordBasedDecrypter.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm()) && PasswordBasedDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(header.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            byte[] password = key.getEncoded();
            return new PasswordBasedDecrypter(password);
        }
        throw new JOSEException("Unsupported JWE algorithm or encryption method");
    }
}

