/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.CriticalHeaderParamsAware;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.AlgorithmSupportMessage;
import com.nimbusds.jose.crypto.ContentCryptoProvider;
import com.nimbusds.jose.crypto.CriticalHeaderParamsDeferral;
import com.nimbusds.jose.crypto.RSA1_5;
import com.nimbusds.jose.crypto.RSACryptoProvider;
import com.nimbusds.jose.crypto.RSA_OAEP;
import com.nimbusds.jose.crypto.RSA_OAEP_256;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import java.security.interfaces.RSAPrivateKey;
import java.util.Set;
import javax.crypto.SecretKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSADecrypter
extends RSACryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final RSAPrivateKey privateKey;

    public RSADecrypter(RSAPrivateKey privateKey) {
        this(privateKey, null);
    }

    public RSADecrypter(RSAKey rsaJWK) throws JOSEException {
        if (!rsaJWK.isPrivate()) {
            throw new JOSEException("The RSA JWK doesn't contain a private part");
        }
        this.privateKey = rsaJWK.toRSAPrivateKey();
    }

    public RSADecrypter(RSAPrivateKey privateKey, Set<String> defCritHeaders) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The private RSA key must not be null");
        }
        this.privateKey = privateKey;
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        SecretKey cek;
        if (encryptedKey == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (iv == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (authTag == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        this.critPolicy.ensureHeaderPasses(header);
        JWEAlgorithm alg = header.getAlgorithm();
        if (alg.equals(JWEAlgorithm.RSA1_5)) {
            int keyLength = header.getEncryptionMethod().cekBitLength();
            SecretKey randomCEK = ContentCryptoProvider.generateCEK(header.getEncryptionMethod(), this.getJCAContext().getSecureRandom());
            try {
                cek = RSA1_5.decryptCEK(this.privateKey, encryptedKey.decode(), keyLength, this.getJCAContext().getKeyEncryptionProvider());
                if (cek == null) {
                    cek = randomCEK;
                }
            }
            catch (Exception e) {
                cek = randomCEK;
            }
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
            cek = RSA_OAEP.decryptCEK(this.privateKey, encryptedKey.decode(), this.getJCAContext().getKeyEncryptionProvider());
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP_256)) {
            cek = RSA_OAEP_256.decryptCEK(this.privateKey, encryptedKey.decode(), this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.decrypt(header, encryptedKey, iv, cipherText, authTag, cek, this.getJCAContext());
    }
}

