/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Identifier;
import net.jcip.annotations.Immutable;

@Immutable
public final class GrantType
extends Identifier {
    public static final GrantType AUTHORIZATION_CODE = new GrantType("authorization_code", false, true);
    public static final GrantType IMPLICIT = new GrantType("implicit", false, true);
    public static final GrantType REFRESH_TOKEN = new GrantType("refresh_token", false, false);
    public static final GrantType PASSWORD = new GrantType("password", false, false);
    public static final GrantType CLIENT_CREDENTIALS = new GrantType("client_credentials", true, true);
    public static final GrantType JWT_BEARER = new GrantType("urn:ietf:params:oauth:grant-type:jwt-bearer", false, false);
    public static final GrantType SAML2_BEARER = new GrantType("urn:ietf:params:oauth:grant-type:saml2-bearer", false, false);
    private final boolean requiresClientAuth;
    private final boolean requiresClientID;

    public GrantType(String value) {
        this(value, false, false);
    }

    private GrantType(String value, boolean requiresClientAuth, boolean requiresClientID) {
        super(value);
        this.requiresClientAuth = requiresClientAuth;
        this.requiresClientID = requiresClientID;
    }

    public boolean requiresClientAuthentication() {
        return this.requiresClientAuth;
    }

    public boolean requiresClientID() {
        return this.requiresClientID;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof GrantType && this.toString().equals(object.toString());
    }

    public static GrantType parse(String value) throws ParseException {
        GrantType grantType;
        try {
            grantType = new GrantType(value);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage());
        }
        if (grantType.equals(AUTHORIZATION_CODE)) {
            return AUTHORIZATION_CODE;
        }
        if (grantType.equals(IMPLICIT)) {
            return IMPLICIT;
        }
        if (grantType.equals(REFRESH_TOKEN)) {
            return REFRESH_TOKEN;
        }
        if (grantType.equals(PASSWORD)) {
            return PASSWORD;
        }
        if (grantType.equals(CLIENT_CREDENTIALS)) {
            return CLIENT_CREDENTIALS;
        }
        if (grantType.equals(JWT_BEARER)) {
            return JWT_BEARER;
        }
        if (grantType.equals(SAML2_BEARER)) {
            return SAML2_BEARER;
        }
        return grantType;
    }
}

