/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.JWTID;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.util.DateUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minidev.json.JSONObject;

public class JWTAuthenticationClaimsSet {
    private static final Set<String> reservedClaimNames = new LinkedHashSet<String>();
    private final Issuer iss;
    private final Subject sub;
    private final Audience aud;
    private final Date exp;
    private final Date nbf;
    private final Date iat;
    private final JWTID jti;

    public static Set<String> getReservedClaimNames() {
        return Collections.unmodifiableSet(reservedClaimNames);
    }

    public JWTAuthenticationClaimsSet(ClientID clientID, Audience aud, Date exp, Date nbf, Date iat, JWTID jti) {
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.iss = new Issuer(clientID.getValue());
        this.sub = new Subject(clientID.getValue());
        if (aud == null) {
            throw new IllegalArgumentException("The audience must not be null");
        }
        this.aud = aud;
        if (exp == null) {
            throw new IllegalArgumentException("The expiration time must not be null");
        }
        this.exp = exp;
        this.nbf = nbf;
        this.iat = iat;
        this.jti = jti;
    }

    public ClientID getClientID() {
        return new ClientID(this.iss.getValue());
    }

    public Issuer getIssuer() {
        return this.iss;
    }

    public Subject getSubject() {
        return this.sub;
    }

    public Audience getAudience() {
        return this.aud;
    }

    public Date getExpirationTime() {
        return this.exp;
    }

    public Date getNotBeforeTime() {
        return this.nbf;
    }

    public Date getIssueTime() {
        return this.iat;
    }

    public JWTID getJWTID() {
        return this.jti;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put((Object)"iss", (Object)this.iss.getValue());
        o.put((Object)"sub", (Object)this.sub.getValue());
        LinkedList<Audience> audList = new LinkedList<Audience>();
        audList.add(this.aud);
        o.put((Object)"aud", audList);
        o.put((Object)"exp", (Object)DateUtils.toSecondsSinceEpoch(this.exp));
        if (this.nbf != null) {
            o.put((Object)"nbf", (Object)DateUtils.toSecondsSinceEpoch(this.nbf));
        }
        if (this.iat != null) {
            o.put((Object)"iat", (Object)DateUtils.toSecondsSinceEpoch(this.iat));
        }
        if (this.jti != null) {
            o.put((Object)"jti", (Object)this.jti.getValue());
        }
        return o;
    }

    public JWTClaimsSet toJWTClaimsSet() {
        return new JWTClaimsSet.Builder().issuer(this.iss.getValue()).subject(this.sub.getValue()).audience(this.aud.getValue()).expirationTime(this.exp).notBeforeTime(this.nbf).issueTime(this.iat).jwtID(this.jti.getValue()).build();
    }

    public static JWTAuthenticationClaimsSet parse(JSONObject jsonObject) throws ParseException {
        Audience aud;
        Issuer iss = new Issuer(JSONObjectUtils.getString(jsonObject, "iss"));
        Subject sub = new Subject(JSONObjectUtils.getString(jsonObject, "sub"));
        if (jsonObject.get((Object)"aud") instanceof String) {
            aud = new Audience(JSONObjectUtils.getString(jsonObject, "aud"));
        } else {
            String[] audList = JSONObjectUtils.getStringArray(jsonObject, "aud");
            if (audList.length > 1) {
                throw new ParseException("Multiple audiences (aud) not supported");
            }
            aud = new Audience(audList[0]);
        }
        Date exp = DateUtils.fromSecondsSinceEpoch(JSONObjectUtils.getLong(jsonObject, "exp"));
        Date nbf = null;
        if (jsonObject.containsKey((Object)"nbf")) {
            nbf = DateUtils.fromSecondsSinceEpoch(JSONObjectUtils.getLong(jsonObject, "nbf"));
        }
        Date iat = null;
        if (jsonObject.containsKey((Object)"iat")) {
            iat = DateUtils.fromSecondsSinceEpoch(JSONObjectUtils.getLong(jsonObject, "iat"));
        }
        JWTID jti = null;
        if (jsonObject.containsKey((Object)"jti")) {
            jti = new JWTID(JSONObjectUtils.getString(jsonObject, "jti"));
        }
        if (!iss.getValue().equals(sub.getValue())) {
            throw new ParseException("JWT issuer and subject must have the same client ID");
        }
        ClientID clientID = new ClientID(iss.getValue());
        return new JWTAuthenticationClaimsSet(clientID, aud, exp, nbf, iat, jti);
    }

    public static JWTAuthenticationClaimsSet parse(JWTClaimsSet jwtClaimsSet) throws ParseException {
        return JWTAuthenticationClaimsSet.parse(jwtClaimsSet.toJSONObject());
    }

    static {
        reservedClaimNames.add("iss");
        reservedClaimNames.add("sub");
        reservedClaimNames.add("aud");
        reservedClaimNames.add("exp");
        reservedClaimNames.add("nbf");
        reservedClaimNames.add("iat");
        reservedClaimNames.add("jti");
    }
}

