/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import com.nimbusds.oauth2.sdk.auth.JWTAuthenticationClaimsSet;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.URI;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class PrivateKeyJWT
extends JWTAuthentication {
    public static Set<JWSAlgorithm> getSupportedJWAs() {
        HashSet<JWSAlgorithm> supported = new HashSet<JWSAlgorithm>();
        supported.add(JWSAlgorithm.RS256);
        supported.add(JWSAlgorithm.RS384);
        supported.add(JWSAlgorithm.RS512);
        supported.add(JWSAlgorithm.PS256);
        supported.add(JWSAlgorithm.PS384);
        supported.add(JWSAlgorithm.PS512);
        supported.add(JWSAlgorithm.ES256);
        supported.add(JWSAlgorithm.ES384);
        supported.add(JWSAlgorithm.ES512);
        return Collections.unmodifiableSet(supported);
    }

    public static SignedJWT createClientAssertion(JWTAuthenticationClaimsSet jwtAuthClaimsSet, JWSAlgorithm jwsAlgorithm, RSAPrivateKey rsaPrivateKey, Provider jcaProvider) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(jwsAlgorithm), jwtAuthClaimsSet.toJWTClaimsSet());
        RSASSASigner signer = new RSASSASigner(rsaPrivateKey);
        if (jcaProvider != null) {
            signer.getJCAContext().setProvider(jcaProvider);
        }
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }

    public static SignedJWT createClientAssertion(JWTAuthenticationClaimsSet jwtAuthClaimsSet, JWSAlgorithm jwsAlgorithm, ECPrivateKey ecPrivateKey, Provider jcaProvider) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(jwsAlgorithm), jwtAuthClaimsSet.toJWTClaimsSet());
        ECDSASigner signer = new ECDSASigner(ecPrivateKey);
        if (jcaProvider != null) {
            signer.getJCAContext().setProvider(jcaProvider);
        }
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }

    public PrivateKeyJWT(ClientID clientID, URI tokenEndpoint, JWSAlgorithm jwsAlgorithm, RSAPrivateKey rsaPrivateKey, Provider jcaProvider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(tokenEndpoint.toString())), jwsAlgorithm, rsaPrivateKey, jcaProvider);
    }

    public PrivateKeyJWT(JWTAuthenticationClaimsSet jwtAuthClaimsSet, JWSAlgorithm jwsAlgorithm, RSAPrivateKey rsaPrivateKey, Provider jcaProvider) throws JOSEException {
        this(PrivateKeyJWT.createClientAssertion(jwtAuthClaimsSet, jwsAlgorithm, rsaPrivateKey, jcaProvider));
    }

    public PrivateKeyJWT(ClientID clientID, URI tokenEndpoint, JWSAlgorithm jwsAlgorithm, ECPrivateKey ecPrivateKey, Provider jcaProvider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(tokenEndpoint.toString())), jwsAlgorithm, ecPrivateKey, jcaProvider);
    }

    public PrivateKeyJWT(JWTAuthenticationClaimsSet jwtAuthClaimsSet, JWSAlgorithm jwsAlgorithm, ECPrivateKey ecPrivateKey, Provider jcaProvider) throws JOSEException {
        this(PrivateKeyJWT.createClientAssertion(jwtAuthClaimsSet, jwsAlgorithm, ecPrivateKey, jcaProvider));
    }

    public PrivateKeyJWT(SignedJWT clientAssertion) {
        super(ClientAuthenticationMethod.PRIVATE_KEY_JWT, clientAssertion);
        if (!PrivateKeyJWT.getSupportedJWAs().contains(clientAssertion.getHeader().getAlgorithm())) {
            throw new IllegalArgumentException("The client assertion JWT must be RSA or ECDSA-signed (RS256, RS384, RS512, PS256, PS384, PS512, ES256, ES384 or ES512)");
        }
    }

    public static PrivateKeyJWT parse(Map<String, String> params) throws ParseException {
        PrivateKeyJWT privateKeyJWT;
        JWTAuthentication.ensureClientAssertionType(params);
        SignedJWT clientAssertion = JWTAuthentication.parseClientAssertion(params);
        try {
            privateKeyJWT = new PrivateKeyJWT(clientAssertion);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), e);
        }
        ClientID clientID = JWTAuthentication.parseClientID(params);
        if (clientID != null && !clientID.equals(privateKeyJWT.getClientID())) {
            throw new ParseException("The client identifier doesn't match the client assertion subject / issuer");
        }
        return privateKeyJWT;
    }

    public static PrivateKeyJWT parse(String paramsString) throws ParseException {
        Map<String, String> params = URLUtils.parseParameters(paramsString);
        return PrivateKeyJWT.parse(params);
    }

    public static PrivateKeyJWT parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        return PrivateKeyJWT.parse(httpRequest.getQueryParameters());
    }
}

