/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.AbstractTLSClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class TLSClientAuthentication
extends AbstractTLSClientAuthentication {
    private final String certSubjectDN;
    private final String certRootDN;

    public TLSClientAuthentication(ClientID clientID, SSLSocketFactory sslSocketFactory) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID, sslSocketFactory);
        this.certSubjectDN = null;
        this.certRootDN = null;
    }

    public TLSClientAuthentication(ClientID clientID, String certSubjectDN, String certRootDN) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID);
        if (certSubjectDN == null) {
            throw new IllegalArgumentException("The X.509 client certificate subject DN must not be null");
        }
        this.certSubjectDN = certSubjectDN;
        this.certRootDN = certRootDN;
    }

    public String getClientX509CertificateSubjectDN() {
        return this.certSubjectDN;
    }

    public String getClientX509CertificateRootDN() {
        return this.certRootDN;
    }

    public static TLSClientAuthentication parse(HTTPRequest httpRequest) throws ParseException {
        String query = httpRequest.getQuery();
        if (query == null) {
            throw new ParseException("Missing HTTP POST request entity body");
        }
        Map<String, String> params = URLUtils.parseParameters(query);
        String clientIDString = params.get("client_id");
        if (StringUtils.isBlank((CharSequence)clientIDString)) {
            throw new ParseException("Missing client_id parameter");
        }
        if (httpRequest.getClientX509CertificateSubjectDN() == null) {
            throw new ParseException("Missing client X.509 certificate subject DN");
        }
        return new TLSClientAuthentication(new ClientID(clientIDString), httpRequest.getClientX509CertificateSubjectDN(), httpRequest.getClientX509CertificateRootDN());
    }

    public static /* bridge */ /* synthetic */ ClientAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        return TLSClientAuthentication.parse(hTTPRequest);
    }
}

