/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.jose.jwk;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.oauth2.sdk.http.DefaultResourceRetriever;
import com.nimbusds.oauth2.sdk.http.Resource;
import com.nimbusds.oauth2.sdk.http.RestrictedResourceRetriever;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.jose.jwk.AbstractJWKSource;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@Deprecated
public class RemoteJWKSet
extends AbstractJWKSource {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 250;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 250;
    public static final int DEFAULT_HTTP_SIZE_LIMIT = 51200;
    private final URL jwkSetURL;
    private final AtomicReference<JWKSet> cachedJWKSet = new AtomicReference();
    private final RestrictedResourceRetriever jwkSetRetriever;

    public RemoteJWKSet(Identifier id, URL jwkSetURL, RestrictedResourceRetriever resourceRetriever) {
        super(id);
        if (jwkSetURL == null) {
            throw new IllegalArgumentException("The JWK set URL must not be null");
        }
        this.jwkSetURL = jwkSetURL;
        this.jwkSetRetriever = resourceRetriever != null ? resourceRetriever : new DefaultResourceRetriever(250, 250, 51200);
        Thread t = new Thread(){

            @Override
            public void run() {
                RemoteJWKSet.this.updateJWKSetFromURL();
            }
        };
        t.setName("initial-jwk-set-retriever[" + jwkSetURL + "]");
        t.start();
    }

    private JWKSet updateJWKSetFromURL() {
        JWKSet jwkSet;
        try {
            Resource res = this.jwkSetRetriever.retrieveResource(this.jwkSetURL);
            jwkSet = JWKSet.parse((String)res.getContent());
        }
        catch (IOException | ParseException exception) {
            return null;
        }
        this.cachedJWKSet.set(jwkSet);
        return jwkSet;
    }

    public URL getJWKSetURL() {
        return this.jwkSetURL;
    }

    public RestrictedResourceRetriever getResourceRetriever() {
        return this.jwkSetRetriever;
    }

    public JWKSet getJWKSet() {
        JWKSet jwkSet = this.cachedJWKSet.get();
        if (jwkSet != null) {
            return jwkSet;
        }
        return this.updateJWKSetFromURL();
    }

    protected static String getFirstSpecifiedKeyID(JWKMatcher jwkMatcher) {
        Set keyIDs = jwkMatcher.getKeyIDs();
        if (keyIDs == null || keyIDs.isEmpty()) {
            return null;
        }
        for (String id : keyIDs) {
            if (id == null) continue;
            return id;
        }
        return null;
    }

    @Override
    public List<JWK> get(Identifier id, JWKSelector jwkSelector) {
        if (!this.getOwner().equals(id)) {
            return Collections.emptyList();
        }
        JWKSet jwkSet = this.getJWKSet();
        if (jwkSet == null) {
            return Collections.emptyList();
        }
        List matches = jwkSelector.select(jwkSet);
        if (!matches.isEmpty()) {
            return matches;
        }
        String soughtKeyID = RemoteJWKSet.getFirstSpecifiedKeyID(jwkSelector.getMatcher());
        if (soughtKeyID == null) {
            return matches;
        }
        if (jwkSet.getKeyByKeyId(soughtKeyID) != null) {
            return matches;
        }
        jwkSet = this.updateJWKSetFromURL();
        if (jwkSet == null) {
            return null;
        }
        return jwkSelector.select(jwkSet);
    }
}

