/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.token;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.AccessTokenType;
import com.nimbusds.oauth2.sdk.token.AccessTokenUtils;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class DPoPAccessToken
extends AccessToken {
    private static final long serialVersionUID = 7745184045632691024L;

    public DPoPAccessToken(String value) {
        this(value, 0L, null);
    }

    public DPoPAccessToken(String value, long lifetime, Scope scope) {
        super(AccessTokenType.DPOP, value, lifetime, scope);
    }

    @Override
    public String toAuthorizationHeader() {
        return "DPoP " + this.getValue();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DPoPAccessToken && this.toString().equals(object.toString());
    }

    public static DPoPAccessToken parse(JSONObject jsonObject) throws ParseException {
        AccessTokenUtils.parseAndEnsureType(jsonObject, AccessTokenType.DPOP);
        String accessTokenValue = AccessTokenUtils.parseValue(jsonObject);
        long lifetime = AccessTokenUtils.parseLifetime(jsonObject);
        Scope scope = AccessTokenUtils.parseScope(jsonObject);
        return new DPoPAccessToken(accessTokenValue, lifetime, scope);
    }

    public static DPoPAccessToken parse(String header) throws ParseException {
        return new DPoPAccessToken(AccessTokenUtils.parseValueFromHeader(header, AccessTokenType.DPOP));
    }

    public static DPoPAccessToken parse(Map<String, List<String>> parameters) throws ParseException {
        if (!parameters.containsKey("access_token")) {
            throw new ParseException("Missing access token parameter", BearerTokenError.MISSING_TOKEN);
        }
        String accessTokenValue = MultivaluedMapUtils.getFirstValue(parameters, "access_token");
        if (StringUtils.isBlank(accessTokenValue)) {
            throw new ParseException("Blank / empty access token", BearerTokenError.INVALID_REQUEST);
        }
        return new DPoPAccessToken(accessTokenValue);
    }

    public static DPoPAccessToken parse(HTTPRequest request) throws ParseException {
        String authzHeader = request.getAuthorization();
        if (authzHeader != null) {
            return DPoPAccessToken.parse(authzHeader);
        }
        Map<String, List<String>> params = request.getQueryParameters();
        return DPoPAccessToken.parse(params);
    }
}

