/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.runners;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NicelyParameterized
extends Parameterized {
    private final ArrayList<Runner> runners = new ArrayList();

    public NicelyParameterized(Class<?> klass) throws Throwable {
        super(klass);
        List<Object[]> parametersList = this.getParametersList(this.getTestClass());
        for (int i = 0; i < parametersList.size(); ++i) {
            this.runners.add((Runner)new TestClassRunnerForParameters(this.getTestClass().getJavaClass(), parametersList, i));
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private List<Object[]> getParametersList(TestClass klass) throws Throwable {
        return (List)this.getParametersMethod(klass).invokeExplosively(null, new Object[0]);
    }

    FrameworkMethod getParametersMethod(TestClass testClass) throws Exception {
        List methods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        if (methods.isEmpty()) {
            throw new RuntimeException("No @Parameters method in class " + testClass.getName());
        }
        if (methods.size() > 1) {
            throw new RuntimeException("Multiple methods annotated with @Parameters. Only one method should be thus annotated per class.");
        }
        FrameworkMethod method = (FrameworkMethod)methods.get(0);
        int modifiers = method.getMethod().getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new RuntimeException("@Parameters method " + method.getName() + " must be declared public static in class " + testClass.getName());
        }
        return method;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestClassRunnerForParameters
    extends BlockJUnit4ClassRunner {
        private final int fParameterSetNumber;
        private final List<Object[]> fParameterList;
        private String name;

        TestClassRunnerForParameters(Class<?> type, List<Object[]> parameterList, int i) throws InitializationError {
            super(type);
            this.fParameterList = parameterList;
            this.fParameterSetNumber = i;
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.computeParams());
        }

        private Object[] computeParams() throws Exception {
            try {
                return this.fParameterList.get(this.fParameterSetNumber);
            }
            catch (ClassCastException e) {
                throw new Exception(String.format("%s.%s() must return a Collection of arrays.", this.getTestClass().getName(), NicelyParameterized.this.getParametersMethod(this.getTestClass()).getName()));
            }
        }

        protected String getName() {
            if (this.name == null) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Object parameter : this.fParameterList.get(this.fParameterSetNumber)) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    if (parameter instanceof String) {
                        parameter = '\"' + (String)parameter + '\"';
                    }
                    sb.append(parameter);
                }
                this.name = this.fParameterSetNumber + ". " + sb;
            }
            return this.name;
        }

        protected String testName(FrameworkMethod method) {
            return method.getName() + " \u0000[" + this.name + "] " + this.getTestClass().getName();
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }
    }
}

