/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.runners.parameterized;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.junit.runner.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionMapper {
    private final Map<Description, Description> originalToRewrittenDescriptionMap = new HashMap<Description, Description>();
    private final Class<?> testClass;
    private final Constructor<Description> descConstr;
    private final Field uniqueIdField;
    private final Field testClassField;

    public DescriptionMapper(Class<?> testClass) {
        this.testClass = testClass;
        try {
            this.descConstr = Description.class.getDeclaredConstructor(Class.class, String.class, Serializable.class, Annotation[].class);
            this.uniqueIdField = Description.class.getDeclaredField("fUniqueId");
            this.testClassField = Description.class.getDeclaredField("fTestClass");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        this.descConstr.setAccessible(true);
        this.uniqueIdField.setAccessible(true);
        this.testClassField.setAccessible(true);
    }

    public Description rewriteDescription(String description, Description orig) {
        return this.createDescription(this.testClass, description, orig);
    }

    private Description rewriteIndirectChildDescription(Description orig) {
        Class<?> childTestClass = this.getTestClassFromDescription(orig);
        String displayName = orig.getDisplayName();
        if (childTestClass.getSuperclass() == this.testClass) {
            displayName = displayName.replace(childTestClass.getName(), this.testClass.getName());
            childTestClass = this.testClass;
        }
        return this.createDescription(childTestClass, displayName, orig);
    }

    private Description createDescription(Class<?> testClass, String displayName, Description orig) {
        Description desc;
        Serializable uniqueId = this.getUniqueIdFromDescription(orig);
        Annotation[] annotations = orig.getAnnotations().toArray(new Annotation[0]);
        try {
            desc = this.descConstr.newInstance(testClass, displayName, uniqueId, annotations);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        for (Description child : orig.getChildren()) {
            desc.addChild(this.rewriteIndirectChildDescription(child));
        }
        this.originalToRewrittenDescriptionMap.put(orig, desc);
        return desc;
    }

    private Class<?> getTestClassFromDescription(Description orig) {
        Class origTestClass;
        try {
            origTestClass = (Class)this.testClassField.get(orig);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return origTestClass;
    }

    private Serializable getUniqueIdFromDescription(Description desc) {
        try {
            return (Serializable)this.uniqueIdField.get(desc);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Description map(Description orig) {
        Description desc = this.originalToRewrittenDescriptionMap.get(orig);
        assert (desc != null) : "WrappingParameterizedRunner: Internal error";
        return desc;
    }
}

