/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.runners.parameterized;

import com.nitorcreations.junit.runners.parameterized.DescriptionMapper;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

class DescriptionMappingRunNotifierProxy
extends RunNotifier {
    DescriptionMappingRunNotifierProxy(final RunNotifier targetNotifier, final DescriptionMapper descriptionMapper) {
        this.addListener(new RunListener(){

            public void testAssumptionFailure(Failure failure) {
                targetNotifier.fireTestAssumptionFailed(this.mapFailure(failure));
            }

            public void testFailure(Failure failure) throws Exception {
                targetNotifier.fireTestFailure(this.mapFailure(failure));
            }

            public void testFinished(Description description) throws Exception {
                targetNotifier.fireTestFinished(this.mapDescription(description));
            }

            public void testIgnored(Description description) throws Exception {
                targetNotifier.fireTestIgnored(this.mapDescription(description));
            }

            public void testStarted(Description description) throws Exception {
                targetNotifier.fireTestStarted(this.mapDescription(description));
            }

            private Failure mapFailure(Failure failure) {
                return new Failure(this.mapDescription(failure.getDescription()), failure.getException());
            }

            private Description mapDescription(Description orig) {
                return descriptionMapper.map(orig);
            }
        });
    }
}

