/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.runners.parameterized;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedSuiteBuilder {
    private final Class<?> testClass;
    private final List<TestInstantiatorBuilder> tests = new ArrayList<TestInstantiatorBuilder>();
    static final Map<Class<?>, Class<?>> UNBOXED_TO_BOXED = new HashMap();

    public ParameterizedSuiteBuilder(Class<?> testClass) {
        this.testClass = testClass;
    }

    public TestInstantiatorBuilder constructWith(Object ... constructorArgs) {
        TestInstantiatorBuilder testBuilder = new TestInstantiatorBuilder(constructorArgs);
        this.tests.add(testBuilder);
        return testBuilder;
    }

    List<TestInstantiatorBuilder> getTests() {
        return this.tests;
    }

    static {
        UNBOXED_TO_BOXED.put(Integer.TYPE, Integer.class);
        UNBOXED_TO_BOXED.put(Byte.TYPE, Byte.class);
        UNBOXED_TO_BOXED.put(Character.TYPE, Character.class);
        UNBOXED_TO_BOXED.put(Long.TYPE, Long.class);
        UNBOXED_TO_BOXED.put(Double.TYPE, Double.class);
        UNBOXED_TO_BOXED.put(Float.TYPE, Float.class);
        UNBOXED_TO_BOXED.put(Boolean.TYPE, Boolean.class);
        UNBOXED_TO_BOXED.put(Short.TYPE, Short.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestInstantiatorBuilder {
        private Constructor<?> constructor;
        private Object[] constructorArgs;
        private String description;

        TestInstantiatorBuilder(Object ... constructorArgs) {
            if (constructorArgs == null) {
                throw new IllegalArgumentException("constructor argument list null");
            }
            this.constructor = this.findBestConstructorMatch(constructorArgs);
            this.constructorArgs = Arrays.copyOf(constructorArgs, constructorArgs.length);
        }

        public Constructor<?> getConstructor() {
            return this.constructor;
        }

        public Object[] getConstructorArgs() {
            return this.constructorArgs;
        }

        public String getDescription() {
            if (this.description == null) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Object parameter : this.constructorArgs) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    if (parameter instanceof String) {
                        parameter = '\"' + (String)parameter + '\"';
                    }
                    sb.append(parameter);
                }
                this.description = sb.toString();
            }
            return this.description;
        }

        private Constructor<?> findBestConstructorMatch(Object ... constructorArgs) {
            Constructor c;
            Constructor<?>[] constructors = ParameterizedSuiteBuilder.this.testClass.getConstructors();
            if (constructors.length > 1) {
                ArrayList cs = new ArrayList(Arrays.asList(constructors));
                Iterator ics = cs.iterator();
                block0: while (ics.hasNext()) {
                    Class<?>[] parameterTypes = ((Constructor)ics.next()).getParameterTypes();
                    if (parameterTypes.length != constructorArgs.length) {
                        ics.remove();
                        continue;
                    }
                    for (int i = 0; i < constructorArgs.length; ++i) {
                        Class<?> boxedType = this.boxedTypeFor(parameterTypes[i]);
                        if (boxedType.isInstance(constructorArgs[i])) continue;
                        ics.remove();
                        continue block0;
                    }
                }
                if (cs.isEmpty()) {
                    throw new IllegalArgumentException("No constructor(s) found matching given argument types");
                }
                if (cs.size() > 1) {
                    this.filterRedundantConstructors(cs);
                    if (cs.size() > 1) {
                        throw new IllegalStateException(this.buildAmbiguousConstructorsExceptionString(cs));
                    }
                }
                c = (Constructor)cs.get(0);
            } else {
                c = constructors[0];
            }
            this.validateConstructorArguments(c, constructorArgs);
            return c;
        }

        private void filterRedundantConstructors(List<Constructor<?>> cs) {
            for (int i1 = 0; i1 < cs.size() - 1; ++i1) {
                for (int i2 = i1 + 1; i2 < cs.size(); ++i2) {
                    Constructor<?> c2;
                    Constructor<?> c1 = cs.get(i1);
                    if (this.isFirstStrictlyLessSpecificThanSecond(c1, c2 = cs.get(i2))) {
                        cs.remove(i1);
                        i2 = i1;
                        continue;
                    }
                    if (!this.isFirstStrictlyLessSpecificThanSecond(c2, c1)) continue;
                    cs.remove(i2);
                    --i2;
                }
            }
        }

        private boolean isFirstStrictlyLessSpecificThanSecond(Constructor<?> c1, Constructor<?> c2) {
            Class<?>[] ps1 = c1.getParameterTypes();
            Class<?>[] ps2 = c2.getParameterTypes();
            assert (ps1.length == ps2.length);
            for (int i = 0; i < ps1.length; ++i) {
                if (ps1[i].isAssignableFrom(ps2[i])) continue;
                return false;
            }
            return true;
        }

        private String buildAmbiguousConstructorsExceptionString(List<Constructor<?>> cs) {
            StringBuilder sb = new StringBuilder();
            sb.append("Found ").append(cs.size()).append(" ambiguous constructors matching given arguments:");
            for (Constructor<?> c2 : cs) {
                String sep = "\n\t- (";
                for (Class<?> pt : c2.getParameterTypes()) {
                    String name = pt.getName();
                    sb.append(sep).append(name.startsWith("java.lang.") ? name.substring(10) : name);
                    sep = ", ";
                }
                sb.append(')');
            }
            return sb.toString();
        }

        public TestInstantiatorBuilder named(String description) {
            if (description == null) {
                description = "(null)";
            }
            this.description = description;
            return this;
        }

        private void validateConstructorArguments(Constructor<?> c, Object[] args) {
            Class<?>[] parameterTypes = c.getParameterTypes();
            if (parameterTypes.length != args.length) {
                throw new IllegalArgumentException("Constructor argument count mismatch: expected " + parameterTypes.length + ", got " + args.length);
            }
            for (int i = 0; i < args.length; ++i) {
                Class<?> boxedType = this.boxedTypeFor(parameterTypes[i]);
                if (args[i] == null) {
                    if (!parameterTypes[i].isPrimitive()) continue;
                    throw new IllegalArgumentException("Constructor argument " + i + " expects primitive type " + parameterTypes[i].getName() + " but null value was given for constructor " + c + " with proposed arguments " + Arrays.toString(args));
                }
                if (boxedType.isInstance(args[i]) || parameterTypes[i].isPrimitive() && this.canBeCastToPrimitiveType(args[i], parameterTypes[i])) continue;
                throw new IllegalArgumentException("Constructor argument " + i + " expected type " + boxedType.getName() + " but got " + args[i].getClass().getName() + " for constructor " + c + " with proposed arguments " + Arrays.toString(args));
            }
        }

        private boolean canBeCastToPrimitiveType(Object arg, Class<?> primitiveType) {
            int v;
            if (primitiveType == Boolean.TYPE) {
                return false;
            }
            boolean isChar = arg instanceof Character;
            boolean isDouble = arg instanceof Double;
            boolean isFloat = arg instanceof Float;
            boolean isLong = arg instanceof Long;
            boolean isInteger = arg instanceof Integer;
            boolean isShort = arg instanceof Short;
            boolean isByte = arg instanceof Byte;
            if (!(isDouble || isFloat || isLong || isInteger || isShort || isChar || isByte)) {
                return false;
            }
            if (primitiveType == Double.TYPE) {
                return true;
            }
            if (isDouble) {
                return false;
            }
            if (primitiveType == Float.TYPE) {
                return true;
            }
            if (isFloat) {
                return false;
            }
            if (primitiveType == Long.TYPE) {
                return true;
            }
            if (isLong) {
                return false;
            }
            if (primitiveType == Integer.TYPE) {
                return true;
            }
            int n = v = isChar ? ((Character)arg).charValue() : ((Number)arg).intValue();
            if (primitiveType == Character.TYPE) {
                return v >= 0 && v <= 65535;
            }
            if (primitiveType == Short.TYPE) {
                return v >= Short.MIN_VALUE && v <= Short.MAX_VALUE;
            }
            if (primitiveType == Byte.TYPE) {
                return v >= -128 && v <= 127;
            }
            return false;
        }

        private Class<?> boxedTypeFor(Class<?> potentiallyUnboxed) {
            Class<?> boxed = UNBOXED_TO_BOXED.get(potentiallyUnboxed);
            return boxed != null ? boxed : potentiallyUnboxed;
        }
    }
}

