/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.offbytwo.jenkins.model.BaseModel;
import com.offbytwo.jenkins.model.JobWithDetails;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Job
extends BaseModel {
    private String name;
    private String url;

    public Job() {
    }

    public Job(String name, String url) {
        this();
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public JobWithDetails details() throws IOException {
        return this.client.get(this.url, JobWithDetails.class);
    }

    public void build() throws IOException {
        this.client.post(this.url + "build");
    }

    public void build(Map<String, String> params) throws IOException {
        String qs = StringUtils.join((Collection)Collections2.transform(params.entrySet(), (Function)new MapEntryToQueryStringPair()), (String)"&");
        this.client.post(this.url + "buildWithParameters?" + qs, null, null);
    }

    private static class MapEntryToQueryStringPair
    implements Function<Map.Entry<String, String>, String> {
        private MapEntryToQueryStringPair() {
        }

        public String apply(Map.Entry<String, String> entry) {
            return URLEncoder.encode(entry.getKey()) + "=" + URLEncoder.encode(entry.getValue());
        }
    }
}

