/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import com.microsoft.signalr.InvocationHandler;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

class CallbackMap {
    private final Map<String, List<InvocationHandler>> handlers = new HashMap<String, List<InvocationHandler>>();
    private final ReentrantLock lock = new ReentrantLock();

    CallbackMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationHandler put(String target, Object action, Type ... types) {
        try {
            this.lock.lock();
            InvocationHandler handler = new InvocationHandler(action, types);
            if (!this.handlers.containsKey(target)) {
                this.handlers.put(target, new ArrayList());
            }
            List<InvocationHandler> methodHandlers = this.handlers.get(target);
            if (handler.getHasResult()) {
                for (InvocationHandler existingHandler : methodHandlers) {
                    if (!existingHandler.getHasResult()) continue;
                    throw new RuntimeException(String.format("'%s' already has a value returning handler. Multiple return values are not supported.", target));
                }
            }
            methodHandlers = new ArrayList<InvocationHandler>(methodHandlers);
            methodHandlers.add(handler);
            this.handlers.remove(target);
            this.handlers.put(target, methodHandlers);
            InvocationHandler invocationHandler = handler;
            return invocationHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<InvocationHandler> get(String key) {
        try {
            this.lock.lock();
            List<InvocationHandler> list = this.handlers.get(key);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(String key) {
        try {
            this.lock.lock();
            this.handlers.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key, InvocationHandler handler) {
        try {
            this.lock.lock();
            List<InvocationHandler> handlers = this.handlers.get(key);
            if (handlers != null) {
                handlers = new ArrayList<InvocationHandler>(handlers);
                handlers.remove(handler);
                this.handlers.remove(key);
                this.handlers.put(key, handlers);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

