/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import com.microsoft.signalr.HubMessage;
import com.microsoft.signalr.HubMessageType;
import java.util.Map;

public final class CompletionMessage
extends HubMessage {
    private final int type;
    private Map<String, String> headers;
    private final String invocationId;
    private final Object result;
    private final String error;

    public CompletionMessage(Map<String, String> headers, String invocationId, Object result, String error) {
        this.type = HubMessageType.COMPLETION.value;
        if (headers != null && !headers.isEmpty()) {
            this.headers = headers;
        }
        if (error != null && result != null) {
            throw new IllegalArgumentException("Expected either 'error' or 'result' to be provided, but not both.");
        }
        this.invocationId = invocationId;
        this.result = result;
        this.error = error;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Object getResult() {
        return this.result;
    }

    public String getError() {
        return this.error;
    }

    public String getInvocationId() {
        return this.invocationId;
    }

    @Override
    public HubMessageType getMessageType() {
        return HubMessageType.values()[this.type - 1];
    }
}

