/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import com.microsoft.signalr.Action1;
import com.microsoft.signalr.HttpClient;
import com.microsoft.signalr.HttpRequest;
import com.microsoft.signalr.HttpResponse;
import com.microsoft.signalr.OkHttpWebSocketWrapper;
import com.microsoft.signalr.WebSocketWrapper;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.subjects.SingleSubject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ByteString;

final class DefaultHttpClient
extends HttpClient {
    private OkHttpClient client = null;

    public DefaultHttpClient(Action1<OkHttpClient.Builder> configureBuilder) {
        this(null, configureBuilder);
    }

    @Override
    public DefaultHttpClient cloneWithTimeOut(int timeoutInMilliseconds) {
        OkHttpClient newClient = this.client.newBuilder().readTimeout(timeoutInMilliseconds, TimeUnit.MILLISECONDS).build();
        return new DefaultHttpClient(newClient, null);
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.dispatcher().executorService().shutdown();
        }
    }

    public DefaultHttpClient(OkHttpClient client, Action1<OkHttpClient.Builder> configureBuilder) {
        if (client != null) {
            this.client = client;
        } else {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().cookieJar(new CookieJar(){
                private List<Cookie> cookieList = new ArrayList<Cookie>();
                private Lock cookieLock = new ReentrantLock();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                    this.cookieLock.lock();
                    try {
                        for (Cookie cookie : cookies) {
                            boolean replacedCookie = false;
                            for (int i = 0; i < this.cookieList.size(); ++i) {
                                Cookie innerCookie = this.cookieList.get(i);
                                if (!cookie.name().equals(innerCookie.name()) || !innerCookie.matches(url)) continue;
                                this.cookieList.set(i, innerCookie);
                                replacedCookie = true;
                                break;
                            }
                            if (replacedCookie) continue;
                            this.cookieList.add(cookie);
                        }
                    }
                    finally {
                        this.cookieLock.unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<Cookie> loadForRequest(HttpUrl url) {
                    this.cookieLock.lock();
                    try {
                        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
                        ArrayList<Cookie> expiredCookies = new ArrayList<Cookie>();
                        for (Cookie cookie : this.cookieList) {
                            if (cookie.expiresAt() < System.currentTimeMillis()) {
                                expiredCookies.add(cookie);
                                continue;
                            }
                            if (!cookie.matches(url)) continue;
                            matchedCookies.add(cookie);
                        }
                        this.cookieList.removeAll(expiredCookies);
                        ArrayList<Cookie> arrayList = matchedCookies;
                        return arrayList;
                    }
                    finally {
                        this.cookieLock.unlock();
                    }
                }
            });
            if (configureBuilder != null) {
                configureBuilder.invoke(builder);
            }
            this.client = builder.build();
        }
    }

    @Override
    public Single<HttpResponse> send(HttpRequest httpRequest) {
        return this.send(httpRequest, null);
    }

    @Override
    public Single<HttpResponse> send(HttpRequest httpRequest, ByteBuffer bodyContent) {
        Request.Builder requestBuilder = new Request.Builder().url(httpRequest.getUrl());
        switch (httpRequest.getMethod()) {
            case "GET": {
                requestBuilder.get();
                break;
            }
            case "POST": {
                RequestBody body = bodyContent != null ? RequestBody.create(MediaType.parse("text/plain"), ByteString.of(bodyContent)) : RequestBody.create(null, new byte[0]);
                requestBuilder.post(body);
                break;
            }
            case "DELETE": {
                requestBuilder.delete();
            }
        }
        if (httpRequest.getHeaders() != null) {
            Set<String> keys2 = httpRequest.getHeaders().keySet();
            for (String key : keys2) {
                requestBuilder.addHeader(key, httpRequest.getHeaders().get(key));
            }
        }
        Request request = requestBuilder.build();
        final SingleSubject<HttpResponse> responseSubject = SingleSubject.create();
        this.client.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                responseSubject.onError(cause);
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                try (ResponseBody body = response.body();){
                    HttpResponse httpResponse = new HttpResponse(response.code(), response.message(), ByteBuffer.wrap(body.bytes()));
                    responseSubject.onSuccess(httpResponse);
                }
            }
        });
        return responseSubject;
    }

    @Override
    public WebSocketWrapper createWebSocket(String url, Map<String, String> headers) {
        return new OkHttpWebSocketWrapper(url, headers, this.client);
    }
}

