/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import com.microsoft.signalr.Action1;
import com.microsoft.signalr.HttpClient;
import com.microsoft.signalr.HubConnection;
import com.microsoft.signalr.HubProtocol;
import com.microsoft.signalr.JsonHubProtocol;
import com.microsoft.signalr.Transport;
import com.microsoft.signalr.TransportEnum;
import io.reactivex.rxjava3.core.Single;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;

public class HttpHubConnectionBuilder {
    private final String url;
    private Transport transport;
    private HttpClient httpClient;
    private HubProtocol protocol = new JsonHubProtocol();
    private boolean skipNegotiate;
    private Single<String> accessTokenProvider;
    private long handshakeResponseTimeout = 0L;
    private Map<String, String> headers;
    private TransportEnum transportEnum;
    private Action1<OkHttpClient.Builder> configureBuilder;

    HttpHubConnectionBuilder(String url) {
        this.url = url;
    }

    HttpHubConnectionBuilder withTransportImplementation(Transport transport) {
        this.transport = transport;
        return this;
    }

    public HttpHubConnectionBuilder withTransport(TransportEnum transportEnum) {
        this.transportEnum = transportEnum;
        return this;
    }

    HttpHubConnectionBuilder withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public HttpHubConnectionBuilder withHubProtocol(HubProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public HttpHubConnectionBuilder shouldSkipNegotiate(boolean skipNegotiate) {
        this.skipNegotiate = skipNegotiate;
        return this;
    }

    public HttpHubConnectionBuilder withAccessTokenProvider(Single<String> accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
        return this;
    }

    public HttpHubConnectionBuilder withHandshakeResponseTimeout(long timeoutInMilliseconds) {
        this.handshakeResponseTimeout = timeoutInMilliseconds;
        return this;
    }

    public HttpHubConnectionBuilder withHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HttpHubConnectionBuilder withHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public HttpHubConnectionBuilder setHttpClientBuilderCallback(Action1<OkHttpClient.Builder> configureBuilder) {
        this.configureBuilder = configureBuilder;
        return this;
    }

    public HubConnection build() {
        return new HubConnection(this.url, this.transport, this.skipNegotiate, this.httpClient, this.protocol, this.accessTokenProvider, this.handshakeResponseTimeout, this.headers, this.transportEnum, this.configureBuilder);
    }
}

