/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import com.google.gson.stream.JsonReader;
import com.microsoft.signalr.Action;
import com.microsoft.signalr.Action1;
import com.microsoft.signalr.Action2;
import com.microsoft.signalr.Action3;
import com.microsoft.signalr.Action4;
import com.microsoft.signalr.Action5;
import com.microsoft.signalr.Action6;
import com.microsoft.signalr.Action7;
import com.microsoft.signalr.Action8;
import com.microsoft.signalr.ActionBase;
import com.microsoft.signalr.CallbackMap;
import com.microsoft.signalr.CancelInvocationMessage;
import com.microsoft.signalr.CloseMessage;
import com.microsoft.signalr.CompletionMessage;
import com.microsoft.signalr.DefaultHttpClient;
import com.microsoft.signalr.Function1Single;
import com.microsoft.signalr.Function2Single;
import com.microsoft.signalr.Function3Single;
import com.microsoft.signalr.Function4Single;
import com.microsoft.signalr.Function5Single;
import com.microsoft.signalr.Function6Single;
import com.microsoft.signalr.Function7Single;
import com.microsoft.signalr.Function8Single;
import com.microsoft.signalr.FunctionBase;
import com.microsoft.signalr.FunctionSingle;
import com.microsoft.signalr.HandshakeProtocol;
import com.microsoft.signalr.HandshakeRequestMessage;
import com.microsoft.signalr.HandshakeResponseMessage;
import com.microsoft.signalr.HttpClient;
import com.microsoft.signalr.HttpRequest;
import com.microsoft.signalr.HttpRequestException;
import com.microsoft.signalr.HubConnectionState;
import com.microsoft.signalr.HubMessage;
import com.microsoft.signalr.HubMessageType;
import com.microsoft.signalr.HubProtocol;
import com.microsoft.signalr.InvocationBinder;
import com.microsoft.signalr.InvocationBindingFailureMessage;
import com.microsoft.signalr.InvocationHandler;
import com.microsoft.signalr.InvocationMessage;
import com.microsoft.signalr.InvocationRequest;
import com.microsoft.signalr.LongPollingTransport;
import com.microsoft.signalr.Negotiate;
import com.microsoft.signalr.NegotiateResponse;
import com.microsoft.signalr.OnClosedCallback;
import com.microsoft.signalr.OnReceiveCallBack;
import com.microsoft.signalr.PingMessage;
import com.microsoft.signalr.StreamInvocationMessage;
import com.microsoft.signalr.StreamItem;
import com.microsoft.signalr.Subscription;
import com.microsoft.signalr.Transport;
import com.microsoft.signalr.TransportEnum;
import com.microsoft.signalr.UserAgentHelper;
import com.microsoft.signalr.Utils;
import com.microsoft.signalr.WebSocketTransport;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import io.reactivex.rxjava3.subjects.CompletableSubject;
import io.reactivex.rxjava3.subjects.ReplaySubject;
import io.reactivex.rxjava3.subjects.SingleSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubConnection
implements AutoCloseable {
    private static final byte RECORD_SEPARATOR = 30;
    private static final List<Type> emptyArray = new ArrayList<Type>();
    private static final int MAX_NEGOTIATE_ATTEMPTS = 100;
    private final CallbackMap handlers = new CallbackMap();
    private final HubProtocol protocol;
    private final boolean skipNegotiate;
    private final Map<String, String> headers;
    private final int negotiateVersion = 1;
    private final Logger logger = LoggerFactory.getLogger(HubConnection.class);
    private final HttpClient httpClient;
    private final Transport customTransport;
    private final OnReceiveCallBack callback;
    private final Single<String> accessTokenProvider;
    private final TransportEnum transportEnum;
    private String baseUrl;
    private List<OnClosedCallback> onClosedCallbackList;
    private long keepAliveInterval = 15000L;
    private long serverTimeout = 30000L;
    private long handshakeResponseTimeout = 15000L;
    private long tickRate = 1000L;
    private final ReconnectingConnectionState state;

    public void setServerTimeout(long serverTimeoutInMilliseconds) {
        this.serverTimeout = serverTimeoutInMilliseconds;
    }

    public long getServerTimeout() {
        return this.serverTimeout;
    }

    public void setKeepAliveInterval(long keepAliveIntervalInMilliseconds) {
        this.keepAliveInterval = keepAliveIntervalInMilliseconds;
    }

    public long getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public String getConnectionId() {
        ConnectionState state = this.state.getConnectionStateUnsynchronized(true);
        if (state != null) {
            return state.connectionId;
        }
        return null;
    }

    void setTickRate(long tickRateInMilliseconds) {
        this.tickRate = tickRateInMilliseconds;
    }

    Transport getTransport() {
        return this.state.getConnectionState().transport;
    }

    HubConnection(String url, Transport transport, boolean skipNegotiate, HttpClient httpClient, HubProtocol protocol, Single<String> accessTokenProvider, long handshakeResponseTimeout, Map<String, String> headers, TransportEnum transportEnum, Action1<OkHttpClient.Builder> configureBuilder) {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("A valid url is required.");
        }
        this.state = new ReconnectingConnectionState(this.logger);
        this.baseUrl = url;
        this.protocol = protocol;
        this.accessTokenProvider = accessTokenProvider != null ? accessTokenProvider : Single.just("");
        this.httpClient = httpClient != null ? httpClient : new DefaultHttpClient(configureBuilder);
        if (transport != null) {
            this.transportEnum = TransportEnum.ALL;
            this.customTransport = transport;
        } else if (transportEnum != null) {
            this.transportEnum = transportEnum;
            this.customTransport = null;
        } else {
            this.transportEnum = TransportEnum.ALL;
            this.customTransport = null;
        }
        if (handshakeResponseTimeout > 0L) {
            this.handshakeResponseTimeout = handshakeResponseTimeout;
        }
        this.headers = headers;
        this.skipNegotiate = skipNegotiate;
        this.callback = payload -> this.ReceiveLoop(payload);
    }

    private Single<NegotiateResponse> handleNegotiate(String url, Map<String, String> localHeaders) {
        HttpRequest request = new HttpRequest();
        request.addHeaders(localHeaders);
        return this.httpClient.post(Negotiate.resolveNegotiateUrl(url, this.negotiateVersion), request).map(response -> {
            if (response.getStatusCode() != 200) {
                throw new HttpRequestException(String.format("Unexpected status code returned from negotiate: %d %s.", response.getStatusCode(), response.getStatusText()), response.getStatusCode());
            }
            JsonReader reader = new JsonReader(new StringReader(new String(response.getContent().array(), StandardCharsets.UTF_8)));
            NegotiateResponse negotiateResponse = new NegotiateResponse(reader);
            if (negotiateResponse.getError() != null) {
                throw new RuntimeException(negotiateResponse.getError());
            }
            if (negotiateResponse.getAccessToken() != null) {
                localHeaders.put("Authorization", "Bearer " + negotiateResponse.getAccessToken());
            }
            return negotiateResponse;
        });
    }

    public HubConnectionState getConnectionState() {
        return this.state.getHubConnectionState();
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String url) {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("The HubConnection url must be a valid url.");
        }
        if (this.state.getHubConnectionState() != HubConnectionState.DISCONNECTED) {
            throw new IllegalStateException("The HubConnection must be in the disconnected state to change the url.");
        }
        this.baseUrl = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Completable start() {
        CompletableSubject localStart = CompletableSubject.create();
        this.state.lock.lock();
        try {
            if (this.state.getHubConnectionState() != HubConnectionState.DISCONNECTED) {
                this.logger.debug("The connection is in the '{}' state. Waiting for in-progress start to complete or completing this start immediately.", (Object)this.state.getHubConnectionState());
                Completable completable = this.state.getConnectionStateUnsynchronized((Boolean)Boolean.valueOf((boolean)false)).startTask;
                return completable;
            }
            this.state.changeState(HubConnectionState.DISCONNECTED, HubConnectionState.CONNECTING);
            CompletableSubject tokenCompletable = CompletableSubject.create();
            HashMap<String, String> localHeaders = new HashMap<String, String>();
            localHeaders.put(UserAgentHelper.getUserAgentName(), UserAgentHelper.createUserAgentString());
            if (this.headers != null) {
                localHeaders.putAll(this.headers);
            }
            ConnectionState connectionState = new ConnectionState(this);
            this.state.setConnectionState(connectionState);
            connectionState.startTask = localStart;
            this.accessTokenProvider.subscribe(token -> {
                if (token != null && !token.isEmpty()) {
                    localHeaders.put("Authorization", "Bearer " + token);
                }
                tokenCompletable.onComplete();
            }, error -> tokenCompletable.onError((Throwable)error));
            Single<NegotiateResponse> negotiate = null;
            negotiate = !this.skipNegotiate ? tokenCompletable.andThen(Single.defer(() -> this.startNegotiate(this.baseUrl, 0, localHeaders))) : tokenCompletable.andThen(Single.defer(() -> Single.just(new NegotiateResponse(this.baseUrl))));
            negotiate.flatMapCompletable(negotiateResponse -> {
                this.logger.debug("Starting HubConnection.");
                Transport transport = this.customTransport;
                if (transport == null) {
                    TransportEnum chosenTransport;
                    Single<String> tokenProvider;
                    Single<String> single = tokenProvider = negotiateResponse.getAccessToken() != null ? Single.just(negotiateResponse.getAccessToken()) : this.accessTokenProvider;
                    if (this.skipNegotiate) {
                        if (this.transportEnum != TransportEnum.WEBSOCKETS) {
                            throw new RuntimeException("Negotiation can only be skipped when using the WebSocket transport directly with '.withTransport(TransportEnum.WEBSOCKETS)' on the 'HubConnectionBuilder'.");
                        }
                        chosenTransport = this.transportEnum;
                    } else {
                        chosenTransport = negotiateResponse.getChosenTransport();
                    }
                    switch (chosenTransport) {
                        case LONG_POLLING: {
                            transport = new LongPollingTransport(localHeaders, this.httpClient, tokenProvider);
                            break;
                        }
                        default: {
                            transport = new WebSocketTransport(localHeaders, this.httpClient);
                        }
                    }
                }
                connectionState.transport = transport;
                transport.setOnReceive(this.callback);
                transport.setOnClose(message -> this.stopConnection(message));
                return transport.start(negotiateResponse.getFinalUrl()).andThen(Completable.defer(() -> {
                    ByteBuffer handshake2 = HandshakeProtocol.createHandshakeRequestMessage(new HandshakeRequestMessage(this.protocol.getName(), this.protocol.getVersion()));
                    this.state.lock();
                    try {
                        if (this.state.hubConnectionState != HubConnectionState.CONNECTING) {
                            Completable completable = Completable.error(new RuntimeException("Connection closed while trying to connect."));
                            return completable;
                        }
                        Completable completable = connectionState.transport.send(handshake2).andThen(Completable.defer(() -> {
                            block4: {
                                this.state.lock();
                                try {
                                    ConnectionState activeState = this.state.getConnectionStateUnsynchronized(true);
                                    if (activeState != null && activeState == connectionState) {
                                        connectionState.timeoutHandshakeResponse(this.handshakeResponseTimeout, TimeUnit.MILLISECONDS);
                                        break block4;
                                    }
                                    Completable completable = Completable.error(new RuntimeException("Connection closed while sending handshake."));
                                    return completable;
                                }
                                finally {
                                    this.state.unlock();
                                }
                            }
                            return connectionState.handshakeResponseSubject.andThen(Completable.defer(() -> {
                                this.state.lock();
                                try {
                                    ConnectionState activeState = this.state.getConnectionStateUnsynchronized(true);
                                    if (activeState == null || activeState != connectionState) {
                                        Completable completable = Completable.error(new RuntimeException("Connection closed while waiting for handshake."));
                                        return completable;
                                    }
                                    this.state.changeState(HubConnectionState.CONNECTING, HubConnectionState.CONNECTED);
                                    this.logger.info("HubConnection started.");
                                    connectionState.resetServerTimeout();
                                    if (negotiateResponse.getChosenTransport() != TransportEnum.LONG_POLLING) {
                                        connectionState.activatePingTimer();
                                    }
                                }
                                finally {
                                    this.state.unlock();
                                }
                                return Completable.complete();
                            }));
                        }));
                        return completable;
                    }
                    finally {
                        this.state.unlock();
                    }
                }));
            }).subscribe(() -> localStart.onComplete(), error -> {
                this.state.lock();
                try {
                    ConnectionState activeState = this.state.getConnectionStateUnsynchronized(true);
                    if (activeState == connectionState) {
                        this.state.changeState(HubConnectionState.CONNECTING, HubConnectionState.DISCONNECTED);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.state.unlock();
                }
                localStart.onError((Throwable)error);
            });
        }
        finally {
            this.state.lock.unlock();
        }
        return localStart;
    }

    private Single<NegotiateResponse> startNegotiate(String url, int negotiateAttempts, Map<String, String> localHeaders) {
        if (this.state.getHubConnectionState() != HubConnectionState.CONNECTING) {
            throw new RuntimeException("HubConnection trying to negotiate when not in the CONNECTING state.");
        }
        return this.handleNegotiate(url, localHeaders).flatMap(response -> {
            if (response.getRedirectUrl() != null && negotiateAttempts >= 100) {
                throw new RuntimeException("Negotiate redirection limit exceeded.");
            }
            if (response.getRedirectUrl() != null) return this.startNegotiate(response.getRedirectUrl(), negotiateAttempts + 1, localHeaders);
            Set<String> transports = response.getAvailableTransports();
            if (this.transportEnum == TransportEnum.ALL) {
                if (transports.contains("WebSockets")) {
                    response.setChosenTransport(TransportEnum.WEBSOCKETS);
                } else {
                    if (!transports.contains("LongPolling")) throw new RuntimeException("There were no compatible transports on the server.");
                    response.setChosenTransport(TransportEnum.LONG_POLLING);
                }
            } else {
                if (this.transportEnum == TransportEnum.WEBSOCKETS && !transports.contains("WebSockets") || this.transportEnum == TransportEnum.LONG_POLLING && !transports.contains("LongPolling")) {
                    throw new RuntimeException("There were no compatible transports on the server.");
                }
                response.setChosenTransport(this.transportEnum);
            }
            String connectionToken = "";
            if (response.getVersion() > 0) {
                this.state.getConnectionState().connectionId = response.getConnectionId();
                connectionToken = response.getConnectionToken();
            } else {
                this.state.getConnectionState().connectionId = connectionToken = response.getConnectionId();
            }
            String finalUrl = Utils.appendQueryString(url, "id=" + connectionToken);
            response.setFinalUrl(finalUrl);
            return Single.just(response);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Completable stop(String errorMessage) {
        Completable startTask;
        ConnectionState connectionState;
        this.state.lock();
        try {
            if (this.state.getHubConnectionState() == HubConnectionState.DISCONNECTED) {
                Completable completable = Completable.complete();
                return completable;
            }
            connectionState = this.state.getConnectionStateUnsynchronized(false);
            if (errorMessage != null) {
                connectionState.stopError = errorMessage;
                this.logger.error("HubConnection disconnected with an error: {}.", (Object)errorMessage);
            } else {
                this.logger.debug("Stopping HubConnection.");
            }
            startTask = connectionState.startTask;
        }
        finally {
            this.state.unlock();
        }
        Completable stopTask = startTask.onErrorComplete().andThen(Completable.defer(() -> {
            Completable stop = connectionState.transport.stop();
            stop.onErrorComplete().subscribe();
            return stop;
        }));
        stopTask.onErrorComplete().subscribe();
        return stopTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ReceiveLoop(ByteBuffer payload) {
        List<HubMessage> messages;
        ConnectionState connectionState;
        this.state.lock();
        try {
            connectionState = this.state.getConnectionState();
            connectionState.resetServerTimeout();
            connectionState.handleHandshake(payload);
            if (!payload.hasRemaining()) {
                return;
            }
            messages = this.protocol.parseMessages(payload, connectionState);
        }
        finally {
            this.state.unlock();
        }
        for (HubMessage message : messages) {
            this.logger.debug("Received message of type {}.", (Object)message.getMessageType());
            switch (message.getMessageType()) {
                case INVOCATION_BINDING_FAILURE: {
                    InvocationBindingFailureMessage msg = (InvocationBindingFailureMessage)message;
                    this.logger.error("Failed to bind arguments received in invocation '{}' of '{}'.", msg.getInvocationId(), msg.getTarget(), msg.getException());
                    if (msg.getInvocationId() == null) break;
                    this.sendHubMessageWithLock(new CompletionMessage(null, msg.getInvocationId(), null, "Client failed to parse argument(s)."));
                    break;
                }
                case INVOCATION: {
                    InvocationMessage invocationMessage = (InvocationMessage)message;
                    connectionState.dispatchInvocation(invocationMessage);
                    break;
                }
                case CLOSE: {
                    this.logger.info("Close message received from server.");
                    CloseMessage closeMessage = (CloseMessage)message;
                    this.stop(closeMessage.getError());
                    break;
                }
                case PING: {
                    break;
                }
                case COMPLETION: {
                    CompletionMessage completionMessage = (CompletionMessage)message;
                    InvocationRequest irq = connectionState.tryRemoveInvocation(completionMessage.getInvocationId());
                    if (irq == null) {
                        this.logger.warn("Dropped unsolicited Completion message for invocation '{}'.", (Object)completionMessage.getInvocationId());
                        break;
                    }
                    irq.complete(completionMessage);
                    break;
                }
                case STREAM_ITEM: {
                    StreamItem streamItem = (StreamItem)message;
                    InvocationRequest streamInvocationRequest = connectionState.getInvocation(streamItem.getInvocationId());
                    if (streamInvocationRequest == null) {
                        this.logger.warn("Dropped unsolicited Completion message for invocation '{}'.", (Object)streamItem.getInvocationId());
                        break;
                    }
                    streamInvocationRequest.addItem(streamItem);
                    break;
                }
                case STREAM_INVOCATION: 
                case CANCEL_INVOCATION: {
                    this.logger.error("This client does not support {} messages.", (Object)message.getMessageType());
                    throw new UnsupportedOperationException(String.format("The message type %s is not supported yet.", new Object[]{message.getMessageType()}));
                }
            }
        }
    }

    public Completable stop() {
        return this.stop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConnection(String errorMessage) {
        RuntimeException exception = null;
        this.state.lock();
        try {
            ConnectionState connectionState = this.state.getConnectionStateUnsynchronized(true);
            if (connectionState == null) {
                this.logger.error("'stopConnection' called with a null ConnectionState. This is not expected, please file a bug. https://github.com/dotnet/aspnetcore/issues/new?assignees=&labels=&template=bug_report.md");
                return;
            }
            if (connectionState.stopError != null) {
                errorMessage = connectionState.stopError;
            }
            if (errorMessage != null) {
                exception = new RuntimeException(errorMessage);
                this.logger.error("HubConnection disconnected with an error {}.", (Object)errorMessage);
            }
            this.state.setConnectionState(null);
            connectionState.cancelOutstandingInvocations(exception);
            connectionState.close();
            this.logger.info("HubConnection stopped.");
            this.state.changeState(HubConnectionState.DISCONNECTED);
        }
        finally {
            this.state.unlock();
        }
        if (this.onClosedCallbackList != null) {
            for (OnClosedCallback callback : this.onClosedCallbackList) {
                try {
                    callback.invoke(exception);
                }
                catch (Exception ex) {
                    this.logger.warn("Invoking 'onClosed' method failed:", ex);
                }
            }
        }
    }

    public void send(String method, Object ... args2) {
        this.state.lock();
        try {
            if (this.state.getHubConnectionState() != HubConnectionState.CONNECTED) {
                throw new RuntimeException("The 'send' method cannot be called if the connection is not active.");
            }
            this.sendInvocationMessage(method, args2);
        }
        finally {
            this.state.unlock();
        }
    }

    private void sendInvocationMessage(String method, Object[] args2) {
        this.sendInvocationMessage(method, args2, null, false);
    }

    private void sendInvocationMessage(String method, Object[] args2, String id, Boolean isStreamInvocation) {
        ArrayList<String> streamIds = new ArrayList<String>();
        ArrayList<Observable> streams = new ArrayList<Observable>();
        args2 = this.checkUploadStream(args2, streamIds, streams);
        InvocationMessage invocationMessage = isStreamInvocation != false ? new StreamInvocationMessage(null, id, method, args2, streamIds) : new InvocationMessage(null, id, method, args2, streamIds);
        this.sendHubMessageWithLock(invocationMessage);
        this.launchStreams(streamIds, streams);
    }

    void launchStreams(List<String> streamIds, List<Observable> streams) {
        if (streams.isEmpty()) {
            return;
        }
        for (int i = 0; i < streamIds.size(); ++i) {
            String streamId = streamIds.get(i);
            Observable stream = streams.get(i);
            stream.subscribe(item -> this.sendHubMessageWithLock(new StreamItem(null, streamId, item)), error -> this.sendHubMessageWithLock(new CompletionMessage(null, streamId, null, error.toString())), () -> this.sendHubMessageWithLock(new CompletionMessage(null, streamId, null, null)));
        }
    }

    Object[] checkUploadStream(Object[] args2, List<String> streamIds, List<Observable> streams) {
        if (args2 == null) {
            return new Object[]{null};
        }
        ConnectionState connectionState = this.state.getConnectionState();
        ArrayList<Object> params = new ArrayList<Object>(Arrays.asList(args2));
        for (Object arg : args2) {
            if (!(arg instanceof Observable)) continue;
            params.remove(arg);
            Observable stream = (Observable)arg;
            String streamId = connectionState.getNextInvocationId();
            streamIds.add(streamId);
            streams.add(stream);
        }
        return params.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Completable invoke(String method, Object ... args2) {
        this.state.lock();
        try {
            if (this.state.getHubConnectionState() != HubConnectionState.CONNECTED) {
                throw new RuntimeException("The 'invoke' method cannot be called if the connection is not active.");
            }
            ConnectionState connectionState = this.state.getConnectionStateUnsynchronized(false);
            String id = connectionState.getNextInvocationId();
            CompletableSubject subject = CompletableSubject.create();
            InvocationRequest irq = new InvocationRequest(null, id);
            connectionState.addInvocation(irq);
            Subject<Object> pendingCall = irq.getPendingCall();
            pendingCall.subscribe(result -> subject.onComplete(), error -> subject.onError((Throwable)error), () -> subject.onComplete());
            this.sendInvocationMessage(method, args2, id, false);
            CompletableSubject completableSubject = subject;
            return completableSubject;
        }
        finally {
            this.state.unlock();
        }
    }

    public <T> Single<T> invoke(Class<T> returnType, String method, Object ... args2) {
        return this.invoke(returnType, returnType, method, args2);
    }

    public <T> Single<T> invoke(Type returnType, String method, Object ... args2) {
        Class<?> returnClass = Utils.typeToClass(returnType);
        return this.invoke(returnType, returnClass, method, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Single<T> invoke(Type returnType, Class<?> returnClass, String method, Object ... args2) {
        this.state.lock();
        try {
            if (this.state.getHubConnectionState() != HubConnectionState.CONNECTED) {
                throw new RuntimeException("The 'invoke' method cannot be called if the connection is not active.");
            }
            ConnectionState connectionState = this.state.getConnectionStateUnsynchronized(false);
            String id = connectionState.getNextInvocationId();
            InvocationRequest irq = new InvocationRequest(returnType, id);
            connectionState.addInvocation(irq);
            SingleSubject subject = SingleSubject.create();
            Subject<Object> pendingCall = irq.getPendingCall();
            pendingCall.subscribe(result -> subject.onSuccess(Utils.cast(returnClass, result)), error -> subject.onError((Throwable)error));
            this.sendInvocationMessage(method, args2, id, false);
            SingleSubject singleSubject = subject;
            return singleSubject;
        }
        finally {
            this.state.unlock();
        }
    }

    public <T> Observable<T> stream(Class<T> returnType, String method, Object ... args2) {
        return this.stream(returnType, returnType, method, args2);
    }

    public <T> Observable<T> stream(Type returnType, String method, Object ... args2) {
        Class<?> returnClass = Utils.typeToClass(returnType);
        return this.stream(returnType, returnClass, method, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Observable<T> stream(Type returnType, Class<?> returnClass, String method, Object ... args2) {
        this.state.lock();
        try {
            if (this.state.getHubConnectionState() != HubConnectionState.CONNECTED) {
                throw new RuntimeException("The 'stream' method cannot be called if the connection is not active.");
            }
            ConnectionState connectionState = this.state.getConnectionStateUnsynchronized(false);
            String invocationId = connectionState.getNextInvocationId();
            InvocationRequest irq = new InvocationRequest(returnType, invocationId);
            connectionState.addInvocation(irq);
            AtomicInteger subscriptionCount = new AtomicInteger();
            ReplaySubject subject = ReplaySubject.create();
            Subject<Object> pendingCall = irq.getPendingCall();
            pendingCall.subscribe(result -> subject.onNext(Utils.cast(returnClass, result)), error -> subject.onError((Throwable)error), () -> subject.onComplete());
            Observable observable2 = subject.doOnSubscribe(subscriber -> subscriptionCount.incrementAndGet());
            this.sendInvocationMessage(method, args2, invocationId, true);
            Observable observable3 = observable2.doOnDispose(() -> {
                if (subscriptionCount.decrementAndGet() == 0) {
                    CancelInvocationMessage cancelInvocationMessage = new CancelInvocationMessage(null, invocationId);
                    this.sendHubMessageWithLock(cancelInvocationMessage);
                    connectionState.tryRemoveInvocation(invocationId);
                    subject.onComplete();
                }
            });
            return observable3;
        }
        finally {
            this.state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHubMessageWithLock(HubMessage message) {
        this.state.lock();
        try {
            if (this.state.getHubConnectionState() != HubConnectionState.CONNECTED) {
                throw new RuntimeException("Trying to send and message while the connection is not active.");
            }
            ByteBuffer serializedMessage = this.protocol.writeMessage(message);
            if (message.getMessageType() == HubMessageType.INVOCATION) {
                this.logger.debug("Sending {} message '{}'.", (Object)message.getMessageType().name(), (Object)((InvocationMessage)message).getInvocationId());
            } else if (message.getMessageType() == HubMessageType.STREAM_INVOCATION) {
                this.logger.debug("Sending {} message '{}'.", (Object)message.getMessageType().name(), (Object)((StreamInvocationMessage)message).getInvocationId());
            } else {
                this.logger.debug("Sending {} message.", (Object)message.getMessageType().name());
            }
            ConnectionState connectionState = this.state.getConnectionStateUnsynchronized(false);
            connectionState.transport.send(serializedMessage).subscribeWith(CompletableSubject.create());
            connectionState.resetKeepAlive();
        }
        finally {
            this.state.unlock();
        }
    }

    public void remove(String name) {
        this.handlers.remove(name);
        this.logger.trace("Removing handlers for client method: {}.", (Object)name);
    }

    public void onClosed(OnClosedCallback callback) {
        if (this.onClosedCallbackList == null) {
            this.onClosedCallbackList = new ArrayList<OnClosedCallback>();
        }
        this.onClosedCallbackList.add(callback);
    }

    public Subscription on(String target, Action callback) {
        ActionBase action = args2 -> {
            callback.invoke();
            return Completable.complete();
        };
        return this.registerHandler(target, action, new Type[0]);
    }

    public <T1> Subscription on(String target, Action1<T1> callback, Class<T1> param1) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1);
    }

    public <T1, T2> Subscription on(String target, Action2<T1, T2> callback, Class<T1> param1, Class<T2> param2) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2);
    }

    public <T1, T2, T3> Subscription on(String target, Action3<T1, T2, T3> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3);
    }

    public <T1, T2, T3, T4> Subscription on(String target, Action4<T1, T2, T3, T4> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3, Class<T4> param4) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3, param4);
    }

    public <T1, T2, T3, T4, T5> Subscription on(String target, Action5<T1, T2, T3, T4, T5> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3, Class<T4> param4, Class<T5> param5) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3, param4, param5);
    }

    public <T1, T2, T3, T4, T5, T6> Subscription on(String target, Action6<T1, T2, T3, T4, T5, T6> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3, Class<T4> param4, Class<T5> param5, Class<T6> param6) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4]), Utils.cast(param6, params[5]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3, param4, param5, param6);
    }

    public <T1, T2, T3, T4, T5, T6, T7> Subscription on(String target, Action7<T1, T2, T3, T4, T5, T6, T7> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3, Class<T4> param4, Class<T5> param5, Class<T6> param6, Class<T7> param7) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4]), Utils.cast(param6, params[5]), Utils.cast(param7, params[6]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3, param4, param5, param6, param7);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> Subscription on(String target, Action8<T1, T2, T3, T4, T5, T6, T7, T8> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3, Class<T4> param4, Class<T5> param5, Class<T6> param6, Class<T7> param7, Class<T8> param8) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4]), Utils.cast(param6, params[5]), Utils.cast(param7, params[6]), Utils.cast(param8, params[7]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3, param4, param5, param6, param7, param8);
    }

    public <T1> Subscription on(String target, Action1<T1> callback, Type param1) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1);
    }

    public <T1, T2> Subscription on(String target, Action2<T1, T2> callback, Type param1, Type param2) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2);
    }

    public <T1, T2, T3> Subscription on(String target, Action3<T1, T2, T3> callback, Type param1, Type param2, Type param3) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3);
    }

    public <T1, T2, T3, T4> Subscription on(String target, Action4<T1, T2, T3, T4> callback, Type param1, Type param2, Type param3, Type param4) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3, param4);
    }

    public <T1, T2, T3, T4, T5> Subscription on(String target, Action5<T1, T2, T3, T4, T5> callback, Type param1, Type param2, Type param3, Type param4, Type param5) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3, param4, param5);
    }

    public <T1, T2, T3, T4, T5, T6> Subscription on(String target, Action6<T1, T2, T3, T4, T5, T6> callback, Type param1, Type param2, Type param3, Type param4, Type param5, Type param6) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4]), Utils.cast(param6, params[5]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3, param4, param5, param6);
    }

    public <T1, T2, T3, T4, T5, T6, T7> Subscription on(String target, Action7<T1, T2, T3, T4, T5, T6, T7> callback, Type param1, Type param2, Type param3, Type param4, Type param5, Type param6, Type param7) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4]), Utils.cast(param6, params[5]), Utils.cast(param7, params[6]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3, param4, param5, param6, param7);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> Subscription on(String target, Action8<T1, T2, T3, T4, T5, T6, T7, T8> callback, Type param1, Type param2, Type param3, Type param4, Type param5, Type param6, Type param7, Type param8) {
        ActionBase action = params -> {
            callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4]), Utils.cast(param6, params[5]), Utils.cast(param7, params[6]), Utils.cast(param8, params[7]));
            return Completable.complete();
        };
        return this.registerHandler(target, action, param1, param2, param3, param4, param5, param6, param7, param8);
    }

    public <TResult> Subscription onWithResult(String target, FunctionSingle<TResult> callback) {
        FunctionBase action = args2 -> callback.invoke().cast(Object.class);
        return this.registerHandler(target, action, new Type[0]);
    }

    public <T1, TResult> Subscription onWithResult(String target, Function1Single<T1, TResult> callback, Class<T1> param1) {
        FunctionBase action = params -> callback.invoke(Utils.cast(param1, params[0])).cast(Object.class);
        return this.registerHandler(target, action, param1);
    }

    public <T1, T2, TResult> Subscription onWithResult(String target, Function2Single<T1, T2, TResult> callback, Class<T1> param1, Class<T2> param2) {
        FunctionBase action = params -> callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1])).cast(Object.class);
        return this.registerHandler(target, action, param1, param2);
    }

    public <T1, T2, T3, TResult> Subscription onWithResult(String target, Function3Single<T1, T2, T3, TResult> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3) {
        FunctionBase action = params -> callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2])).cast(Object.class);
        return this.registerHandler(target, action, param1, param2, param3);
    }

    public <T1, T2, T3, T4, TResult> Subscription onWithResult(String target, Function4Single<T1, T2, T3, T4, TResult> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3, Class<T4> param4) {
        FunctionBase action = params -> callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3])).cast(Object.class);
        return this.registerHandler(target, action, param1, param2, param3, param4);
    }

    public <T1, T2, T3, T4, T5, TResult> Subscription onWithResult(String target, Function5Single<T1, T2, T3, T4, T5, TResult> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3, Class<T4> param4, Class<T5> param5) {
        FunctionBase action = params -> callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4])).cast(Object.class);
        return this.registerHandler(target, action, param1, param2, param3, param4, param5);
    }

    public <T1, T2, T3, T4, T5, T6, TResult> Subscription onWithResult(String target, Function6Single<T1, T2, T3, T4, T5, T6, TResult> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3, Class<T4> param4, Class<T5> param5, Class<T6> param6) {
        FunctionBase action = params -> callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4]), Utils.cast(param6, params[5])).cast(Object.class);
        return this.registerHandler(target, action, param1, param2, param3, param4, param5, param6);
    }

    public <T1, T2, T3, T4, T5, T6, T7, TResult> Subscription onWithResult(String target, Function7Single<T1, T2, T3, T4, T5, T6, T7, TResult> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3, Class<T4> param4, Class<T5> param5, Class<T6> param6, Class<T7> param7) {
        FunctionBase action = params -> callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4]), Utils.cast(param6, params[5]), Utils.cast(param7, params[6])).cast(Object.class);
        return this.registerHandler(target, action, param1, param2, param3, param4, param5, param6, param7);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, TResult> Subscription onWithResult(String target, Function8Single<T1, T2, T3, T4, T5, T6, T7, T8, TResult> callback, Class<T1> param1, Class<T2> param2, Class<T3> param3, Class<T4> param4, Class<T5> param5, Class<T6> param6, Class<T7> param7, Class<T8> param8) {
        FunctionBase action = params -> callback.invoke(Utils.cast(param1, params[0]), Utils.cast(param2, params[1]), Utils.cast(param3, params[2]), Utils.cast(param4, params[3]), Utils.cast(param5, params[4]), Utils.cast(param6, params[5]), Utils.cast(param7, params[6]), Utils.cast(param8, params[7])).cast(Object.class);
        return this.registerHandler(target, action, param1, param2, param3, param4, param5, param6, param7, param8);
    }

    private Subscription registerHandler(String target, Object action, Type ... types) {
        InvocationHandler handler = this.handlers.put(target, action, types);
        this.logger.debug("Registering handler for client method: '{}'.", (Object)target);
        return new Subscription(this.handlers, handler, target);
    }

    @Override
    public void close() {
        try {
            this.stop().blockingAwait();
        }
        finally {
            if (this.httpClient != null && this.httpClient instanceof DefaultHttpClient) {
                this.httpClient.close();
            }
        }
    }

    private final class ReconnectingConnectionState {
        private final Logger logger;
        private final Lock lock = new ReentrantLock();
        private ConnectionState state;
        private HubConnectionState hubConnectionState = HubConnectionState.DISCONNECTED;

        public ReconnectingConnectionState(Logger logger) {
            this.logger = logger;
        }

        public void setConnectionState(ConnectionState state) {
            this.lock.lock();
            try {
                this.state = state;
            }
            finally {
                this.lock.unlock();
            }
        }

        public ConnectionState getConnectionStateUnsynchronized(Boolean allowNull) {
            if (!allowNull.booleanValue() && this.state == null) {
                throw new RuntimeException("Connection is not active.");
            }
            return this.state;
        }

        public ConnectionState getConnectionState() {
            this.lock.lock();
            try {
                if (this.state == null) {
                    throw new RuntimeException("Connection is not active.");
                }
                ConnectionState connectionState = this.state;
                return connectionState;
            }
            finally {
                this.lock.unlock();
            }
        }

        public HubConnectionState getHubConnectionState() {
            return this.hubConnectionState;
        }

        public void changeState(HubConnectionState from, HubConnectionState to) {
            this.lock.lock();
            try {
                this.logger.debug("The HubConnection is attempting to transition from the {} state to the {} state.", (Object)from, (Object)to);
                if (this.hubConnectionState != from) {
                    this.logger.debug("The HubConnection failed to transition from the {} state to the {} state because it was actually in the {} state.", new Object[]{from, to, this.hubConnectionState});
                    throw new RuntimeException(String.format("The HubConnection failed to transition from the '%s' state to the '%s' state because it was actually in the '%s' state.", new Object[]{from, to, this.hubConnectionState}));
                }
                this.hubConnectionState = to;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void changeState(HubConnectionState to) {
            this.lock.lock();
            try {
                this.logger.debug("The HubConnection is transitioning from the {} state to the {} state.", (Object)this.hubConnectionState, (Object)to);
                this.hubConnectionState = to;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }
    }

    private final class ConnectionState
    implements InvocationBinder {
        private final HubConnection connection;
        private final AtomicInteger nextId = new AtomicInteger(0);
        private final HashMap<String, InvocationRequest> pendingInvocations = new HashMap();
        private final AtomicLong nextServerTimeout = new AtomicLong();
        private final AtomicLong nextPingActivation = new AtomicLong();
        private Timer pingTimer = null;
        private Boolean handshakeReceived = false;
        private ScheduledExecutorService handshakeTimeout = null;
        private BehaviorSubject<InvocationMessage> messages = BehaviorSubject.create();
        private ExecutorService resultInvocationPool = null;
        public final Lock lock = new ReentrantLock();
        public final CompletableSubject handshakeResponseSubject = CompletableSubject.create();
        public Transport transport;
        public String connectionId;
        public String stopError;
        public Completable startTask;

        public ConnectionState(HubConnection connection) {
            this.connection = connection;
        }

        public String getNextInvocationId() {
            int i = this.nextId.incrementAndGet();
            return Integer.toString(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelOutstandingInvocations(Exception ex) {
            this.lock.lock();
            try {
                Set<String> keys2 = this.pendingInvocations.keySet();
                for (String key : keys2) {
                    if (ex == null) {
                        this.pendingInvocations.get(key).cancel();
                        continue;
                    }
                    this.pendingInvocations.get(key).fail(ex);
                }
                this.pendingInvocations.clear();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void addInvocation(InvocationRequest irq) {
            this.lock.lock();
            try {
                if (this.pendingInvocations.containsKey(irq.getInvocationId())) {
                    throw new IllegalStateException("Invocation Id is already used");
                }
                this.pendingInvocations.put(irq.getInvocationId(), irq);
            }
            finally {
                this.lock.unlock();
            }
        }

        public InvocationRequest getInvocation(String id) {
            this.lock.lock();
            try {
                InvocationRequest invocationRequest = this.pendingInvocations.get(id);
                return invocationRequest;
            }
            finally {
                this.lock.unlock();
            }
        }

        public InvocationRequest tryRemoveInvocation(String id) {
            this.lock.lock();
            try {
                InvocationRequest invocationRequest = this.pendingInvocations.remove(id);
                return invocationRequest;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void resetServerTimeout() {
            this.nextServerTimeout.set(System.currentTimeMillis() + HubConnection.this.serverTimeout);
        }

        public void resetKeepAlive() {
            this.nextPingActivation.set(System.currentTimeMillis() + HubConnection.this.keepAliveInterval);
        }

        public void activatePingTimer() {
            this.pingTimer = new Timer();
            this.pingTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (System.currentTimeMillis() > ConnectionState.this.nextServerTimeout.get()) {
                            HubConnection.this.stop("Server timeout elapsed without receiving a message from the server.");
                            return;
                        }
                        if (System.currentTimeMillis() > ConnectionState.this.nextPingActivation.get()) {
                            HubConnection.this.sendHubMessageWithLock(PingMessage.getInstance());
                        }
                    }
                    catch (Exception e) {
                        HubConnection.this.logger.warn("Error sending ping: {}.", (Object)e.getMessage());
                        ConnectionState.this.pingTimer.cancel();
                    }
                }
            }, new Date(0L), HubConnection.this.tickRate);
        }

        public void handleHandshake(ByteBuffer payload) {
            if (!this.handshakeReceived.booleanValue()) {
                HandshakeResponseMessage handshakeResponse;
                ArrayList<Byte> handshakeByteList = new ArrayList<Byte>();
                byte curr = payload.get();
                while (curr != 30) {
                    handshakeByteList.add(curr);
                    curr = payload.get();
                }
                int handshakeLength = handshakeByteList.size() + 1;
                byte[] handshakeBytes = new byte[handshakeLength - 1];
                for (int i = 0; i < handshakeLength - 1; ++i) {
                    handshakeBytes[i] = (Byte)handshakeByteList.get(i);
                }
                String handshakeResponseString = new String(handshakeBytes, StandardCharsets.UTF_8);
                try {
                    handshakeResponse = HandshakeProtocol.parseHandshakeResponse(handshakeResponseString);
                }
                catch (RuntimeException ex) {
                    RuntimeException exception = new RuntimeException("An invalid handshake response was received from the server.", ex);
                    this.errorHandshake(exception);
                    throw exception;
                }
                if (handshakeResponse.getHandshakeError() != null) {
                    String errorMessage = "Error in handshake " + handshakeResponse.getHandshakeError();
                    HubConnection.this.logger.error(errorMessage);
                    RuntimeException exception = new RuntimeException(errorMessage);
                    this.errorHandshake(exception);
                    throw exception;
                }
                this.handshakeReceived = true;
                this.handshakeResponseSubject.onComplete();
                this.startInvocationProcessing();
            }
        }

        public void timeoutHandshakeResponse(long timeout2, TimeUnit unit) {
            this.handshakeTimeout = Executors.newSingleThreadScheduledExecutor();
            this.handshakeTimeout.schedule(() -> this.errorHandshake(new TimeoutException("Timed out waiting for the server to respond to the handshake message.")), timeout2, unit);
        }

        public void close() {
            this.handshakeResponseSubject.onComplete();
            this.messages.onComplete();
            if (this.pingTimer != null) {
                this.pingTimer.cancel();
            }
            if (this.handshakeTimeout != null) {
                this.handshakeTimeout.shutdownNow();
            }
            if (this.resultInvocationPool != null) {
                this.resultInvocationPool.shutdownNow();
            }
        }

        public void dispatchInvocation(InvocationMessage message) {
            this.messages.onNext(message);
        }

        private void startInvocationProcessing() {
            this.resultInvocationPool = Executors.newCachedThreadPool();
            this.messages.observeOn(Schedulers.io()).subscribe(invocationMessage -> {
                if (invocationMessage.getInvocationId() != null) {
                    this.resultInvocationPool.submit(() -> this.handleInvocation((InvocationMessage)invocationMessage));
                } else {
                    this.handleInvocation((InvocationMessage)invocationMessage);
                }
            }, e -> HubConnection.this.stop(e.getMessage()), () -> {});
        }

        private void handleInvocation(InvocationMessage invocationMessage) {
            boolean expectsResult;
            List<InvocationHandler> handlers = this.connection.handlers.get(invocationMessage.getTarget());
            boolean bl = expectsResult = invocationMessage.getInvocationId() != null;
            if (handlers == null) {
                if (expectsResult) {
                    HubConnection.this.logger.warn("Failed to find a value returning handler for '{}' method. Sending error to server.", (Object)invocationMessage.getTarget());
                    HubConnection.this.sendHubMessageWithLock(new CompletionMessage(null, invocationMessage.getInvocationId(), null, "Client did not provide a result."));
                } else {
                    HubConnection.this.logger.warn("Failed to find handler for '{}' method.", (Object)invocationMessage.getTarget());
                }
                return;
            }
            Object result = null;
            Throwable resultException = null;
            Boolean hasResult = false;
            for (InvocationHandler handler : handlers) {
                try {
                    Object action = handler.getAction();
                    if (handler.getHasResult()) {
                        FunctionBase function = (FunctionBase)action;
                        result = function.invoke(invocationMessage.getArguments()).blockingGet();
                        hasResult = true;
                        continue;
                    }
                    ((ActionBase)action).invoke(invocationMessage.getArguments()).blockingAwait();
                }
                catch (Exception e) {
                    HubConnection.this.logger.error("Invoking client side method '{}' failed:", (Object)invocationMessage.getTarget(), (Object)e);
                    if (!handler.getHasResult()) continue;
                    resultException = e;
                }
            }
            if (expectsResult) {
                if (resultException != null) {
                    HubConnection.this.sendHubMessageWithLock(new CompletionMessage(null, invocationMessage.getInvocationId(), null, resultException.getMessage()));
                } else if (hasResult.booleanValue()) {
                    HubConnection.this.sendHubMessageWithLock(new CompletionMessage(null, invocationMessage.getInvocationId(), result, null));
                } else {
                    HubConnection.this.logger.warn("Failed to find a value returning handler for '{}' method. Sending error to server.", (Object)invocationMessage.getTarget());
                    HubConnection.this.sendHubMessageWithLock(new CompletionMessage(null, invocationMessage.getInvocationId(), null, "Client did not provide a result."));
                }
            } else if (hasResult.booleanValue()) {
                HubConnection.this.logger.warn("Result given for '{}' method but server is not expecting a result.", (Object)invocationMessage.getTarget());
            }
        }

        @Override
        public Type getReturnType(String invocationId) {
            InvocationRequest irq = this.getInvocation(invocationId);
            if (irq == null) {
                return null;
            }
            return irq.getReturnType();
        }

        @Override
        public List<Type> getParameterTypes(String methodName) {
            List<InvocationHandler> handlers = this.connection.handlers.get(methodName);
            if (handlers == null) {
                HubConnection.this.logger.warn("Failed to find handler for '{}' method.", (Object)methodName);
                return emptyArray;
            }
            if (handlers.isEmpty()) {
                throw new RuntimeException(String.format("There are no callbacks registered for the method '%s'.", methodName));
            }
            return handlers.get(0).getTypes();
        }

        private void errorHandshake(Exception error) {
            this.lock.lock();
            try {
                if (!this.handshakeResponseSubject.hasComplete() && !this.handshakeResponseSubject.hasThrowable()) {
                    this.handshakeResponseSubject.onError(error);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

