/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import com.microsoft.signalr.CompletionMessage;
import com.microsoft.signalr.HubException;
import com.microsoft.signalr.StreamItem;
import io.reactivex.rxjava3.subjects.ReplaySubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.lang.reflect.Type;
import java.util.concurrent.CancellationException;

class InvocationRequest {
    private final Type returnType;
    private final Subject<Object> pendingCall = ReplaySubject.create();
    private final String invocationId;

    InvocationRequest(Type returnType, String invocationId) {
        this.returnType = returnType;
        this.invocationId = invocationId;
    }

    public void complete(CompletionMessage completion) {
        if (completion.getError() == null) {
            if (completion.getResult() != null) {
                this.pendingCall.onNext(completion.getResult());
            }
            this.pendingCall.onComplete();
        } else {
            this.pendingCall.onError(new HubException(completion.getError()));
        }
    }

    public void addItem(StreamItem streamItem) {
        if (streamItem.getItem() != null) {
            this.pendingCall.onNext(streamItem.getItem());
        }
    }

    public void fail(Exception ex) {
        this.pendingCall.onError(ex);
    }

    public void cancel() {
        this.pendingCall.onError(new CancellationException("Invocation was canceled."));
    }

    public Subject<Object> getPendingCall() {
        return this.pendingCall;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String getInvocationId() {
        return this.invocationId;
    }
}

