/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.microsoft.signalr.CloseMessage;
import com.microsoft.signalr.CompletionMessage;
import com.microsoft.signalr.HubMessage;
import com.microsoft.signalr.HubMessageType;
import com.microsoft.signalr.HubProtocol;
import com.microsoft.signalr.InvocationBinder;
import com.microsoft.signalr.InvocationBindingFailureMessage;
import com.microsoft.signalr.InvocationMessage;
import com.microsoft.signalr.PingMessage;
import com.microsoft.signalr.StreamItem;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

class JsonHubProtocol
implements HubProtocol {
    private final JsonParser jsonParser = new JsonParser();
    private final Gson gson = new Gson();
    private static final String RECORD_SEPARATOR = "\u001e";

    JsonHubProtocol() {
    }

    @Override
    public String getName() {
        return "json";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public List<HubMessage> parseMessages(ByteBuffer payload, InvocationBinder binder) {
        String payloadStr;
        if (payload.isReadOnly()) {
            byte[] payloadBytes = new byte[payload.remaining()];
            payload.get(payloadBytes, 0, payloadBytes.length);
            payloadStr = new String(payloadBytes, StandardCharsets.UTF_8);
        } else {
            payloadStr = new String(payload.array(), payload.position(), payload.remaining(), StandardCharsets.UTF_8);
        }
        if (payloadStr.length() == 0) {
            return null;
        }
        if (!payloadStr.substring(payloadStr.length() - 1).equals(RECORD_SEPARATOR)) {
            throw new RuntimeException("Message is incomplete.");
        }
        String[] messages = payloadStr.split(RECORD_SEPARATOR);
        ArrayList<HubMessage> hubMessages = new ArrayList<HubMessage>();
        try {
            block33: for (String str : messages) {
                HubMessageType messageType = null;
                String invocationId = null;
                String target = null;
                String error = null;
                ArrayList<Object> arguments = null;
                JsonArray argumentsToken = null;
                Object result = null;
                Exception argumentBindingException = null;
                JsonElement resultToken = null;
                JsonReader reader = new JsonReader(new StringReader(str));
                reader.beginObject();
                block34: do {
                    String name;
                    switch (name = reader.nextName()) {
                        case "type": {
                            messageType = HubMessageType.values()[reader.nextInt() - 1];
                            break;
                        }
                        case "invocationId": {
                            invocationId = reader.nextString();
                            break;
                        }
                        case "target": {
                            target = reader.nextString();
                            break;
                        }
                        case "error": {
                            error = reader.nextString();
                            break;
                        }
                        case "result": 
                        case "item": {
                            if (invocationId == null || binder.getReturnType(invocationId) == null) {
                                resultToken = this.jsonParser.parse(reader);
                                break;
                            }
                            result = this.gson.fromJson(reader, binder.getReturnType(invocationId));
                            break;
                        }
                        case "arguments": {
                            if (target != null) {
                                boolean startedArray = false;
                                try {
                                    List<Type> types = binder.getParameterTypes(target);
                                    startedArray = true;
                                    arguments = this.bindArguments(reader, types);
                                }
                                catch (Exception ex) {
                                    argumentBindingException = ex;
                                    if (!startedArray) {
                                        reader.beginArray();
                                    }
                                    while (reader.hasNext()) {
                                        reader.skipValue();
                                    }
                                    if (reader.peek() != JsonToken.END_ARRAY) continue block34;
                                    reader.endArray();
                                }
                                continue block34;
                            }
                            argumentsToken = (JsonArray)this.jsonParser.parse(reader);
                            break;
                        }
                        case "headers": {
                            throw new RuntimeException("Headers not implemented yet.");
                        }
                        default: {
                            reader.skipValue();
                        }
                    }
                } while (reader.hasNext());
                reader.endObject();
                reader.close();
                switch (messageType) {
                    case INVOCATION: {
                        if (argumentsToken != null) {
                            try {
                                List<Type> types = binder.getParameterTypes(target);
                                arguments = this.bindArguments(argumentsToken, types);
                            }
                            catch (Exception ex) {
                                argumentBindingException = ex;
                            }
                        }
                        if (argumentBindingException != null) {
                            hubMessages.add(new InvocationBindingFailureMessage(invocationId, target, argumentBindingException));
                            continue block33;
                        }
                        if (arguments == null) {
                            hubMessages.add(new InvocationMessage(null, invocationId, target, new Object[0], null));
                            continue block33;
                        }
                        hubMessages.add(new InvocationMessage(null, invocationId, target, arguments.toArray(), null));
                        continue block33;
                    }
                    case COMPLETION: {
                        Type returnType;
                        if (resultToken != null) {
                            returnType = binder.getReturnType(invocationId);
                            result = this.gson.fromJson(resultToken, (Type)(returnType != null ? returnType : Object.class));
                        }
                        hubMessages.add(new CompletionMessage(null, invocationId, result, error));
                        continue block33;
                    }
                    case STREAM_ITEM: {
                        Type returnType;
                        if (resultToken != null) {
                            returnType = binder.getReturnType(invocationId);
                            result = this.gson.fromJson(resultToken, (Type)(returnType != null ? returnType : Object.class));
                        }
                        hubMessages.add(new StreamItem(null, invocationId, result));
                        continue block33;
                    }
                    case STREAM_INVOCATION: 
                    case CANCEL_INVOCATION: {
                        throw new UnsupportedOperationException(String.format("The message type %s is not supported yet.", new Object[]{messageType}));
                    }
                    case PING: {
                        hubMessages.add(PingMessage.getInstance());
                        continue block33;
                    }
                    case CLOSE: {
                        if (error != null) {
                            hubMessages.add(new CloseMessage(error));
                            continue block33;
                        }
                        hubMessages.add(new CloseMessage());
                        continue block33;
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading JSON.", ex);
        }
        return hubMessages;
    }

    @Override
    public ByteBuffer writeMessage(HubMessage hubMessage) {
        return ByteBuffer.wrap((this.gson.toJson(hubMessage) + RECORD_SEPARATOR).getBytes(StandardCharsets.UTF_8));
    }

    private ArrayList<Object> bindArguments(JsonArray argumentsToken, List<Type> paramTypes) {
        if (argumentsToken.size() != paramTypes.size()) {
            throw new RuntimeException(String.format("Invocation provides %d argument(s) but target expects %d.", argumentsToken.size(), paramTypes.size()));
        }
        ArrayList arguments = null;
        if (paramTypes.size() >= 1) {
            arguments = new ArrayList();
            for (int i = 0; i < paramTypes.size(); ++i) {
                arguments.add(this.gson.fromJson(argumentsToken.get(i), paramTypes.get(i)));
            }
        }
        return arguments;
    }

    private ArrayList<Object> bindArguments(JsonReader reader, List<Type> paramTypes) throws IOException {
        reader.beginArray();
        int paramCount = paramTypes.size();
        int argCount = 0;
        ArrayList<Object> arguments = new ArrayList<Object>();
        while (reader.peek() != JsonToken.END_ARRAY) {
            if (argCount < paramCount) {
                arguments.add(this.gson.fromJson(reader, paramTypes.get(argCount)));
            } else {
                reader.skipValue();
            }
            ++argCount;
        }
        if (paramCount != argCount) {
            throw new RuntimeException(String.format("Invocation provides %d argument(s) but target expects %d.", argCount, paramCount));
        }
        reader.endArray();
        return arguments;
    }
}

