/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import com.microsoft.signalr.HttpClient;
import com.microsoft.signalr.HttpRequest;
import com.microsoft.signalr.OnReceiveCallBack;
import com.microsoft.signalr.Transport;
import com.microsoft.signalr.TransportOnClosedCallback;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import io.reactivex.rxjava3.subjects.CompletableSubject;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LongPollingTransport
implements Transport {
    private OnReceiveCallBack onReceiveCallBack;
    private TransportOnClosedCallback onClose = reason -> {};
    private String url;
    private final HttpClient client;
    private final HttpClient pollingClient;
    private final Map<String, String> headers;
    private static final int POLL_TIMEOUT = 100000;
    private final Single<String> accessTokenProvider;
    private volatile Boolean active = false;
    private String pollUrl;
    private String closeError;
    private BehaviorSubject<String> receiveLoopSubject = BehaviorSubject.create();
    private CompletableSubject closeSubject = CompletableSubject.create();
    private ExecutorService threadPool;
    private ExecutorService onReceiveThread;
    private AtomicBoolean stopCalled = new AtomicBoolean(false);
    private final Logger logger = LoggerFactory.getLogger(LongPollingTransport.class);

    public LongPollingTransport(Map<String, String> headers, HttpClient client, Single<String> accessTokenProvider) {
        this.headers = headers;
        this.client = client;
        this.pollingClient = client.cloneWithTimeOut(100000);
        this.accessTokenProvider = accessTokenProvider;
    }

    boolean isActive() {
        return this.active;
    }

    private Completable updateHeaderToken() {
        return this.accessTokenProvider.doOnSuccess(token -> {
            if (!token.isEmpty()) {
                this.headers.put("Authorization", "Bearer " + token);
            }
        }).ignoreElement();
    }

    @Override
    public Completable start(String url) {
        this.active = true;
        this.logger.debug("Starting LongPolling transport.");
        this.url = url;
        this.pollUrl = url + "&_=" + System.currentTimeMillis();
        this.logger.debug("Polling {}.", (Object)this.pollUrl);
        return this.updateHeaderToken().andThen(Completable.defer(() -> {
            HttpRequest request = new HttpRequest();
            request.addHeaders(this.headers);
            return this.pollingClient.get(this.pollUrl, request).flatMapCompletable(response -> {
                if (response.getStatusCode() != 200) {
                    this.logger.error("Unexpected response code {}.", (Object)response.getStatusCode());
                    this.active = false;
                    return Completable.error(new Exception("Failed to connect."));
                }
                this.active = true;
                this.threadPool = Executors.newCachedThreadPool();
                this.threadPool.execute(() -> {
                    this.onReceiveThread = Executors.newSingleThreadExecutor();
                    this.receiveLoopSubject.observeOn(Schedulers.io()).subscribe(u -> this.poll((String)u), e -> this.stop().onErrorComplete().subscribe(), () -> this.stop().onErrorComplete().subscribe());
                    this.receiveLoopSubject.onNext(url);
                });
                return Completable.complete();
            });
        }));
    }

    private void poll(String url) {
        if (this.active.booleanValue()) {
            this.pollUrl = url + "&_=" + System.currentTimeMillis();
            this.logger.debug("Polling {}.", (Object)this.pollUrl);
            this.updateHeaderToken().andThen(Completable.defer(() -> {
                HttpRequest request = new HttpRequest();
                request.addHeaders(this.headers);
                this.pollingClient.get(this.pollUrl, request).subscribe(response -> {
                    if (response.getStatusCode() == 204) {
                        this.logger.info("LongPolling transport terminated by server.");
                        this.active = false;
                    } else if (response.getStatusCode() != 200) {
                        this.logger.error("Unexpected response code {}.", (Object)response.getStatusCode());
                        this.active = false;
                        this.closeError = "Unexpected response code " + response.getStatusCode() + ".";
                    } else if (response.getContent() != null && response.getContent().hasRemaining()) {
                        this.logger.debug("Message received.");
                        try {
                            this.onReceiveThread.submit(() -> this.onReceive(response.getContent()));
                        }
                        catch (Exception exception) {}
                    } else {
                        this.logger.debug("Poll timed out, reissuing.");
                    }
                    this.receiveLoopSubject.onNext(url);
                }, e -> this.receiveLoopSubject.onError((Throwable)e));
                return Completable.complete();
            })).subscribe(() -> {}, e -> this.receiveLoopSubject.onError((Throwable)e));
        } else {
            this.logger.debug("Long Polling transport polling complete.");
            this.receiveLoopSubject.onComplete();
        }
    }

    @Override
    public Completable send(ByteBuffer message) {
        if (!this.active.booleanValue()) {
            return Completable.error(new Exception("Cannot send unless the transport is active."));
        }
        return this.updateHeaderToken().andThen(Completable.defer(() -> {
            HttpRequest request = new HttpRequest();
            request.addHeaders(this.headers);
            return this.client.post(this.url, message, request).ignoreElement();
        }));
    }

    @Override
    public void setOnReceive(OnReceiveCallBack callback) {
        this.onReceiveCallBack = callback;
    }

    @Override
    public void onReceive(ByteBuffer message) {
        this.onReceiveCallBack.invoke(message);
        this.logger.debug("OnReceived callback has been invoked.");
    }

    @Override
    public void setOnClose(TransportOnClosedCallback onCloseCallback) {
        this.onClose = onCloseCallback;
    }

    @Override
    public Completable stop() {
        if (this.stopCalled.compareAndSet(false, true)) {
            this.active = false;
            Completable stopCompletable = this.updateHeaderToken().andThen(Completable.defer(() -> {
                HttpRequest request = new HttpRequest();
                request.addHeaders(this.headers);
                return this.pollingClient.delete(this.url, request).ignoreElement().andThen(this.receiveLoopSubject.ignoreElements()).doOnComplete(() -> this.cleanup(this.closeError));
            })).doOnError(e -> this.cleanup(e.getMessage()));
            stopCompletable.subscribe(this.closeSubject);
        }
        return this.closeSubject;
    }

    private void cleanup(String error) {
        this.logger.info("LongPolling transport stopped.");
        if (this.onReceiveThread != null) {
            this.onReceiveThread.shutdown();
        }
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
        this.onClose.invoke(error);
    }
}

