/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import com.google.gson.stream.JsonReader;
import com.microsoft.signalr.TransportEnum;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

class NegotiateResponse {
    private String connectionId;
    private String connectionToken;
    private Set<String> availableTransports = new HashSet<String>();
    private String redirectUrl;
    private String accessToken;
    private String error;
    private String finalUrl;
    private int version;
    private TransportEnum chosenTransport;

    public NegotiateResponse(JsonReader reader) {
        try {
            reader.beginObject();
            do {
                String name;
                switch (name = reader.nextName()) {
                    case "error": {
                        this.error = reader.nextString();
                        break;
                    }
                    case "ProtocolVersion": {
                        this.error = "Detected an ASP.NET SignalR Server. This client only supports connecting to an ASP.NET Core SignalR Server. See https://aka.ms/signalr-core-differences for details.";
                        return;
                    }
                    case "negotiateVersion": {
                        this.version = reader.nextInt();
                        break;
                    }
                    case "connectionToken": {
                        this.connectionToken = reader.nextString();
                        break;
                    }
                    case "url": {
                        this.redirectUrl = reader.nextString();
                        break;
                    }
                    case "accessToken": {
                        this.accessToken = reader.nextString();
                        break;
                    }
                    case "availableTransports": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            reader.beginObject();
                            while (reader.hasNext()) {
                                String property;
                                String transport = null;
                                switch (property = reader.nextName()) {
                                    case "transport": {
                                        transport = reader.nextString();
                                        break;
                                    }
                                    case "transferFormats": {
                                        reader.skipValue();
                                        break;
                                    }
                                    default: {
                                        reader.skipValue();
                                    }
                                }
                                this.availableTransports.add(transport);
                            }
                            reader.endObject();
                        }
                        reader.endArray();
                        break;
                    }
                    case "connectionId": {
                        this.connectionId = reader.nextString();
                        break;
                    }
                    default: {
                        reader.skipValue();
                    }
                }
            } while (reader.hasNext());
            reader.endObject();
            reader.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading NegotiateResponse", ex);
        }
    }

    public NegotiateResponse(String url) {
        this.finalUrl = url;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public Set<String> getAvailableTransports() {
        return this.availableTransports;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getError() {
        return this.error;
    }

    public String getFinalUrl() {
        return this.finalUrl;
    }

    public int getVersion() {
        return this.version;
    }

    public String getConnectionToken() {
        return this.connectionToken;
    }

    public void setFinalUrl(String url) {
        this.finalUrl = url;
    }

    public TransportEnum getChosenTransport() {
        return this.chosenTransport;
    }

    public void setChosenTransport(TransportEnum chosenTransport) {
        this.chosenTransport = chosenTransport;
    }
}

