/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import com.microsoft.signalr.OnReceiveCallBack;
import com.microsoft.signalr.WebSocketOnClosedCallback;
import com.microsoft.signalr.WebSocketWrapper;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.subjects.CompletableSubject;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OkHttpWebSocketWrapper
extends WebSocketWrapper {
    private WebSocket websocketClient;
    private String url;
    private Map<String, String> headers;
    private OkHttpClient client;
    private OnReceiveCallBack onReceive;
    private WebSocketOnClosedCallback onClose;
    private CompletableSubject startSubject = CompletableSubject.create();
    private CompletableSubject closeSubject = CompletableSubject.create();
    private final ReentrantLock stateLock = new ReentrantLock();
    private final Logger logger = LoggerFactory.getLogger(OkHttpWebSocketWrapper.class);

    public OkHttpWebSocketWrapper(String url, Map<String, String> headers, OkHttpClient client) {
        this.url = url;
        this.headers = headers;
        this.client = client;
    }

    @Override
    public Completable start() {
        Headers.Builder headerBuilder = new Headers.Builder();
        for (String key : this.headers.keySet()) {
            headerBuilder.add(key, this.headers.get(key));
        }
        Request request = new Request.Builder().url(this.url).headers(headerBuilder.build()).build();
        this.websocketClient = this.client.newWebSocket(request, new SignalRWebSocketListener());
        return this.startSubject;
    }

    @Override
    public Completable stop() {
        this.websocketClient.close(1000, "HubConnection stopped.");
        return this.closeSubject;
    }

    @Override
    public Completable send(ByteBuffer message) {
        ByteString bs = ByteString.of(message);
        this.websocketClient.send(bs);
        return Completable.complete();
    }

    @Override
    public void setOnReceive(OnReceiveCallBack onReceive) {
        this.onReceive = onReceive;
    }

    @Override
    public void setOnClose(WebSocketOnClosedCallback onClose) {
        this.onClose = onClose;
    }

    private class SignalRWebSocketListener
    extends WebSocketListener {
        private SignalRWebSocketListener() {
        }

        @Override
        public void onOpen(WebSocket webSocket, Response response) {
            OkHttpWebSocketWrapper.this.stateLock.lock();
            try {
                OkHttpWebSocketWrapper.this.startSubject.onComplete();
            }
            finally {
                OkHttpWebSocketWrapper.this.stateLock.unlock();
            }
        }

        @Override
        public void onMessage(WebSocket webSocket, String message) {
            OkHttpWebSocketWrapper.this.onReceive.invoke(ByteBuffer.wrap(message.getBytes(StandardCharsets.UTF_8)));
        }

        @Override
        public void onMessage(WebSocket webSocket, ByteString bytes) {
            OkHttpWebSocketWrapper.this.onReceive.invoke(bytes.asByteBuffer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClosing(WebSocket webSocket, int code, String reason) {
            boolean isOpen = false;
            OkHttpWebSocketWrapper.this.stateLock.lock();
            try {
                isOpen = OkHttpWebSocketWrapper.this.startSubject.hasComplete();
            }
            finally {
                OkHttpWebSocketWrapper.this.stateLock.unlock();
            }
            OkHttpWebSocketWrapper.this.logger.info("WebSocket closing with status code '{}' and reason '{}'.", (Object)code, (Object)reason);
            if (isOpen) {
                OkHttpWebSocketWrapper.this.onClose.invoke(code, reason);
            }
            try {
                OkHttpWebSocketWrapper.this.stateLock.lock();
                OkHttpWebSocketWrapper.this.closeSubject.onComplete();
            }
            finally {
                OkHttpWebSocketWrapper.this.stateLock.unlock();
            }
            this.checkStartFailure(null);
            webSocket.close(1000, "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            OkHttpWebSocketWrapper.this.logger.error("WebSocket closed from an error.", t);
            boolean isOpen = false;
            try {
                OkHttpWebSocketWrapper.this.stateLock.lock();
                if (!OkHttpWebSocketWrapper.this.closeSubject.hasComplete()) {
                    OkHttpWebSocketWrapper.this.closeSubject.onError(new RuntimeException(t));
                }
                isOpen = OkHttpWebSocketWrapper.this.startSubject.hasComplete();
            }
            finally {
                OkHttpWebSocketWrapper.this.stateLock.unlock();
            }
            if (isOpen) {
                OkHttpWebSocketWrapper.this.onClose.invoke(null, t.getMessage());
            }
            this.checkStartFailure(t);
        }

        private void checkStartFailure(Throwable t) {
            OkHttpWebSocketWrapper.this.stateLock.lock();
            try {
                if (!OkHttpWebSocketWrapper.this.startSubject.hasComplete()) {
                    OkHttpWebSocketWrapper.this.startSubject.onError(new RuntimeException("There was an error starting the WebSocket transport.", t));
                }
            }
            finally {
                OkHttpWebSocketWrapper.this.stateLock.unlock();
            }
        }
    }
}

