/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

class Utils {
    Utils() {
    }

    public static String appendQueryString(String original, String queryStringValue) {
        if (original.contains("?")) {
            return original + "&" + queryStringValue;
        }
        return original + "?" + queryStringValue;
    }

    public static Class<?> typeToClass(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(Utils.typeToClass(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            return Utils.typeToClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type).getBounds();
            return bounds.length == 0 ? Object.class : Utils.typeToClass(bounds[0]);
        }
        if (type instanceof WildcardType) {
            Type[] bounds = ((WildcardType)type).getUpperBounds();
            return bounds.length == 0 ? Object.class : Utils.typeToClass(bounds[0]);
        }
        throw new UnsupportedOperationException("Cannot handle type class: " + type.getClass());
    }

    public static <T> T cast(Class<?> returnClass, Object obj) {
        if (returnClass.isPrimitive()) {
            return (T)obj;
        }
        return (T)returnClass.cast(obj);
    }

    public static <T> T cast(Type returnType, Object obj) {
        return Utils.cast(Utils.typeToClass(returnType), obj);
    }
}

