/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.signalr;

import com.microsoft.signalr.HttpClient;
import com.microsoft.signalr.OnReceiveCallBack;
import com.microsoft.signalr.Transport;
import com.microsoft.signalr.TransportOnClosedCallback;
import com.microsoft.signalr.WebSocketWrapper;
import io.reactivex.rxjava3.core.Completable;
import java.nio.ByteBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketTransport
implements Transport {
    private WebSocketWrapper webSocketClient;
    private OnReceiveCallBack onReceiveCallBack;
    private TransportOnClosedCallback onClose;
    private String url;
    private HttpClient client;
    private Map<String, String> headers;
    private final Logger logger = LoggerFactory.getLogger(WebSocketTransport.class);
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String WS = "ws";
    private static final String WSS = "wss";

    public WebSocketTransport(Map<String, String> headers, HttpClient client) {
        this.client = client;
        this.headers = headers;
    }

    String getUrl() {
        return this.url;
    }

    private String formatUrl(String url) {
        if (url.startsWith(HTTPS)) {
            url = WSS + url.substring(HTTPS.length());
        } else if (url.startsWith(HTTP)) {
            url = WS + url.substring(HTTP.length());
        }
        return url;
    }

    @Override
    public Completable start(String url) {
        this.url = this.formatUrl(url);
        this.logger.debug("Starting Websocket connection.");
        this.webSocketClient = this.client.createWebSocket(this.url, this.headers);
        this.webSocketClient.setOnReceive(message -> this.onReceive(message));
        this.webSocketClient.setOnClose((Integer code, String reason) -> {
            if (this.onClose != null) {
                this.onClose(code, reason);
            }
        });
        return this.webSocketClient.start().doOnComplete(() -> this.logger.info("WebSocket transport connected to: {}.", (Object)this.url));
    }

    @Override
    public Completable send(ByteBuffer message) {
        return this.webSocketClient.send(message);
    }

    @Override
    public void setOnReceive(OnReceiveCallBack callback) {
        this.onReceiveCallBack = callback;
        this.logger.debug("OnReceived callback has been set.");
    }

    @Override
    public void onReceive(ByteBuffer message) {
        this.onReceiveCallBack.invoke(message);
    }

    @Override
    public void setOnClose(TransportOnClosedCallback onCloseCallback) {
        this.onClose = onCloseCallback;
    }

    @Override
    public Completable stop() {
        return this.webSocketClient.stop().doOnEvent(t -> this.logger.info("WebSocket connection stopped."));
    }

    void onClose(Integer code, String reason) {
        if (code == null || code != 1000) {
            this.onClose.invoke(reason);
        } else {
            this.onClose.invoke(null);
        }
    }
}

