/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava;

import com.oneidentity.safeguard.safeguardjava.ISafeguardConnection;
import com.oneidentity.safeguard.safeguardjava.ISafeguardSessionsConnection;
import com.oneidentity.safeguard.safeguardjava.IStreamingRequest;
import com.oneidentity.safeguard.safeguardjava.data.FullResponse;
import com.oneidentity.safeguard.safeguardjava.data.Method;
import com.oneidentity.safeguard.safeguardjava.data.Service;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.event.SafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.exceptions.ArgumentException;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import java.util.Map;

class PersistentSafeguardConnection
implements ISafeguardConnection {
    private final ISafeguardConnection _connection;
    private boolean disposed;

    public PersistentSafeguardConnection(ISafeguardConnection connection) {
        this._connection = connection;
    }

    @Override
    public IStreamingRequest getStreamingRequest() {
        return this._connection.getStreamingRequest();
    }

    @Override
    public void dispose() {
        this._connection.dispose();
    }

    @Override
    public FullResponse JoinSps(ISafeguardSessionsConnection spsConnection, String certificateChain, String sppAddress) throws ObjectDisposedException, SafeguardForJavaException, ArgumentException {
        if (this._connection.getAccessTokenLifetimeRemaining() <= 0) {
            this._connection.refreshAccessToken();
        }
        return this._connection.JoinSps(spsConnection, certificateChain, sppAddress);
    }

    @Override
    public int getAccessTokenLifetimeRemaining() throws ObjectDisposedException, SafeguardForJavaException {
        return this._connection.getAccessTokenLifetimeRemaining();
    }

    @Override
    public void refreshAccessToken() throws ObjectDisposedException, SafeguardForJavaException {
        this._connection.refreshAccessToken();
    }

    @Override
    public String invokeMethod(Service service, Method method, String relativeUrl, String body, Map<String, String> parameters, Map<String, String> additionalHeaders, Integer timeout2) throws ObjectDisposedException, SafeguardForJavaException, ArgumentException {
        if (this._connection.getAccessTokenLifetimeRemaining() <= 0) {
            this._connection.refreshAccessToken();
        }
        return this._connection.invokeMethod(service, method, relativeUrl, body, parameters, additionalHeaders, timeout2);
    }

    @Override
    public FullResponse invokeMethodFull(Service service, Method method, String relativeUrl, String body, Map<String, String> parameters, Map<String, String> additionalHeaders, Integer timeout2) throws ObjectDisposedException, SafeguardForJavaException, ArgumentException {
        if (this._connection.getAccessTokenLifetimeRemaining() <= 0) {
            this._connection.refreshAccessToken();
        }
        return this._connection.invokeMethodFull(service, method, relativeUrl, body, parameters, additionalHeaders, timeout2);
    }

    @Override
    public String invokeMethodCsv(Service service, Method method, String relativeUrl, String body, Map<String, String> parameters, Map<String, String> additionalHeaders, Integer timeout2) throws ObjectDisposedException, SafeguardForJavaException, ArgumentException {
        if (this._connection.getAccessTokenLifetimeRemaining() <= 0) {
            this._connection.refreshAccessToken();
        }
        return this._connection.invokeMethodCsv(service, method, relativeUrl, body, parameters, additionalHeaders, timeout2);
    }

    @Override
    public SafeguardEventListener getEventListener() throws ObjectDisposedException, ArgumentException {
        return this._connection.getEventListener();
    }

    @Override
    public ISafeguardConnection GetManagementServiceConnection(String networkAddress) {
        return this._connection.GetManagementServiceConnection(networkAddress);
    }

    @Override
    public ISafeguardEventListener getPersistentEventListener() throws ObjectDisposedException, SafeguardForJavaException {
        return this._connection.getPersistentEventListener();
    }

    @Override
    public void logOut() throws ObjectDisposedException {
        this._connection.logOut();
    }
}

