/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava;

import com.oneidentity.safeguard.safeguardjava.ISafeguardA2AContext;
import com.oneidentity.safeguard.safeguardjava.ISafeguardConnection;
import com.oneidentity.safeguard.safeguardjava.PersistentSafeguardConnection;
import com.oneidentity.safeguard.safeguardjava.SafeguardA2AContext;
import com.oneidentity.safeguard.safeguardjava.SafeguardConnection;
import com.oneidentity.safeguard.safeguardjava.Utils;
import com.oneidentity.safeguard.safeguardjava.authentication.AccessTokenAuthenticator;
import com.oneidentity.safeguard.safeguardjava.authentication.AnonymousAuthenticator;
import com.oneidentity.safeguard.safeguardjava.authentication.CertificateAuthenticator;
import com.oneidentity.safeguard.safeguardjava.authentication.IAuthenticationMechanism;
import com.oneidentity.safeguard.safeguardjava.authentication.PasswordAuthenticator;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventHandler;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.event.PersistentSafeguardA2AEventListener;
import com.oneidentity.safeguard.safeguardjava.event.PersistentSafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.exceptions.ArgumentException;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;

public final class Safeguard {
    private static final int DEFAULTAPIVERSION = 4;

    private Safeguard() {
    }

    private static SafeguardConnection getConnection(IAuthenticationMechanism authenticationMechanism) throws ObjectDisposedException, SafeguardForJavaException {
        authenticationMechanism.refreshAccessToken();
        return new SafeguardConnection(authenticationMechanism);
    }

    public static ISafeguardConnection connect(String networkAddress, char[] accessToken, Integer apiVersion, Boolean ignoreSsl) throws ArgumentException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return new SafeguardConnection(new AccessTokenAuthenticator(networkAddress, accessToken, version, sslIgnore, null));
    }

    public static ISafeguardConnection connect(String networkAddress, char[] accessToken, HostnameVerifier validationCallback, Integer apiVersion) throws ArgumentException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        return new SafeguardConnection(new AccessTokenAuthenticator(networkAddress, accessToken, version, false, validationCallback));
    }

    public static ISafeguardConnection connect(String networkAddress, String provider, String username, char[] password, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return Safeguard.getConnection(new PasswordAuthenticator(networkAddress, provider, username, password, version, sslIgnore, null));
    }

    public static ISafeguardConnection connect(String networkAddress, String provider, String username, char[] password, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, ArgumentException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        return Safeguard.getConnection(new PasswordAuthenticator(networkAddress, provider, username, password, version, false, validationCallback));
    }

    public static ISafeguardConnection connect(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, keystorePath, keystorePassword, certificateAlias, version, sslIgnore, null));
    }

    public static ISafeguardConnection connect(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, keystorePath, keystorePassword, certificateAlias, version, false, validationCallback));
    }

    public static ISafeguardConnection connect(String networkAddress, String thumbprint, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        if (Utils.isWindows()) {
            if (!Utils.isSunMSCAPILoaded()) {
                throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
            }
        } else {
            throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, thumbprint, version, sslIgnore, null));
    }

    public static ISafeguardConnection connect(String networkAddress, String thumbprint, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        if (Utils.isWindows()) {
            if (!Utils.isSunMSCAPILoaded()) {
                throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
            }
        } else {
            throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, thumbprint, version, false, validationCallback));
    }

    public static ISafeguardConnection connect(String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificatePath, certificatePassword, version, sslIgnore, null));
    }

    public static ISafeguardConnection connect(String networkAddress, String certificatePath, char[] certificatePassword, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificatePath, certificatePassword, version, false, validationCallback));
    }

    public static ISafeguardConnection connect(String networkAddress, byte[] certificateData, char[] certificatePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificateData, certificatePassword, certificateAlias, version, sslIgnore, null));
    }

    public static ISafeguardConnection connect(String networkAddress, byte[] certificateData, char[] certificatePassword, String certificateAlias, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificateData, certificatePassword, certificateAlias, version, false, validationCallback));
    }

    public static ISafeguardConnection connect(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, String provider, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, keystorePath, keystorePassword, certificateAlias, version, sslIgnore, null, provider));
    }

    public static ISafeguardConnection connect(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, HostnameVerifier validationCallback, String provider, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, keystorePath, keystorePassword, certificateAlias, version, false, validationCallback, provider));
    }

    public static ISafeguardConnection connect(String networkAddress, String thumbprint, String provider, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        if (Utils.isWindows()) {
            if (!Utils.isSunMSCAPILoaded()) {
                throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
            }
        } else {
            throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, thumbprint, version, sslIgnore, null, provider));
    }

    public static ISafeguardConnection connect(String networkAddress, String thumbprint, HostnameVerifier validationCallback, String provider, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        if (Utils.isWindows()) {
            if (!Utils.isSunMSCAPILoaded()) {
                throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
            }
        } else {
            throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, thumbprint, version, false, validationCallback, provider));
    }

    public static ISafeguardConnection connect(String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl, String provider) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificatePath, certificatePassword, version, sslIgnore, null, provider));
    }

    public static ISafeguardConnection connect(String networkAddress, String certificatePath, char[] certificatePassword, HostnameVerifier validationCallback, String provider, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificatePath, certificatePassword, version, false, validationCallback, provider));
    }

    public static ISafeguardConnection connect(String networkAddress, byte[] certificateData, char[] certificatePassword, String certificateAlias, String provider, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificateData, certificatePassword, certificateAlias, version, sslIgnore, null, provider));
    }

    public static ISafeguardConnection connect(String networkAddress, byte[] certificateData, char[] certificatePassword, String certificateAlias, HostnameVerifier validationCallback, String provider, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificateData, certificatePassword, certificateAlias, version, false, validationCallback, provider));
    }

    public static ISafeguardConnection connect(String networkAddress, Integer apiVersion, Boolean ignoreSsl) throws SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return new SafeguardConnection(new AnonymousAuthenticator(networkAddress, version, sslIgnore, null));
    }

    public static ISafeguardConnection connect(String networkAddress, HostnameVerifier validationCallback, Integer apiVersion) throws SafeguardForJavaException {
        int version = 4;
        if (apiVersion != null) {
            version = apiVersion;
        }
        return new SafeguardConnection(new AnonymousAuthenticator(networkAddress, version, false, validationCallback));
    }

    public static ISafeguardConnection Persist(ISafeguardConnection connection) {
        return new PersistentSafeguardConnection(connection);
    }

    public static class A2A {
        public static ISafeguardA2AContext getContext(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new SafeguardA2AContext(networkAddress, certificateAlias, keystorePath, keystorePassword, version, sslIgnore, null);
        }

        public static ISafeguardA2AContext getContext(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, HostnameVerifier validationCallback, Integer apiVersion) {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            return new SafeguardA2AContext(networkAddress, certificateAlias, keystorePath, keystorePassword, version, false, validationCallback);
        }

        public static ISafeguardA2AContext getContext(String networkAddress, String thumbprint, Integer apiVersion, Boolean ignoreSsl) throws SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            if (Utils.isWindows()) {
                if (!Utils.isSunMSCAPILoaded()) {
                    throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
                }
            } else {
                throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
            }
            return new SafeguardA2AContext(networkAddress, version, sslIgnore, thumbprint, null);
        }

        public static ISafeguardA2AContext getContext(String networkAddress, String thumbprint, HostnameVerifier validationCallback, Integer apiVersion) throws SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            if (Utils.isWindows()) {
                if (!Utils.isSunMSCAPILoaded()) {
                    throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
                }
            } else {
                throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
            }
            return new SafeguardA2AContext(networkAddress, version, false, thumbprint, validationCallback);
        }

        public static ISafeguardA2AContext getContext(String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new SafeguardA2AContext(networkAddress, certificatePath, certificatePassword, version, sslIgnore, null);
        }

        public static ISafeguardA2AContext getContext(String networkAddress, String certificatePath, char[] certificatePassword, HostnameVerifier validationCallback, Integer apiVersion) {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            return new SafeguardA2AContext(networkAddress, certificatePath, certificatePassword, version, false, validationCallback);
        }

        public static ISafeguardA2AContext getContext(String networkAddress, byte[] certificateData, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new SafeguardA2AContext(networkAddress, certificateData, certificatePassword, version, sslIgnore, null);
        }

        public static ISafeguardA2AContext getContext(String networkAddress, byte[] certificateData, char[] certificatePassword, HostnameVerifier validationCallback, Integer apiVersion) {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            return new SafeguardA2AContext(networkAddress, certificateData, certificatePassword, version, false, validationCallback);
        }

        public static class Event {
            public static ISafeguardEventListener getPersistentA2AEventListener(char[] apiKey, ISafeguardEventHandler handler, String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                boolean sslIgnore = false;
                if (ignoreSsl != null) {
                    sslIgnore = ignoreSsl;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificateAlias, keystorePath, keystorePassword, version, ignoreSsl, null), apiKey, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(char[] apiKey, ISafeguardEventHandler handler, String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificateAlias, keystorePath, keystorePassword, version, false, validationCallback), apiKey, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(char[] apiKey, ISafeguardEventHandler handler, String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                boolean sslIgnore = false;
                if (ignoreSsl != null) {
                    sslIgnore = ignoreSsl;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificatePath, certificatePassword, version, (boolean)ignoreSsl, null), apiKey, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(char[] apiKey, ISafeguardEventHandler handler, String networkAddress, String certificatePath, char[] certificatePassword, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificatePath, certificatePassword, version, false, validationCallback), apiKey, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(char[] apiKey, ISafeguardEventHandler handler, String networkAddress, byte[] certificateData, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                boolean sslIgnore = false;
                if (ignoreSsl != null) {
                    sslIgnore = ignoreSsl;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificateData, certificatePassword, version, (boolean)ignoreSsl, null), apiKey, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(char[] apiKey, ISafeguardEventHandler handler, String networkAddress, byte[] certificateData, char[] certificatePassword, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificateData, certificatePassword, version, false, validationCallback), apiKey, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(List<char[]> apiKeys, ISafeguardEventHandler handler, String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                boolean sslIgnore = false;
                if (ignoreSsl != null) {
                    sslIgnore = ignoreSsl;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificateAlias, keystorePath, keystorePassword, version, ignoreSsl, null), apiKeys, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(List<char[]> apiKeys, ISafeguardEventHandler handler, String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificateAlias, keystorePath, keystorePassword, version, false, validationCallback), apiKeys, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(List<char[]> apiKeys, ISafeguardEventHandler handler, String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                boolean sslIgnore = false;
                if (ignoreSsl != null) {
                    sslIgnore = ignoreSsl;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificatePath, certificatePassword, version, (boolean)ignoreSsl, null), apiKeys, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(List<char[]> apiKeys, ISafeguardEventHandler handler, String networkAddress, String thumbprint, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, ArgumentException, SafeguardForJavaException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                if (Utils.isWindows()) {
                    if (!Utils.isSunMSCAPILoaded()) {
                        throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
                    }
                } else {
                    throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, version, false, thumbprint, validationCallback), apiKeys, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(List<char[]> apiKeys, ISafeguardEventHandler handler, String networkAddress, String thumbprint, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException, SafeguardForJavaException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                boolean sslIgnore = false;
                if (ignoreSsl != null) {
                    sslIgnore = ignoreSsl;
                }
                if (Utils.isWindows()) {
                    if (!Utils.isSunMSCAPILoaded()) {
                        throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
                    }
                } else {
                    throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, version, ignoreSsl, thumbprint, null), apiKeys, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(List<char[]> apiKeys, ISafeguardEventHandler handler, String networkAddress, String certificatePath, char[] certificatePassword, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificatePath, certificatePassword, version, false, validationCallback), apiKeys, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(List<char[]> apiKeys, ISafeguardEventHandler handler, String networkAddress, byte[] certificateData, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                boolean sslIgnore = false;
                if (ignoreSsl != null) {
                    sslIgnore = ignoreSsl;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificateData, certificatePassword, version, (boolean)ignoreSsl, null), apiKeys, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(List<char[]> apiKeys, ISafeguardEventHandler handler, String networkAddress, byte[] certificateData, char[] certificatePassword, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, ArgumentException {
                int version = 4;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificateData, certificatePassword, version, false, validationCallback), apiKeys, handler);
            }
        }
    }

    public static class Event {
        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String provider, String username, char[] password, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException, ArgumentException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new PasswordAuthenticator(networkAddress, provider, username, password, version, ignoreSsl, null)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String provider, String username, char[] password, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException, ArgumentException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new PasswordAuthenticator(networkAddress, provider, username, password, version, false, validationCallback)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificatePath, certificatePassword, version, ignoreSsl, null)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String certificatePath, char[] certificatePassword, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificatePath, certificatePassword, version, false, validationCallback)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, byte[] certificateData, char[] certificatePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificateData, certificatePassword, certificateAlias, version, (boolean)ignoreSsl, null)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, byte[] certificateData, char[] certificatePassword, String certificateAlias, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificateData, certificatePassword, certificateAlias, version, false, validationCallback)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, keystorePath, keystorePassword, certificateAlias, version, (boolean)ignoreSsl, null)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, keystorePath, keystorePassword, certificateAlias, version, false, validationCallback)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl, String provider) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificatePath, certificatePassword, version, ignoreSsl, null, provider)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String certificatePath, char[] certificatePassword, HostnameVerifier validationCallback, String provider, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificatePath, certificatePassword, version, false, validationCallback, provider)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String thumbprint, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            if (Utils.isWindows()) {
                if (!Utils.isSunMSCAPILoaded()) {
                    throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
                }
            } else {
                throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, thumbprint, version, (boolean)ignoreSsl, null, null)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String thumbprint, HostnameVerifier validationCallback, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            if (Utils.isWindows()) {
                if (!Utils.isSunMSCAPILoaded()) {
                    throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
                }
            } else {
                throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, thumbprint, version, false, validationCallback, null)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String thumbprint, Integer apiVersion, Boolean ignoreSsl, String provider) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            if (Utils.isWindows()) {
                if (!Utils.isSunMSCAPILoaded()) {
                    throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
                }
            } else {
                throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, thumbprint, version, (boolean)ignoreSsl, null, provider)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String thumbprint, HostnameVerifier validationCallback, String provider, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            if (Utils.isWindows()) {
                if (!Utils.isSunMSCAPILoaded()) {
                    throw new SafeguardForJavaException("Missing SunMSCAPI provider. The SunMSCAPI provider must be added as a security provider in $JAVA_HOME/jre/lib/security/java.security configuration file.");
                }
            } else {
                throw new SafeguardForJavaException("Not implemented. This function is only available on the Windows platform.");
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, thumbprint, version, false, validationCallback, provider)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, byte[] certificateData, char[] certificatePassword, String certificateAlias, String provider, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificateData, certificatePassword, certificateAlias, version, (boolean)ignoreSsl, null, provider)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, byte[] certificateData, char[] certificatePassword, String certificateAlias, HostnameVerifier validationCallback, String provider, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificateData, certificatePassword, certificateAlias, version, false, validationCallback, provider)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, String provider, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, keystorePath, keystorePassword, certificateAlias, version, (boolean)ignoreSsl, null, provider)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, HostnameVerifier validationCallback, String provider, Integer apiVersion) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 4;
            if (apiVersion != null) {
                version = apiVersion;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, keystorePath, keystorePassword, certificateAlias, version, false, validationCallback, provider)));
        }
    }
}

