/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava;

import com.oneidentity.safeguard.safeguardjava.ISafeguardSessionsConnection;
import com.oneidentity.safeguard.safeguardjava.ISpsStreamingRequest;
import com.oneidentity.safeguard.safeguardjava.SafeguardConnection;
import com.oneidentity.safeguard.safeguardjava.SpsStreamingRequest;
import com.oneidentity.safeguard.safeguardjava.Utils;
import com.oneidentity.safeguard.safeguardjava.data.FullResponse;
import com.oneidentity.safeguard.safeguardjava.data.JsonBody;
import com.oneidentity.safeguard.safeguardjava.data.Method;
import com.oneidentity.safeguard.safeguardjava.exceptions.ArgumentException;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import com.oneidentity.safeguard.safeguardjava.restclient.RestClient;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;

class SafeguardSessionsConnection
implements ISafeguardSessionsConnection {
    private boolean disposed;
    private RestClient client;

    public SafeguardSessionsConnection(String networkAddress, String username, char[] password, boolean ignoreSsl, HostnameVerifier validationCallback) throws SafeguardForJavaException {
        String spsApiUrl = String.format("https://%s/api", networkAddress);
        this.client = new RestClient(spsApiUrl, username, password, ignoreSsl, validationCallback);
        HashMap headers = new HashMap();
        Logger.getLogger(SafeguardSessionsConnection.class.getName()).log(Level.FINEST, "Starting authentication.");
        SafeguardConnection.logRequestDetails(Method.Get, this.client.getBaseURL() + "/authentication", null, null);
        CloseableHttpResponse response = this.client.execGET("authentication", null, null, null);
        if (response == null) {
            throw new SafeguardForJavaException(String.format("Unable to authenticate to SPS %s", networkAddress));
        }
        String reply = Utils.getResponse(response);
        if (!Utils.isSuccessful(response.getStatusLine().getStatusCode())) {
            throw new SafeguardForJavaException("Error returned from Safeguard API, Error: " + String.format("%d %s", response.getStatusLine().getStatusCode(), reply));
        }
        Header authCookie = response.getFirstHeader("Set-Cookie");
        if (authCookie != null) {
            this.client.addSessionId(authCookie.getValue());
        }
        Logger.getLogger(SafeguardSessionsConnection.class.getName()).log(Level.FINEST, String.format("Response content: $s", reply));
    }

    @Override
    public String invokeMethod(Method method, String relativeUrl, String body) throws ObjectDisposedException, SafeguardForJavaException, ArgumentException {
        return this.invokeMethodFull(method, relativeUrl, body).getBody();
    }

    @Override
    public FullResponse invokeMethodFull(Method method, String relativeUrl, String body) throws ObjectDisposedException, SafeguardForJavaException, ArgumentException {
        if (this.disposed) {
            throw new ObjectDisposedException("SafeguardSessionsConnection");
        }
        if (Utils.isNullOrEmpty(relativeUrl)) {
            throw new ArgumentException("Parameter relativeUrl may not be null or empty");
        }
        Logger.getLogger(SafeguardSessionsConnection.class.getName()).log(Level.FINEST, String.format("Invoking method on sps: $s", relativeUrl));
        HttpResponse response = null;
        SafeguardConnection.logRequestDetails(method, this.client.getBaseURL() + "/" + relativeUrl, null, null);
        switch (method) {
            case Get: {
                response = this.client.execGET(relativeUrl, null, null, null);
                break;
            }
            case Post: {
                response = this.client.execPOST(relativeUrl, null, null, null, new JsonBody(body));
                break;
            }
            case Put: {
                response = this.client.execPUT(relativeUrl, null, null, null, new JsonBody(body));
                break;
            }
            case Delete: {
                response = this.client.execDELETE(relativeUrl, null, null, null);
            }
        }
        if (response == null) {
            throw new SafeguardForJavaException(String.format("Unable to connect to web service %s", this.client.getBaseURL()));
        }
        String reply = Utils.getResponse(response);
        if (!Utils.isSuccessful(response.getStatusLine().getStatusCode())) {
            throw new SafeguardForJavaException("Error returned from Safeguard API, Error: " + String.format("%d %s", response.getStatusLine().getStatusCode(), reply));
        }
        Logger.getLogger(SafeguardSessionsConnection.class.getName()).log(Level.FINEST, String.format("Invoking method finished: $s", reply));
        FullResponse fullResponse = new FullResponse(response.getStatusLine().getStatusCode(), response.getAllHeaders(), reply);
        SafeguardConnection.logResponseDetails(fullResponse);
        return fullResponse;
    }

    @Override
    public ISpsStreamingRequest getStreamingRequest() throws ObjectDisposedException {
        if (this.disposed) {
            throw new ObjectDisposedException("SafeguardSessionsConnection");
        }
        return new SpsStreamingRequest(this.client);
    }

    boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        if (this.client != null) {
            this.client = null;
        }
        this.disposed = true;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            this.disposed = true;
            super.finalize();
        }
    }
}

