/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava;

import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.CloseableHttpResponse;

public class StreamResponse {
    private boolean disposed;
    private final CloseableHttpResponse response;
    private InputStream stream = null;
    private Long contentLength = 0L;

    public StreamResponse(CloseableHttpResponse resp) {
        this.response = resp;
    }

    public InputStream getStream() throws SafeguardForJavaException {
        if (this.stream == null) {
            try {
                this.stream = this.response.getEntity().getContent();
            }
            catch (Exception ex) {
                throw new SafeguardForJavaException("Unable to read the download stream", ex);
            }
        }
        return this.stream;
    }

    public Long getContentLength() {
        if (this.contentLength == 0L) {
            this.contentLength = this.response.getEntity().getContentLength();
        }
        return this.contentLength;
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

