/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava.authentication;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oneidentity.safeguard.safeguardjava.Utils;
import com.oneidentity.safeguard.safeguardjava.authentication.IAuthenticationMechanism;
import com.oneidentity.safeguard.safeguardjava.data.AccessTokenBody;
import com.oneidentity.safeguard.safeguardjava.data.JsonBody;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import com.oneidentity.safeguard.safeguardjava.restclient.RestClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.methods.CloseableHttpResponse;

abstract class AuthenticatorBase
implements IAuthenticationMechanism {
    private boolean disposed;
    private final String networkAddress;
    private final int apiVersion;
    private final boolean ignoreSsl;
    private final HostnameVerifier validationCallback;
    protected char[] accessToken;
    protected final String safeguardRstsUrl;
    protected final String safeguardCoreUrl;
    protected RestClient rstsClient;
    protected RestClient coreClient;

    protected AuthenticatorBase(String networkAddress, int apiVersion, boolean ignoreSsl, HostnameVerifier validationCallback) {
        this.networkAddress = networkAddress;
        this.apiVersion = apiVersion;
        this.ignoreSsl = ignoreSsl;
        this.validationCallback = validationCallback;
        this.safeguardRstsUrl = String.format("https://%s/RSTS", this.networkAddress);
        this.rstsClient = new RestClient(this.safeguardRstsUrl, ignoreSsl, validationCallback);
        this.safeguardCoreUrl = String.format("https://%s/service/core/v%d", this.networkAddress, this.apiVersion);
        this.coreClient = new RestClient(this.safeguardCoreUrl, ignoreSsl, validationCallback);
    }

    @Override
    public abstract String getId();

    @Override
    public String getNetworkAddress() {
        return this.networkAddress;
    }

    @Override
    public int getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public boolean isIgnoreSsl() {
        return this.ignoreSsl;
    }

    @Override
    public HostnameVerifier getValidationCallback() {
        return this.validationCallback;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean hasAccessToken() {
        return this.accessToken != null;
    }

    @Override
    public void clearAccessToken() {
        if (this.accessToken != null) {
            Arrays.fill(this.accessToken, '0');
        }
        this.accessToken = null;
    }

    @Override
    public char[] getAccessToken() throws ObjectDisposedException {
        if (this.disposed) {
            throw new ObjectDisposedException("AuthenticatorBase");
        }
        return this.accessToken;
    }

    @Override
    public int getAccessTokenLifetimeRemaining() throws ObjectDisposedException, SafeguardForJavaException {
        if (this.disposed) {
            throw new ObjectDisposedException("AuthenticatorBase");
        }
        if (!this.hasAccessToken()) {
            return 0;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.format("Bearer %s", new String(this.accessToken)));
        headers.put("X-TokenLifetimeRemaining", "");
        CloseableHttpResponse response = this.coreClient.execGET("LoginMessage", null, headers, null);
        if (response == null) {
            throw new SafeguardForJavaException(String.format("Unable to connect to web service %s", this.coreClient.getBaseURL()));
        }
        if (!Utils.isSuccessful(response.getStatusLine().getStatusCode())) {
            return 0;
        }
        String remainingStr = null;
        if (response.containsHeader("X-TokenLifetimeRemaining")) {
            remainingStr = response.getFirstHeader("X-TokenLifetimeRemaining").getValue();
        }
        int remaining = 10;
        if (remainingStr != null) {
            try {
                remaining = Integer.parseInt(remainingStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return remaining;
    }

    @Override
    public void refreshAccessToken() throws ObjectDisposedException, SafeguardForJavaException {
        if (this.disposed) {
            throw new ObjectDisposedException("AuthenticatorBase");
        }
        char[] rStsToken = this.getRstsTokenInternal();
        AccessTokenBody body = new AccessTokenBody(rStsToken);
        CloseableHttpResponse response = this.coreClient.execPOST("Token/LoginResponse", null, null, null, body);
        if (response == null) {
            throw new SafeguardForJavaException(String.format("Unable to connect to web service %s", this.coreClient.getBaseURL()));
        }
        String reply = Utils.getResponse(response);
        if (!Utils.isSuccessful(response.getStatusLine().getStatusCode())) {
            throw new SafeguardForJavaException("Error exchanging RSTS token from " + this.getId() + "authenticator for Safeguard API access token, Error: " + String.format("%d %s", response.getStatusLine().getStatusCode(), reply));
        }
        Map<String, String> map = Utils.parseResponse(reply);
        if (map.containsKey("UserToken")) {
            this.accessToken = map.get("UserToken").toCharArray();
        }
    }

    @Override
    public String resolveProviderToScope(String provider) throws SafeguardForJavaException {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            HashMap<String, String> parameters = new HashMap<String, String>();
            headers.clear();
            parameters.clear();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            parameters.put("response_type", "token");
            parameters.put("redirect_uri", "urn:InstalledApplication");
            parameters.put("loginRequestStep", "1");
            CloseableHttpResponse response = this.rstsClient.execPOST("UserLogin/LoginController", parameters, headers, null, new JsonBody("RelayState="));
            if (response == null || !Utils.isSuccessful(response.getStatusLine().getStatusCode())) {
                response = this.rstsClient.execGET("UserLogin/LoginController", parameters, headers, null);
            }
            if (response == null) {
                throw new SafeguardForJavaException("Unable to connect to RSTS to find identity provider scopes");
            }
            String reply = Utils.getResponse(response);
            if (!Utils.isSuccessful(response.getStatusLine().getStatusCode())) {
                throw new SafeguardForJavaException("Error requesting identity provider scopes from RSTS, Error: " + String.format("%d %s", response.getStatusLine().getStatusCode(), reply));
            }
            List<Provider> knownScopes = this.parseLoginResponse(reply);
            Provider scope = this.getMatchingScope(provider, knownScopes);
            if (scope == null) {
                StringBuilder s = new StringBuilder();
                knownScopes.forEach(p -> {
                    if (s.length() > 0) {
                        s.append(", ");
                    }
                    s.append(((Provider)p).DisplayName + ", " + ((Provider)p).Id);
                });
                throw new SafeguardForJavaException(String.format("Unable to find scope matching '%s' in [%s]", provider, s.toString()));
            }
            return String.format("rsts:sts:primaryproviderid:%s", scope.Id);
        }
        catch (SafeguardForJavaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SafeguardForJavaException("Unable to connect to determine identity provider", ex);
        }
    }

    protected abstract char[] getRstsTokenInternal() throws ObjectDisposedException, SafeguardForJavaException;

    @Override
    public abstract Object cloneObject() throws SafeguardForJavaException;

    @Override
    public void dispose() {
        this.clearAccessToken();
        this.disposed = true;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.accessToken != null) {
                Arrays.fill(this.accessToken, '0');
            }
        }
        finally {
            this.disposed = true;
            super.finalize();
        }
    }

    private List<Provider> parseLoginResponse(String response) {
        ArrayList<Provider> providers = new ArrayList<Provider>();
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonNodeRoot = mapper.readTree(response);
            JsonNode jsonNodeProviders = jsonNodeRoot.get("Providers");
            Iterator<JsonNode> iter = jsonNodeProviders.elements();
            while (iter.hasNext()) {
                JsonNode providerNode = iter.next();
                Provider p = new Provider(this.getJsonValue(providerNode, "Id"), this.getJsonValue(providerNode, "DisplayName"));
                providers.add(p);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return providers;
    }

    private Provider getMatchingScope(String provider, List<Provider> providers) {
        for (Provider s : providers) {
            if (!s.DisplayName.equalsIgnoreCase(provider) && !s.Id.equalsIgnoreCase(provider)) continue;
            return s;
        }
        return null;
    }

    private String getJsonValue(JsonNode node, String propName) {
        if (node.get(propName) != null) {
            return node.get(propName).asText();
        }
        return null;
    }

    private class Provider {
        private String Id;
        private String DisplayName;

        public Provider(String Id2, String DisplayName) {
            this.Id = Id2;
            this.DisplayName = DisplayName;
        }

        public String getId() {
            return this.Id;
        }

        public String getDisplayName() {
            return this.DisplayName;
        }
    }
}

