/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava.data;

import com.oneidentity.safeguard.safeguardjava.CertificateUtilities;
import com.oneidentity.safeguard.safeguardjava.Utils;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import java.util.Arrays;

public class CertificateContext {
    private String certificateAlias;
    private String certificatePath;
    private byte[] certificateData;
    private char[] certificatePassword;
    private String certificateThumbprint;

    public CertificateContext(String certificateAlias, String certificatePath, byte[] certificateData, char[] certificatePassword) {
        this.certificateAlias = certificateAlias;
        this.certificatePath = certificatePath;
        this.certificateData = certificateData;
        this.certificatePassword = certificatePassword == null ? null : (char[])certificatePassword.clone();
    }

    public CertificateContext(String thumbprint) throws SafeguardForJavaException {
        this.certificateAlias = CertificateUtilities.getClientCertificateAliasFromStore(thumbprint);
        this.certificatePath = null;
        this.certificateData = null;
        this.certificatePassword = null;
        this.certificateThumbprint = thumbprint;
    }

    private CertificateContext() {
    }

    public boolean isWindowsKeyStore() {
        return this.certificateThumbprint != null;
    }

    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public void setCertificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public byte[] getCertificateData() {
        return this.certificateData;
    }

    public void setCertificateData(byte[] certificateData) {
        this.certificateData = certificateData;
    }

    public char[] getCertificatePassword() {
        return this.certificatePassword;
    }

    public void setCertificatePassword(char[] certificatePassword) {
        this.certificatePassword = certificatePassword;
    }

    public String getCertificateThumbprint() {
        return this.certificateThumbprint;
    }

    public void setCertificateThumbprint(String certificateThumbprint) {
        this.certificateThumbprint = certificateThumbprint;
    }

    public CertificateContext cloneObject() {
        CertificateContext clone = new CertificateContext();
        clone.setCertificateAlias(this.certificateAlias);
        clone.setCertificatePath(this.certificatePath);
        clone.setCertificateData(this.certificateData);
        clone.setCertificatePassword(this.certificatePassword == null ? null : (char[])this.certificatePassword.clone());
        clone.setCertificateThumbprint(this.certificateThumbprint);
        return clone;
    }

    public String toString() {
        if (this.certificateData != null) {
            return "certificateData=[internal-data]";
        }
        String result = Utils.isNullOrEmpty(this.certificatePath) ? String.format("certificateAlias=%s", this.certificateAlias) : String.format("certificatePath=%s", this.certificatePath);
        return result;
    }

    public void dispose() {
        if (this.certificatePassword != null) {
            Arrays.fill(this.certificatePassword, '0');
        }
    }
}

