/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava.event;

import com.oneidentity.safeguard.safeguardjava.ISafeguardA2AContext;
import com.oneidentity.safeguard.safeguardjava.event.DefaultSafeguardEventHandler;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventHandler;
import com.oneidentity.safeguard.safeguardjava.event.PersistentSafeguardEventListenerBase;
import com.oneidentity.safeguard.safeguardjava.event.SafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.exceptions.ArgumentException;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersistentSafeguardA2AEventListener
extends PersistentSafeguardEventListenerBase {
    private boolean disposed;
    private final ISafeguardA2AContext a2AContext;
    private final char[] apiKey;
    private final List<char[]> apiKeys;

    public PersistentSafeguardA2AEventListener(ISafeguardA2AContext a2AContext, char[] apiKey, ISafeguardEventHandler handler) throws ObjectDisposedException, ArgumentException {
        this.a2AContext = a2AContext;
        if (apiKey == null) {
            throw new ArgumentException("The apiKey parameter can not be null");
        }
        this.apiKey = (char[])apiKey.clone();
        this.apiKeys = null;
        this.registerEventHandler("AssetAccountPasswordUpdated", handler);
        this.registerEventHandler("AssetAccountSshKeyUpdated", handler);
        this.registerEventHandler("AccountApiKeySecretUpdated", handler);
        Logger.getLogger(PersistentSafeguardA2AEventListener.class.getName()).log(Level.FINEST, "Persistent A2A event listener successfully created.");
    }

    public PersistentSafeguardA2AEventListener(ISafeguardA2AContext a2AContext, List<char[]> apiKeys, ISafeguardEventHandler handler) throws ArgumentException, ObjectDisposedException {
        this.a2AContext = a2AContext;
        if (apiKeys == null) {
            throw new ArgumentException("The apiKey parameter can not be null");
        }
        this.apiKey = null;
        this.apiKeys = new ArrayList<char[]>();
        for (char[] apiKey : apiKeys) {
            this.apiKeys.add((char[])apiKey.clone());
        }
        if (this.apiKeys.isEmpty()) {
            throw new ArgumentException("Parameter apiKeys must include at least one item");
        }
        this.registerEventHandler("AssetAccountPasswordUpdated", handler);
        this.registerEventHandler("AssetAccountSshKeyUpdated", handler);
        this.registerEventHandler("AccountApiKeySecretUpdated", handler);
        Logger.getLogger(PersistentSafeguardA2AEventListener.class.getName()).log(Level.FINEST, "Persistent A2A event listener successfully created.");
    }

    @Override
    public SafeguardEventListener reconnectEventListener() throws ObjectDisposedException, ArgumentException {
        if (this.apiKey != null) {
            return (SafeguardEventListener)this.a2AContext.getA2AEventListener(this.apiKey, (ISafeguardEventHandler)new DefaultSafeguardEventHandler());
        }
        return (SafeguardEventListener)this.a2AContext.getA2AEventListener(this.apiKeys, (ISafeguardEventHandler)new DefaultSafeguardEventHandler());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.apiKey != null) {
            Arrays.fill(this.apiKey, '0');
        }
        if (this.apiKeys != null) {
            for (char[] apiKey : this.apiKeys) {
                Arrays.fill(apiKey, '0');
            }
        }
        if (this.a2AContext != null) {
            this.a2AContext.dispose();
        }
        this.disposed = true;
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            if (this.apiKey != null) {
                Arrays.fill(this.apiKey, '0');
            }
            if (this.apiKeys != null) {
                for (char[] apiKey : this.apiKeys) {
                    Arrays.fill(apiKey, '0');
                }
            }
            if (this.a2AContext != null) {
                this.a2AContext.dispose();
            }
        }
        finally {
            this.disposed = true;
            super.finalize();
        }
    }
}

