/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava.event;

import com.google.gson.JsonElement;
import com.microsoft.signalr.Action1;
import com.microsoft.signalr.HttpHubConnectionBuilder;
import com.microsoft.signalr.HubConnection;
import com.microsoft.signalr.HubConnectionBuilder;
import com.microsoft.signalr.OnClosedCallback;
import com.oneidentity.safeguard.safeguardjava.data.CertificateContext;
import com.oneidentity.safeguard.safeguardjava.event.DefaultDisconnectHandler;
import com.oneidentity.safeguard.safeguardjava.event.EventHandlerRegistry;
import com.oneidentity.safeguard.safeguardjava.event.IDisconnectHandler;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventHandler;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.exceptions.ArgumentException;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardEventListenerDisconnectedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import io.reactivex.rxjava3.core.Single;
import java.io.ByteArrayInputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;

public class SafeguardEventListener
implements ISafeguardEventListener,
AutoCloseable {
    private boolean disposed;
    private final String eventUrl;
    private final boolean ignoreSsl;
    private final HostnameVerifier validationCallback;
    private char[] accessToken;
    private char[] apiKey;
    private List<char[]> apiKeys;
    private CertificateContext clientCertificate;
    private EventHandlerRegistry eventHandlerRegistry;
    private IDisconnectHandler disconnectHandler;
    private HubConnection signalrConnection = null;
    private static final String NOTIFICATION_HUB = "signalr";
    private boolean _isStarted = false;
    TrustManager[] _trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};

    private SafeguardEventListener(String eventUrl, boolean ignoreSsl, HostnameVerifier validationCallback) {
        this.eventUrl = String.format("%s/%s", eventUrl, NOTIFICATION_HUB);
        this.ignoreSsl = ignoreSsl;
        this.validationCallback = validationCallback;
        this.eventHandlerRegistry = new EventHandlerRegistry();
        this.accessToken = null;
        this.apiKey = null;
        this.apiKeys = null;
        this.clientCertificate = null;
        this.disconnectHandler = new DefaultDisconnectHandler();
    }

    public SafeguardEventListener(String eventUrl, char[] accessToken, boolean ignoreSsl, HostnameVerifier validationCallback) throws ArgumentException {
        this(eventUrl, ignoreSsl, validationCallback);
        if (accessToken == null) {
            throw new ArgumentException("The accessToken parameter can not be null");
        }
        this.accessToken = (char[])accessToken.clone();
    }

    public SafeguardEventListener(String eventUrl, String clientCertificatePath, char[] certificatePassword, String certificateAlias, char[] apiKey, boolean ignoreSsl, HostnameVerifier validationCallback) throws ArgumentException {
        this(eventUrl, ignoreSsl, validationCallback);
        if (apiKey == null) {
            throw new ArgumentException("The apiKey parameter can not be null");
        }
        this.apiKey = (char[])apiKey.clone();
        this.clientCertificate = new CertificateContext(certificateAlias, clientCertificatePath, null, certificatePassword);
    }

    public SafeguardEventListener(String eventUrl, CertificateContext clientCertificate, char[] apiKey, boolean ignoreSsl, HostnameVerifier validationCallback) throws ArgumentException {
        this(eventUrl, ignoreSsl, validationCallback);
        if (apiKey == null) {
            throw new ArgumentException("The apiKey parameter can not be null");
        }
        this.clientCertificate = clientCertificate.cloneObject();
        this.apiKey = (char[])apiKey.clone();
    }

    public SafeguardEventListener(String eventUrl, String clientCertificatePath, char[] certificatePassword, String certificateAlias, List<char[]> apiKeys, boolean ignoreSsl, HostnameVerifier validationCallback) throws ArgumentException {
        this(eventUrl, ignoreSsl, validationCallback);
        if (apiKeys == null) {
            throw new ArgumentException("The apiKey parameter can not be null");
        }
        this.clientCertificate = new CertificateContext(certificateAlias, clientCertificatePath, null, certificatePassword);
        this.apiKeys = new ArrayList<char[]>();
        for (char[] key : apiKeys) {
            apiKeys.add((char[])key.clone());
        }
        if (apiKeys.isEmpty()) {
            throw new ArgumentException("The apiKeys parameter must include at least one item");
        }
    }

    public SafeguardEventListener(String eventUrl, CertificateContext clientCertificate, List<char[]> apiKeys, boolean ignoreSsl, HostnameVerifier validationCallback) throws ArgumentException {
        this(eventUrl, ignoreSsl, validationCallback);
        if (apiKeys == null) {
            throw new ArgumentException("The apiKeys parameter can not be null");
        }
        this.clientCertificate = clientCertificate.cloneObject();
        this.apiKeys = new ArrayList<char[]>();
        for (char[] key : apiKeys) {
            apiKeys.add((char[])key.clone());
        }
        if (apiKeys.isEmpty()) {
            throw new ArgumentException("The apiKeys parameter must include at least one item");
        }
    }

    public void setDisconnectHandler(IDisconnectHandler handler) {
        this.disconnectHandler = handler;
    }

    public void setEventHandlerRegistry(EventHandlerRegistry registry) {
        this.eventHandlerRegistry = registry;
    }

    @Override
    public boolean isStarted() {
        return this._isStarted;
    }

    @Override
    public void registerEventHandler(String eventName, ISafeguardEventHandler handler) throws ObjectDisposedException {
        if (this.disposed) {
            throw new ObjectDisposedException("SafeguardEventListener");
        }
        this.eventHandlerRegistry.registerEventHandler(eventName, handler);
    }

    @Override
    public void start() throws ObjectDisposedException, SafeguardForJavaException, SafeguardEventListenerDisconnectedException {
        if (this.disposed) {
            throw new ObjectDisposedException("SafeguardEventListener");
        }
        this.cleanupConnection();
        this._isStarted = true;
        this.signalrConnection = this.CreateConnection(this.eventUrl);
        this.signalrConnection.on("NotifyEventAsync", message -> this.handleEvent((JsonElement)message), JsonElement.class);
        this.signalrConnection.onClosed(new OnClosedCallback(){

            @Override
            public void invoke(Exception exception) {
                try {
                    if (exception != null) {
                        Logger.getLogger(SafeguardEventListener.class.getName()).log(Level.WARNING, "SignalR error detected!", exception);
                    }
                    SafeguardEventListener.this.handleDisconnect();
                }
                catch (SafeguardEventListenerDisconnectedException ex) {
                    Logger.getLogger(SafeguardEventListener.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        try {
            this.signalrConnection.start().blockingAwait();
        }
        catch (Exception error) {
            throw new SafeguardForJavaException(String.format("Failed to start signalr connection: %s", error.getMessage()), error);
        }
    }

    @Override
    public void stop() throws ObjectDisposedException, SafeguardForJavaException {
        if (this.disposed) {
            throw new ObjectDisposedException("SafeguardEventListener");
        }
        try {
            this.cleanupConnection();
        }
        catch (Exception ex) {
            throw new SafeguardForJavaException("Failure stopping SignalR.", ex);
        }
    }

    @Override
    public void close() throws Exception {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.cleanupConnection();
        if (this.clientCertificate != null) {
            this.clientCertificate.dispose();
        }
        if (this.apiKey != null) {
            Arrays.fill(this.apiKey, '0');
        }
        if (this.apiKeys != null) {
            for (char[] key : this.apiKeys) {
                Arrays.fill(key, '0');
            }
        }
        if (this.accessToken != null) {
            Arrays.fill(this.accessToken, '0');
        }
        this.disposed = true;
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanupConnection();
            if (this.clientCertificate != null) {
                this.clientCertificate.dispose();
            }
            if (this.apiKey != null) {
                Arrays.fill(this.apiKey, '0');
            }
            if (this.apiKeys != null) {
                for (char[] key : this.apiKeys) {
                    Arrays.fill(key, '0');
                }
            }
            if (this.accessToken != null) {
                Arrays.fill(this.accessToken, '0');
            }
            this.disposed = true;
        }
        finally {
            this.disposed = true;
            super.finalize();
        }
    }

    private void handleEvent(JsonElement eventObject) {
        this.eventHandlerRegistry.handleEvent(eventObject);
    }

    private void handleDisconnect() throws SafeguardEventListenerDisconnectedException {
        if (!this.isStarted()) {
            return;
        }
        Logger.getLogger(EventHandlerRegistry.class.getName()).log(Level.WARNING, "SignalR disconnect detected, calling handler...");
        this.disconnectHandler.func();
    }

    private void cleanupConnection() {
        try {
            this._isStarted = false;
            if (this.signalrConnection != null) {
                this.signalrConnection.stop().blockingAwait();
                this.signalrConnection.close();
            }
        }
        finally {
            this.signalrConnection = null;
        }
    }

    private HubConnection CreateConnection(String eventUrl) throws SafeguardForJavaException {
        HttpHubConnectionBuilder builder = HubConnectionBuilder.create(eventUrl);
        if (this.accessToken != null) {
            builder.withAccessTokenProvider(Single.just(new String(this.accessToken)));
        } else {
            String authKey = "";
            if (this.apiKey != null) {
                authKey = new String(this.apiKey);
            } else if (this.apiKeys != null) {
                for (char[] key : this.apiKeys) {
                    authKey = authKey + new String(key) + " ";
                }
                authKey = authKey.trim();
            }
            if (authKey.isEmpty()) {
                throw new SafeguardForJavaException("No API keys found in the authorization header");
            }
            builder.withHeader("Authorization", String.format("A2A %s", authKey));
        }
        builder.setHttpClientBuilderCallback(new Action1<OkHttpClient.Builder>(){

            @Override
            public void invoke(OkHttpClient.Builder builder) {
                SafeguardEventListener.this.ConfigureHttpClientBuilder(builder);
            }
        });
        return builder.build();
    }

    private void ConfigureHttpClientBuilder(OkHttpClient.Builder builder) {
        if (this.validationCallback != null) {
            builder.hostnameVerifier(this.validationCallback);
        }
        KeyManager[] km = null;
        if (this.clientCertificate != null) {
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                ByteArrayInputStream inputStream2 = new ByteArrayInputStream(this.clientCertificate.getCertificateData());
                keyStore.load(inputStream2, this.clientCertificate.getCertificatePassword());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, this.clientCertificate.getCertificatePassword());
                km = keyManagerFactory.getKeyManagers();
                builder.protocols(Arrays.asList(Protocol.HTTP_1_1));
            }
            catch (Exception error) {
                String msg = String.format("Error setting client authentication certificate: %s", error.getMessage());
                Logger.getLogger(SafeguardEventListener.class.getName()).log(Level.SEVERE, msg);
            }
        }
        try {
            Object[] tm = null;
            X509TrustManager x509tm = null;
            if (this.ignoreSsl) {
                tm = this._trustAllCerts;
                x509tm = (X509TrustManager)this._trustAllCerts[0];
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                tm = trustManagerFactory.getTrustManagers();
                if (tm.length != 1 || !(tm[0] instanceof X509TrustManager)) {
                    throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(tm));
                }
                x509tm = (X509TrustManager)tm[0];
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(km, (TrustManager[])tm, null);
            builder.sslSocketFactory(sslContext.getSocketFactory(), x509tm);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(SafeguardEventListener.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
        catch (KeyManagementException ex) {
            Logger.getLogger(SafeguardEventListener.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
        catch (KeyStoreException ex) {
            Logger.getLogger(SafeguardEventListener.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
    }
}

